/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.batch;

import org.eximeebpms.bpm.engine.impl.batch.BatchEntity;
import org.eximeebpms.bpm.engine.impl.batch.BatchJobHandler;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.jobexecutor.JobHandler;
import org.eximeebpms.bpm.engine.impl.jobexecutor.JobHandlerConfiguration;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.JobEntity;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;

public class BatchSeedJobHandler
implements JobHandler<BatchSeedJobConfiguration> {
    public static final String TYPE = "batch-seed-job";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void execute(BatchSeedJobConfiguration configuration, ExecutionEntity execution, CommandContext commandContext, String tenantId) {
        String batchId = configuration.getBatchId();
        BatchEntity batch = commandContext.getBatchManager().findBatchById(batchId);
        EnsureUtil.ensureNotNull("Batch with id '" + batchId + "' cannot be found", "batch", (Object)batch);
        BatchJobHandler<?> batchJobHandler = commandContext.getProcessEngineConfiguration().getBatchHandlers().get(batch.getType());
        boolean done = batchJobHandler.createJobs(batch);
        if (!done) {
            batch.createSeedJob();
        } else {
            batch.createMonitorJob(false);
        }
    }

    @Override
    public BatchSeedJobConfiguration newConfiguration(String canonicalString) {
        return new BatchSeedJobConfiguration(canonicalString);
    }

    @Override
    public void onDelete(BatchSeedJobConfiguration configuration, JobEntity jobEntity) {
    }

    public static class BatchSeedJobConfiguration
    implements JobHandlerConfiguration {
        protected String batchId;

        public BatchSeedJobConfiguration(String batchId) {
            this.batchId = batchId;
        }

        public String getBatchId() {
            return this.batchId;
        }

        @Override
        public String toCanonicalString() {
            return this.batchId;
        }
    }
}

