/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.batch;

import org.eximeebpms.bpm.engine.BadUserRequestException;
import org.eximeebpms.bpm.engine.impl.batch.BatchEntity;
import org.eximeebpms.bpm.engine.impl.cfg.CommandChecker;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.entity.PropertyChange;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;

public class DeleteBatchCmd
implements Command<Void> {
    protected boolean cascadeToHistory;
    protected String batchId;

    public DeleteBatchCmd(String batchId, boolean cascadeToHistory) {
        this.batchId = batchId;
        this.cascadeToHistory = cascadeToHistory;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "Batch id must not be null", "batch id", (Object)this.batchId);
        BatchEntity batchEntity = commandContext.getBatchManager().findBatchById(this.batchId);
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "Batch for id '" + this.batchId + "' cannot be found", "batch", (Object)batchEntity);
        this.checkAccess(commandContext, batchEntity);
        this.writeUserOperationLog(commandContext, batchEntity.getTenantId());
        batchEntity.delete(this.cascadeToHistory, true);
        return null;
    }

    protected void checkAccess(CommandContext commandContext, BatchEntity batch) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkDeleteBatch(batch);
        }
    }

    protected void writeUserOperationLog(CommandContext commandContext, String tenantId) {
        commandContext.getOperationLogManager().logBatchOperation("Delete", this.batchId, tenantId, new PropertyChange("cascadeToHistory", null, this.cascadeToHistory));
    }
}

