/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.batch.message;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eximeebpms.bpm.engine.impl.MessageCorrelationBuilderImpl;
import org.eximeebpms.bpm.engine.impl.batch.AbstractBatchJobHandler;
import org.eximeebpms.bpm.engine.impl.batch.BatchJobContext;
import org.eximeebpms.bpm.engine.impl.batch.BatchJobDeclaration;
import org.eximeebpms.bpm.engine.impl.batch.message.MessageCorrelationBatchConfiguration;
import org.eximeebpms.bpm.engine.impl.cmd.CorrelateAllMessageCmd;
import org.eximeebpms.bpm.engine.impl.core.variable.VariableUtil;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.jobexecutor.JobDeclaration;
import org.eximeebpms.bpm.engine.impl.json.MessageCorrelationBatchConfigurationJsonConverter;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.JobEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.MessageEntity;
import org.eximeebpms.bpm.engine.runtime.MessageCorrelationBuilder;
import org.eximeebpms.bpm.engine.variable.impl.VariableMapImpl;

public class MessageCorrelationBatchJobHandler
extends AbstractBatchJobHandler<MessageCorrelationBatchConfiguration> {
    public static final BatchJobDeclaration JOB_DECLARATION = new BatchJobDeclaration("correlate-message");

    @Override
    public String getType() {
        return "correlate-message";
    }

    @Override
    public JobDeclaration<BatchJobContext, MessageEntity> getJobDeclaration() {
        return JOB_DECLARATION;
    }

    protected MessageCorrelationBatchConfigurationJsonConverter getJsonConverterInstance() {
        return MessageCorrelationBatchConfigurationJsonConverter.INSTANCE;
    }

    @Override
    protected MessageCorrelationBatchConfiguration createJobConfiguration(MessageCorrelationBatchConfiguration configuration, List<String> processIdsForJob) {
        return new MessageCorrelationBatchConfiguration(processIdsForJob, configuration.getMessageName(), configuration.getBatchId());
    }

    @Override
    protected void postProcessJob(MessageCorrelationBatchConfiguration configuration, JobEntity job, MessageCorrelationBatchConfiguration jobConfiguration) {
        if (jobConfiguration.getIds() != null && jobConfiguration.getIds().size() == 1) {
            job.setProcessInstanceId(jobConfiguration.getIds().get(0));
        }
    }

    @Override
    public void executeHandler(MessageCorrelationBatchConfiguration batchConfiguration, ExecutionEntity execution, CommandContext commandContext, String tenantId) {
        String batchId = batchConfiguration.getBatchId();
        MessageCorrelationBuilderImpl correlationBuilder = new MessageCorrelationBuilderImpl(commandContext, batchConfiguration.getMessageName());
        correlationBuilder.executionsOnly();
        this.setVariables(batchId, correlationBuilder, commandContext);
        for (String id : batchConfiguration.getIds()) {
            correlationBuilder.processInstanceId(id);
            commandContext.executeWithOperationLogPrevented(new CorrelateAllMessageCmd(correlationBuilder, false, false));
        }
    }

    protected void setVariables(String batchId, MessageCorrelationBuilder correlationBuilder, CommandContext commandContext) {
        Map<String, ?> variables = null;
        if (batchId != null && (variables = VariableUtil.findBatchVariablesSerialized(batchId, commandContext)) != null) {
            correlationBuilder.setVariables((Map<String, Object>)new VariableMapImpl(new HashMap(variables)));
        }
    }
}

