/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.batch.variables;

import java.util.List;
import java.util.Map;
import org.eximeebpms.bpm.engine.impl.batch.AbstractBatchJobHandler;
import org.eximeebpms.bpm.engine.impl.batch.BatchConfiguration;
import org.eximeebpms.bpm.engine.impl.batch.BatchJobContext;
import org.eximeebpms.bpm.engine.impl.batch.BatchJobDeclaration;
import org.eximeebpms.bpm.engine.impl.batch.variables.SetVariablesJsonConverter;
import org.eximeebpms.bpm.engine.impl.cmd.SetExecutionVariablesCmd;
import org.eximeebpms.bpm.engine.impl.core.variable.VariableUtil;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.jobexecutor.JobDeclaration;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.JobEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.MessageEntity;

public class BatchSetVariablesHandler
extends AbstractBatchJobHandler<BatchConfiguration> {
    public static final BatchJobDeclaration JOB_DECLARATION = new BatchJobDeclaration("set-variables");

    @Override
    public void executeHandler(BatchConfiguration batchConfiguration, ExecutionEntity execution, CommandContext commandContext, String tenantId) {
        String batchId = batchConfiguration.getBatchId();
        Map<String, ?> variables = VariableUtil.findBatchVariablesSerialized(batchId, commandContext);
        List<String> processInstanceIds = batchConfiguration.getIds();
        for (String processInstanceId : processInstanceIds) {
            commandContext.executeWithOperationLogPrevented(new SetExecutionVariablesCmd(processInstanceId, variables, false, true, false));
        }
    }

    @Override
    public JobDeclaration<BatchJobContext, MessageEntity> getJobDeclaration() {
        return JOB_DECLARATION;
    }

    @Override
    protected BatchConfiguration createJobConfiguration(BatchConfiguration configuration, List<String> processIdsForJob) {
        return new BatchConfiguration(processIdsForJob);
    }

    protected SetVariablesJsonConverter getJsonConverterInstance() {
        return SetVariablesJsonConverter.INSTANCE;
    }

    @Override
    public String getType() {
        return "set-variables";
    }

    @Override
    protected void postProcessJob(BatchConfiguration configuration, JobEntity job, BatchConfiguration jobConfiguration) {
        if (jobConfiguration.getIds() != null && jobConfiguration.getIds().size() == 1) {
            job.setProcessInstanceId(jobConfiguration.getIds().get(0));
        }
    }

    protected ByteArrayEntity findByteArrayById(String byteArrayId, CommandContext commandContext) {
        return commandContext.getDbEntityManager().selectById(ByteArrayEntity.class, byteArrayId);
    }
}

