/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.bpmn.behavior;

import java.util.concurrent.Callable;
import org.eximeebpms.bpm.engine.delegate.BpmnError;
import org.eximeebpms.bpm.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.eximeebpms.bpm.engine.impl.context.Context;
import org.eximeebpms.bpm.engine.impl.delegate.ScriptInvocation;
import org.eximeebpms.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.eximeebpms.bpm.engine.impl.scripting.ExecutableScript;

public class ScriptTaskActivityBehavior
extends TaskActivityBehavior {
    protected ExecutableScript script;
    protected String resultVariable;

    public ScriptTaskActivityBehavior(ExecutableScript script, String resultVariable) {
        this.script = script;
        this.resultVariable = resultVariable;
    }

    @Override
    public void performExecution(final ActivityExecution execution) throws Exception {
        this.executeWithErrorPropagation(execution, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ScriptInvocation invocation = new ScriptInvocation(ScriptTaskActivityBehavior.this.script, execution);
                Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(invocation);
                Object result = invocation.getInvocationResult();
                if (result != null && ScriptTaskActivityBehavior.this.resultVariable != null) {
                    execution.setVariable(ScriptTaskActivityBehavior.this.resultVariable, result);
                }
                ScriptTaskActivityBehavior.this.leave(execution);
                return null;
            }
        });
    }

    protected BpmnError checkIfCauseOfExceptionIsBpmnError(Throwable e) {
        if (e instanceof BpmnError) {
            return (BpmnError)e;
        }
        if (e.getCause() == null) {
            return null;
        }
        return this.checkIfCauseOfExceptionIsBpmnError(e.getCause());
    }

    public ExecutableScript getScript() {
        return this.script;
    }
}

