/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.bpmn.parser;

import java.io.InputStream;
import java.net.URL;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eximeebpms.bpm.engine.BpmnParseException;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.delegate.ExecutionListener;
import org.eximeebpms.bpm.engine.delegate.TaskListener;
import org.eximeebpms.bpm.engine.impl.Condition;
import org.eximeebpms.bpm.engine.impl.HistoryTimeToLiveParser;
import org.eximeebpms.bpm.engine.impl.ProcessEngineLogger;
import org.eximeebpms.bpm.engine.impl.bpmn.behavior.BoundaryConditionalEventActivityBehavior;
import org.eximeebpms.bpm.engine.impl.bpmn.behavior.BoundaryEventActivityBehavior;
import org.eximeebpms.bpm.engine.impl.bpmn.behavior.CallActivityBehavior;
import org.eximeebpms.bpm.engine.impl.bpmn.behavior.CallableElementActivityBehavior;
import org.eximeebpms.bpm.engine.impl.bpmn.behavior.CancelBoundaryEventActivityBehavior;
import org.eximeebpms.bpm.engine.impl.bpmn.behavior.CancelEndEventActivityBehavior;
import org.eximeebpms.bpm.engine.impl.bpmn.behavior.CaseCallActivityBehavior;
import org.eximeebpms.bpm.engine.impl.bpmn.behavior.ClassDelegateActivityBehavior;
import org.eximeebpms.bpm.engine.impl.bpmn.behavior.CompensationEventActivityBehavior;
import org.eximeebpms.bpm.engine.impl.bpmn.behavior.DmnBusinessRuleTaskActivityBehavior;
import org.eximeebpms.bpm.engine.impl.bpmn.behavior.ErrorEndEventActivityBehavior;
import org.eximeebpms.bpm.engine.impl.bpmn.behavior.EventBasedGatewayActivityBehavior;
import org.eximeebpms.bpm.engine.impl.bpmn.behavior.EventSubProcessActivityBehavior;
import org.eximeebpms.bpm.engine.impl.bpmn.behavior.EventSubProcessStartConditionalEventActivityBehavior;
import org.eximeebpms.bpm.engine.impl.bpmn.behavior.EventSubProcessStartEventActivityBehavior;
import org.eximeebpms.bpm.engine.impl.bpmn.behavior.ExclusiveGatewayActivityBehavior;
import org.eximeebpms.bpm.engine.impl.bpmn.behavior.ExternalTaskActivityBehavior;
import org.eximeebpms.bpm.engine.impl.bpmn.behavior.FlowNodeActivityBehavior;
import org.eximeebpms.bpm.engine.impl.bpmn.behavior.InclusiveGatewayActivityBehavior;
import org.eximeebpms.bpm.engine.impl.bpmn.behavior.IntermediateCatchEventActivityBehavior;
import org.eximeebpms.bpm.engine.impl.bpmn.behavior.IntermediateCatchLinkEventActivityBehavior;
import org.eximeebpms.bpm.engine.impl.bpmn.behavior.IntermediateConditionalEventBehavior;
import org.eximeebpms.bpm.engine.impl.bpmn.behavior.IntermediateThrowNoneEventActivityBehavior;
import org.eximeebpms.bpm.engine.impl.bpmn.behavior.MailActivityBehavior;
import org.eximeebpms.bpm.engine.impl.bpmn.behavior.ManualTaskActivityBehavior;
import org.eximeebpms.bpm.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.eximeebpms.bpm.engine.impl.bpmn.behavior.NoneEndEventActivityBehavior;
import org.eximeebpms.bpm.engine.impl.bpmn.behavior.NoneStartEventActivityBehavior;
import org.eximeebpms.bpm.engine.impl.bpmn.behavior.ParallelGatewayActivityBehavior;
import org.eximeebpms.bpm.engine.impl.bpmn.behavior.ParallelMultiInstanceActivityBehavior;
import org.eximeebpms.bpm.engine.impl.bpmn.behavior.ReceiveTaskActivityBehavior;
import org.eximeebpms.bpm.engine.impl.bpmn.behavior.ScriptTaskActivityBehavior;
import org.eximeebpms.bpm.engine.impl.bpmn.behavior.SequentialMultiInstanceActivityBehavior;
import org.eximeebpms.bpm.engine.impl.bpmn.behavior.ServiceTaskDelegateExpressionActivityBehavior;
import org.eximeebpms.bpm.engine.impl.bpmn.behavior.ServiceTaskExpressionActivityBehavior;
import org.eximeebpms.bpm.engine.impl.bpmn.behavior.ShellActivityBehavior;
import org.eximeebpms.bpm.engine.impl.bpmn.behavior.SubProcessActivityBehavior;
import org.eximeebpms.bpm.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.eximeebpms.bpm.engine.impl.bpmn.behavior.TerminateEndEventActivityBehavior;
import org.eximeebpms.bpm.engine.impl.bpmn.behavior.ThrowEscalationEventActivityBehavior;
import org.eximeebpms.bpm.engine.impl.bpmn.behavior.ThrowSignalEventActivityBehavior;
import org.eximeebpms.bpm.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import org.eximeebpms.bpm.engine.impl.bpmn.helper.BpmnProperties;
import org.eximeebpms.bpm.engine.impl.bpmn.listener.ClassDelegateExecutionListener;
import org.eximeebpms.bpm.engine.impl.bpmn.listener.DelegateExpressionExecutionListener;
import org.eximeebpms.bpm.engine.impl.bpmn.listener.ExpressionExecutionListener;
import org.eximeebpms.bpm.engine.impl.bpmn.listener.ScriptExecutionListener;
import org.eximeebpms.bpm.engine.impl.bpmn.parser.BpmnParseListener;
import org.eximeebpms.bpm.engine.impl.bpmn.parser.BpmnParseLogger;
import org.eximeebpms.bpm.engine.impl.bpmn.parser.BpmnParseUtil;
import org.eximeebpms.bpm.engine.impl.bpmn.parser.BpmnParser;
import org.eximeebpms.bpm.engine.impl.bpmn.parser.CamundaErrorEventDefinition;
import org.eximeebpms.bpm.engine.impl.bpmn.parser.CompensateEventDefinition;
import org.eximeebpms.bpm.engine.impl.bpmn.parser.ConditionalEventDefinition;
import org.eximeebpms.bpm.engine.impl.bpmn.parser.Error;
import org.eximeebpms.bpm.engine.impl.bpmn.parser.ErrorEventDefinition;
import org.eximeebpms.bpm.engine.impl.bpmn.parser.Escalation;
import org.eximeebpms.bpm.engine.impl.bpmn.parser.EscalationEventDefinition;
import org.eximeebpms.bpm.engine.impl.bpmn.parser.EventSubscriptionDeclaration;
import org.eximeebpms.bpm.engine.impl.bpmn.parser.FieldDeclaration;
import org.eximeebpms.bpm.engine.impl.bpmn.parser.MessageDefinition;
import org.eximeebpms.bpm.engine.impl.bpmn.parser.SignalDefinition;
import org.eximeebpms.bpm.engine.impl.bpmn.parser.XMLImporter;
import org.eximeebpms.bpm.engine.impl.context.Context;
import org.eximeebpms.bpm.engine.impl.core.model.BaseCallableElement;
import org.eximeebpms.bpm.engine.impl.core.model.CallableElement;
import org.eximeebpms.bpm.engine.impl.core.model.CallableElementParameter;
import org.eximeebpms.bpm.engine.impl.core.model.Properties;
import org.eximeebpms.bpm.engine.impl.core.variable.mapping.IoMapping;
import org.eximeebpms.bpm.engine.impl.core.variable.mapping.value.ConstantValueProvider;
import org.eximeebpms.bpm.engine.impl.core.variable.mapping.value.NullValueProvider;
import org.eximeebpms.bpm.engine.impl.core.variable.mapping.value.ParameterValueProvider;
import org.eximeebpms.bpm.engine.impl.dmn.result.DecisionResultMapper;
import org.eximeebpms.bpm.engine.impl.el.ElValueProvider;
import org.eximeebpms.bpm.engine.impl.el.Expression;
import org.eximeebpms.bpm.engine.impl.el.ExpressionManager;
import org.eximeebpms.bpm.engine.impl.el.FixedValue;
import org.eximeebpms.bpm.engine.impl.el.UelExpressionCondition;
import org.eximeebpms.bpm.engine.impl.event.EventType;
import org.eximeebpms.bpm.engine.impl.form.FormDefinition;
import org.eximeebpms.bpm.engine.impl.form.handler.DefaultStartFormHandler;
import org.eximeebpms.bpm.engine.impl.form.handler.DefaultTaskFormHandler;
import org.eximeebpms.bpm.engine.impl.form.handler.DelegateStartFormHandler;
import org.eximeebpms.bpm.engine.impl.form.handler.DelegateTaskFormHandler;
import org.eximeebpms.bpm.engine.impl.form.handler.StartFormHandler;
import org.eximeebpms.bpm.engine.impl.form.handler.TaskFormHandler;
import org.eximeebpms.bpm.engine.impl.jobexecutor.AsyncAfterMessageJobDeclaration;
import org.eximeebpms.bpm.engine.impl.jobexecutor.AsyncBeforeMessageJobDeclaration;
import org.eximeebpms.bpm.engine.impl.jobexecutor.EventSubscriptionJobDeclaration;
import org.eximeebpms.bpm.engine.impl.jobexecutor.JobDeclaration;
import org.eximeebpms.bpm.engine.impl.jobexecutor.MessageJobDeclaration;
import org.eximeebpms.bpm.engine.impl.jobexecutor.TimerDeclarationImpl;
import org.eximeebpms.bpm.engine.impl.jobexecutor.TimerDeclarationType;
import org.eximeebpms.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.eximeebpms.bpm.engine.impl.pvm.PvmTransition;
import org.eximeebpms.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.eximeebpms.bpm.engine.impl.pvm.process.ActivityImpl;
import org.eximeebpms.bpm.engine.impl.pvm.process.ActivityStartBehavior;
import org.eximeebpms.bpm.engine.impl.pvm.process.HasDIBounds;
import org.eximeebpms.bpm.engine.impl.pvm.process.Lane;
import org.eximeebpms.bpm.engine.impl.pvm.process.LaneSet;
import org.eximeebpms.bpm.engine.impl.pvm.process.ParticipantProcess;
import org.eximeebpms.bpm.engine.impl.pvm.process.ScopeImpl;
import org.eximeebpms.bpm.engine.impl.pvm.process.TransitionImpl;
import org.eximeebpms.bpm.engine.impl.pvm.runtime.LegacyBehavior;
import org.eximeebpms.bpm.engine.impl.scripting.ExecutableScript;
import org.eximeebpms.bpm.engine.impl.scripting.ScriptCondition;
import org.eximeebpms.bpm.engine.impl.task.TaskDecorator;
import org.eximeebpms.bpm.engine.impl.task.TaskDefinition;
import org.eximeebpms.bpm.engine.impl.task.listener.ClassDelegateTaskListener;
import org.eximeebpms.bpm.engine.impl.task.listener.DelegateExpressionTaskListener;
import org.eximeebpms.bpm.engine.impl.task.listener.ExpressionTaskListener;
import org.eximeebpms.bpm.engine.impl.task.listener.ScriptTaskListener;
import org.eximeebpms.bpm.engine.impl.util.ClassDelegateUtil;
import org.eximeebpms.bpm.engine.impl.util.DecisionEvaluationUtil;
import org.eximeebpms.bpm.engine.impl.util.ReflectUtil;
import org.eximeebpms.bpm.engine.impl.util.ScriptUtil;
import org.eximeebpms.bpm.engine.impl.util.StringUtil;
import org.eximeebpms.bpm.engine.impl.util.xml.Element;
import org.eximeebpms.bpm.engine.impl.util.xml.Namespace;
import org.eximeebpms.bpm.engine.impl.util.xml.Parse;
import org.eximeebpms.bpm.engine.impl.variable.VariableDeclaration;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;

public class BpmnParse
extends Parse {
    public static final String MULTI_INSTANCE_BODY_ID_SUFFIX = "#multiInstanceBody";
    protected static final BpmnParseLogger LOG = ProcessEngineLogger.BPMN_PARSE_LOGGER;
    public static final String PROPERTYNAME_DOCUMENTATION = "documentation";
    public static final String PROPERTYNAME_INITIATOR_VARIABLE_NAME = "initiatorVariableName";
    public static final String PROPERTYNAME_HAS_CONDITIONAL_EVENTS = "hasConditionalEvents";
    public static final String PROPERTYNAME_CONDITION = "condition";
    public static final String PROPERTYNAME_CONDITION_TEXT = "conditionText";
    public static final String PROPERTYNAME_VARIABLE_DECLARATIONS = "variableDeclarations";
    public static final String PROPERTYNAME_TIMER_DECLARATION = "timerDeclarations";
    public static final String PROPERTYNAME_MESSAGE_JOB_DECLARATION = "messageJobDeclaration";
    public static final String PROPERTYNAME_ISEXPANDED = "isExpanded";
    public static final String PROPERTYNAME_START_TIMER = "timerStart";
    public static final String PROPERTYNAME_COMPENSATION_HANDLER_ID = "compensationHandler";
    public static final String PROPERTYNAME_IS_FOR_COMPENSATION = "isForCompensation";
    public static final String PROPERTYNAME_EVENT_SUBSCRIPTION_JOB_DECLARATION = "eventJobDeclarations";
    public static final String PROPERTYNAME_THROWS_COMPENSATION = "throwsCompensation";
    public static final String PROPERTYNAME_CONSUMES_COMPENSATION = "consumesCompensation";
    public static final String PROPERTYNAME_JOB_PRIORITY = "jobPriority";
    public static final String PROPERTYNAME_TASK_PRIORITY = "taskPriority";
    public static final String PROPERTYNAME_EXTERNAL_TASK_TOPIC = "topic";
    public static final String PROPERTYNAME_CLASS = "class";
    public static final String PROPERTYNAME_EXPRESSION = "expression";
    public static final String PROPERTYNAME_DELEGATE_EXPRESSION = "delegateExpression";
    public static final String PROPERTYNAME_VARIABLE_MAPPING_CLASS = "variableMappingClass";
    public static final String PROPERTYNAME_VARIABLE_MAPPING_DELEGATE_EXPRESSION = "variableMappingDelegateExpression";
    public static final String PROPERTYNAME_RESOURCE = "resource";
    public static final String PROPERTYNAME_LANGUAGE = "language";
    public static final String TYPE = "type";
    public static final String TRUE = "true";
    public static final String INTERRUPTING = "isInterrupting";
    public static final String CONDITIONAL_EVENT_DEFINITION = "conditionalEventDefinition";
    public static final String ESCALATION_EVENT_DEFINITION = "escalationEventDefinition";
    public static final String COMPENSATE_EVENT_DEFINITION = "compensateEventDefinition";
    public static final String TIMER_EVENT_DEFINITION = "timerEventDefinition";
    public static final String SIGNAL_EVENT_DEFINITION = "signalEventDefinition";
    public static final String MESSAGE_EVENT_DEFINITION = "messageEventDefinition";
    public static final String ERROR_EVENT_DEFINITION = "errorEventDefinition";
    public static final String CANCEL_EVENT_DEFINITION = "cancelEventDefinition";
    public static final String LINK_EVENT_DEFINITION = "linkEventDefinition";
    public static final String CONDITION_EXPRESSION = "conditionExpression";
    public static final String CONDITION = "condition";
    public static final List<String> VARIABLE_EVENTS = Arrays.asList("create", "delete", "update");
    @Deprecated
    public static final String PROPERTYNAME_TYPE = BpmnProperties.TYPE.getName();
    @Deprecated
    public static final String PROPERTYNAME_ERROR_EVENT_DEFINITIONS = BpmnProperties.ERROR_EVENT_DEFINITIONS.getName();
    protected static final String POTENTIAL_STARTER = "potentialStarter";
    protected static final String CANDIDATE_STARTER_USERS_EXTENSION = "candidateStarterUsers";
    protected static final String CANDIDATE_STARTER_GROUPS_EXTENSION = "candidateStarterGroups";
    protected static final String ATTRIBUTEVALUE_T_FORMAL_EXPRESSION = "http://www.omg.org/spec/BPMN/20100524/MODEL:tFormalExpression";
    public static final String PROPERTYNAME_IS_MULTI_INSTANCE = "isMultiInstance";
    public static final Namespace CAMUNDA_BPMN_EXTENSIONS_NS = new Namespace("http://camunda.org/schema/1.0/bpmn", "http://activiti.org/bpmn");
    public static final Namespace XSI_NS = new Namespace("http://www.w3.org/2001/XMLSchema-instance");
    public static final Namespace BPMN_DI_NS = new Namespace("http://www.omg.org/spec/BPMN/20100524/DI");
    public static final Namespace OMG_DI_NS = new Namespace("http://www.omg.org/spec/DD/20100524/DI");
    public static final Namespace BPMN_DC_NS = new Namespace("http://www.omg.org/spec/DD/20100524/DC");
    public static final String ALL = "all";
    protected DeploymentEntity deployment;
    protected List<ProcessDefinitionEntity> processDefinitions = new ArrayList<ProcessDefinitionEntity>();
    protected Map<String, Error> errors = new HashMap<String, Error>();
    protected Map<String, Escalation> escalations = new HashMap<String, Escalation>();
    protected Map<String, List<JobDeclaration<?, ?>>> jobDeclarations = new HashMap();
    protected Map<String, TransitionImpl> sequenceFlows;
    protected List<String> elementIds = new ArrayList<String>();
    protected Map<String, String> participantProcesses = new HashMap<String, String>();
    protected Map<String, MessageDefinition> messages = new HashMap<String, MessageDefinition>();
    protected Map<String, SignalDefinition> signals = new HashMap<String, SignalDefinition>();
    protected ExpressionManager expressionManager;
    protected List<BpmnParseListener> parseListeners;
    protected Map<String, XMLImporter> importers = new HashMap<String, XMLImporter>();
    protected Map<String, String> prefixs = new HashMap<String, String>();
    protected String targetNamespace;
    private Map<String, String> eventLinkTargets = new HashMap<String, String>();
    private Map<String, String> eventLinkSources = new HashMap<String, String>();
    protected static final String HUMAN_PERFORMER = "humanPerformer";
    protected static final String POTENTIAL_OWNER = "potentialOwner";
    protected static final String RESOURCE_ASSIGNMENT_EXPR = "resourceAssignmentExpression";
    protected static final String FORMAL_EXPRESSION = "formalExpression";
    protected static final String USER_PREFIX = "user(";
    protected static final String GROUP_PREFIX = "group(";
    protected static final String ASSIGNEE_EXTENSION = "assignee";
    protected static final String CANDIDATE_USERS_EXTENSION = "candidateUsers";
    protected static final String CANDIDATE_GROUPS_EXTENSION = "candidateGroups";
    protected static final String DUE_DATE_EXTENSION = "dueDate";
    protected static final String FOLLOW_UP_DATE_EXTENSION = "followUpDate";
    protected static final String PRIORITY_EXTENSION = "priority";

    public BpmnParse(BpmnParser parser) {
        super(parser);
        this.expressionManager = parser.getExpressionManager();
        this.parseListeners = parser.getParseListeners();
        this.setSchemaResource(ReflectUtil.getResourceUrlAsString("org/eximeebpms/bpm/engine/impl/bpmn/parser/BPMN20.xsd"));
    }

    public BpmnParse deployment(DeploymentEntity deployment) {
        this.deployment = deployment;
        return this;
    }

    @Override
    public BpmnParse execute() {
        super.execute();
        try {
            this.parseRootElement();
        }
        catch (BpmnParseException e) {
            this.addError(e);
        }
        catch (Exception e) {
            LOG.parsingFailure(e);
            throw LOG.parsingProcessException(e);
        }
        finally {
            if (this.hasWarnings()) {
                this.logWarnings();
            }
            if (this.hasErrors()) {
                this.throwExceptionForErrors();
            }
        }
        return this;
    }

    protected void parseRootElement() {
        this.collectElementIds();
        this.parseDefinitionsAttributes();
        this.parseImports();
        this.parseMessages();
        this.parseSignals();
        this.parseErrors();
        this.parseEscalations();
        this.parseProcessDefinitions();
        this.parseCollaboration();
        this.parseDiagramInterchangeElements();
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseRootElement(this.rootElement, this.getProcessDefinitions());
        }
    }

    protected void collectElementIds() {
        this.rootElement.collectIds(this.elementIds);
    }

    protected void parseDefinitionsAttributes() {
        this.targetNamespace = this.rootElement.attribute("targetNamespace");
        for (String attribute : this.rootElement.attributes()) {
            if (!attribute.startsWith("xmlns:")) continue;
            String prefixValue = this.rootElement.attribute(attribute);
            String prefixName = attribute.substring(6);
            this.prefixs.put(prefixName, prefixValue);
        }
    }

    protected String resolveName(String name) {
        if (name == null) {
            return null;
        }
        int indexOfP = name.indexOf(58);
        if (indexOfP != -1) {
            String prefix = name.substring(0, indexOfP);
            String resolvedPrefix = this.prefixs.get(prefix);
            return resolvedPrefix + ":" + name.substring(indexOfP + 1);
        }
        return this.targetNamespace + ":" + name;
    }

    protected void parseImports() {
        List<Element> imports = this.rootElement.elements("import");
        for (Element theImport : imports) {
            String importType = theImport.attribute("importType");
            XMLImporter importer = this.getImporter(importType, theImport);
            if (importer == null) {
                this.addError("Could not import item of type " + importType, theImport);
                continue;
            }
            importer.importFrom(theImport, this);
        }
    }

    protected XMLImporter getImporter(String importType, Element theImport) {
        if (this.importers.containsKey(importType)) {
            return this.importers.get(importType);
        }
        if (importType.equals("http://schemas.xmlsoap.org/wsdl/")) {
            try {
                Class<?> wsdlImporterClass = Class.forName("org.eximeebpms.bpm.engine.impl.webservice.CxfWSDLImporter", true, Thread.currentThread().getContextClassLoader());
                XMLImporter newInstance = (XMLImporter)wsdlImporterClass.newInstance();
                this.importers.put(importType, newInstance);
                return newInstance;
            }
            catch (Exception e) {
                this.addError("Could not find importer for type " + importType, theImport);
            }
        }
        return null;
    }

    public void parseMessages() {
        for (Element messageElement : this.rootElement.elements("message")) {
            String id = messageElement.attribute("id");
            String messageName = messageElement.attribute("name");
            Expression messageExpression = null;
            if (messageName != null) {
                messageExpression = this.expressionManager.createExpression(messageName);
            }
            MessageDefinition messageDefinition = new MessageDefinition(this.targetNamespace + ":" + id, messageExpression);
            this.messages.put(messageDefinition.getId(), messageDefinition);
        }
    }

    protected void parseSignals() {
        for (Element signalElement : this.rootElement.elements("signal")) {
            String id = signalElement.attribute("id");
            String signalName = signalElement.attribute("name");
            for (SignalDefinition signalDefinition : this.signals.values()) {
                if (!signalDefinition.getName().equals(signalName)) continue;
                this.addError("duplicate signal name '" + signalName + "'.", signalElement);
            }
            if (id == null) {
                this.addError("signal must have an id", signalElement);
                continue;
            }
            if (signalName == null) {
                this.addError("signal with id '" + id + "' has no name", signalElement);
                continue;
            }
            Expression signalExpression = this.expressionManager.createExpression(signalName);
            SignalDefinition signal = new SignalDefinition();
            signal.setId(this.targetNamespace + ":" + id);
            signal.setExpression(signalExpression);
            this.signals.put(signal.getId(), signal);
        }
    }

    public void parseErrors() {
        for (Element errorElement : this.rootElement.elements("error")) {
            String errorMessage;
            Error error = new Error();
            String id = errorElement.attribute("id");
            if (id == null) {
                this.addError("'id' is mandatory on error definition", errorElement);
            }
            error.setId(id);
            String errorCode = errorElement.attribute("errorCode");
            if (errorCode != null) {
                error.setErrorCode(errorCode);
            }
            if ((errorMessage = errorElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "errorMessage")) != null) {
                error.setErrorMessageExpression(this.createParameterValueProvider(errorMessage, this.expressionManager));
            }
            this.errors.put(id, error);
        }
    }

    protected void parseEscalations() {
        for (Element element : this.rootElement.elements("escalation")) {
            String id = element.attribute("id");
            if (id == null) {
                this.addError("escalation must have an id", element);
                continue;
            }
            Escalation escalation = this.createEscalation(id, element);
            this.escalations.put(id, escalation);
        }
    }

    protected Escalation createEscalation(String id, Element element) {
        String escalationCode;
        Escalation escalation = new Escalation(id);
        String name = element.attribute("name");
        if (name != null) {
            escalation.setName(name);
        }
        if ((escalationCode = element.attribute("escalationCode")) != null && !escalationCode.isEmpty()) {
            escalation.setEscalationCode(escalationCode);
        }
        return escalation;
    }

    public void parseProcessDefinitions() {
        for (Element processElement : this.rootElement.elements("process")) {
            boolean isExecutable = !this.deployment.isNew();
            String isExecutableStr = processElement.attribute("isExecutable");
            if (isExecutableStr != null) {
                isExecutable = Boolean.parseBoolean(isExecutableStr);
                if (!isExecutable) {
                    LOG.ignoringNonExecutableProcess(processElement.attribute("id"));
                }
            } else {
                LOG.missingIsExecutableAttribute(processElement.attribute("id"));
            }
            if (!isExecutable) continue;
            this.processDefinitions.add(this.parseProcess(processElement));
        }
    }

    public void parseCollaboration() {
        Element collaboration = this.rootElement.element("collaboration");
        if (collaboration != null) {
            for (Element participant : collaboration.elements("participant")) {
                ProcessDefinitionEntity procDef;
                String processRef = participant.attribute("processRef");
                if (processRef == null || (procDef = this.getProcessDefinition(processRef)) == null) continue;
                ParticipantProcess participantProcess = new ParticipantProcess();
                participantProcess.setId(participant.attribute("id"));
                participantProcess.setName(participant.attribute("name"));
                procDef.setParticipantProcess(participantProcess);
                this.participantProcesses.put(participantProcess.getId(), processRef);
            }
        }
    }

    public ProcessDefinitionEntity parseProcess(Element processElement) {
        this.sequenceFlows = new HashMap<String, TransitionImpl>();
        ProcessDefinitionEntity processDefinition = new ProcessDefinitionEntity();
        processDefinition.setKey(processElement.attribute("id"));
        processDefinition.setName(processElement.attribute("name"));
        processDefinition.setCategory(this.rootElement.attribute("targetNamespace"));
        processDefinition.setProperty(PROPERTYNAME_DOCUMENTATION, this.parseDocumentation(processElement));
        processDefinition.setTaskDefinitions(new HashMap<String, TaskDefinition>());
        processDefinition.setDeploymentId(this.deployment.getId());
        processDefinition.setTenantId(this.deployment.getTenantId());
        processDefinition.setProperty(PROPERTYNAME_JOB_PRIORITY, this.parsePriority(processElement, PROPERTYNAME_JOB_PRIORITY));
        processDefinition.setProperty(PROPERTYNAME_TASK_PRIORITY, this.parsePriority(processElement, PROPERTYNAME_TASK_PRIORITY));
        processDefinition.setVersionTag(processElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "versionTag"));
        boolean skipEnforceTtl = !this.deployment.isNew();
        this.validateAndSetHTTL(processElement, processDefinition, skipEnforceTtl);
        boolean isStartableInTasklist = this.isStartable(processElement);
        processDefinition.setStartableInTasklist(isStartableInTasklist);
        LOG.parsingElement("process", processDefinition.getKey());
        this.parseScope(processElement, processDefinition);
        this.parseLaneSets(processElement, processDefinition);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseProcess(processElement, processDefinition);
        }
        this.validateActivities(processDefinition.getActivities());
        for (ActivityImpl activity : processDefinition.getActivities()) {
            activity.setDelegateAsyncAfterUpdate(null);
            activity.setDelegateAsyncBeforeUpdate(null);
        }
        return processDefinition;
    }

    protected void validateAndSetHTTL(Element processElement, ProcessDefinitionEntity processDefinition, boolean skipEnforceTtl) {
        try {
            String processDefinitionKey = processDefinition.getKey();
            Integer historyTimeToLive = HistoryTimeToLiveParser.create().parse(processElement, processDefinitionKey, skipEnforceTtl);
            processDefinition.setHistoryTimeToLive(historyTimeToLive);
        }
        catch (Exception e) {
            this.addError(new BpmnParseException(e.getMessage(), processElement, e));
        }
    }

    protected void parseLaneSets(Element parentElement, ProcessDefinitionEntity processDefinition) {
        List<Element> laneSets = parentElement.elements("laneSet");
        if (laneSets != null && laneSets.size() > 0) {
            for (Element laneSetElement : laneSets) {
                LaneSet newLaneSet = new LaneSet();
                newLaneSet.setId(laneSetElement.attribute("id"));
                newLaneSet.setName(laneSetElement.attribute("name"));
                this.parseLanes(laneSetElement, newLaneSet);
                processDefinition.addLaneSet(newLaneSet);
            }
        }
    }

    protected void parseLanes(Element laneSetElement, LaneSet laneSet) {
        List<Element> lanes = laneSetElement.elements("lane");
        if (lanes != null && lanes.size() > 0) {
            for (Element laneElement : lanes) {
                Lane lane = new Lane();
                lane.setId(laneElement.attribute("id"));
                lane.setName(laneElement.attribute("name"));
                List<Element> flowNodeElements = laneElement.elements("flowNodeRef");
                if (flowNodeElements != null && flowNodeElements.size() > 0) {
                    for (Element flowNodeElement : flowNodeElements) {
                        lane.getFlowNodeIds().add(flowNodeElement.getText());
                    }
                }
                laneSet.addLane(lane);
            }
        }
    }

    public void parseScope(Element scopeElement, ScopeImpl parentScope) {
        ArrayList<Element> activityElements = new ArrayList<Element>(scopeElement.elements());
        HashMap<String, Element> intermediateCatchEvents = this.filterIntermediateCatchEvents(activityElements);
        activityElements.removeAll(intermediateCatchEvents.values());
        HashMap<String, Element> compensationHandlers = this.filterCompensationHandlers(activityElements);
        activityElements.removeAll(compensationHandlers.values());
        this.parseStartEvents(scopeElement, parentScope);
        this.parseActivities(activityElements, scopeElement, parentScope);
        this.parseIntermediateCatchEvents(scopeElement, parentScope, intermediateCatchEvents);
        this.parseEndEvents(scopeElement, parentScope);
        this.parseBoundaryEvents(scopeElement, parentScope);
        this.parseSequenceFlow(scopeElement, parentScope, compensationHandlers);
        this.parseExecutionListenersOnScope(scopeElement, parentScope);
        this.parseAssociations(scopeElement, parentScope, compensationHandlers);
        this.parseCompensationHandlers(parentScope, compensationHandlers);
        for (ScopeImpl.BacklogErrorCallback callback : parentScope.getBacklogErrorCallbacks()) {
            callback.callback();
        }
        if (parentScope instanceof ProcessDefinition) {
            this.parseProcessDefinitionCustomExtensions(scopeElement, (ProcessDefinition)((Object)parentScope));
        }
    }

    protected HashMap<String, Element> filterIntermediateCatchEvents(List<Element> activityElements) {
        HashMap<String, Element> intermediateCatchEvents = new HashMap<String, Element>();
        for (Element activityElement : activityElements) {
            if (!activityElement.getTagName().equals("intermediateCatchEvent")) continue;
            intermediateCatchEvents.put(activityElement.attribute("id"), activityElement);
        }
        return intermediateCatchEvents;
    }

    protected HashMap<String, Element> filterCompensationHandlers(List<Element> activityElements) {
        HashMap<String, Element> compensationHandlers = new HashMap<String, Element>();
        for (Element activityElement : activityElements) {
            if (!this.isCompensationHandler(activityElement)) continue;
            compensationHandlers.put(activityElement.attribute("id"), activityElement);
        }
        return compensationHandlers;
    }

    protected void parseIntermediateCatchEvents(Element scopeElement, ScopeImpl parentScope, Map<String, Element> intermediateCatchEventElements) {
        for (Element intermediateCatchEventElement : intermediateCatchEventElements.values()) {
            ActivityImpl activity;
            if (parentScope.findActivity(intermediateCatchEventElement.attribute("id")) != null || (activity = this.parseIntermediateCatchEvent(intermediateCatchEventElement, parentScope, null)) == null) continue;
            this.parseActivityInputOutput(intermediateCatchEventElement, activity);
        }
        intermediateCatchEventElements.clear();
    }

    protected void parseProcessDefinitionCustomExtensions(Element scopeElement, ProcessDefinition definition) {
        this.parseStartAuthorization(scopeElement, definition);
    }

    protected void parseStartAuthorization(Element scopeElement, ProcessDefinition definition) {
        String candidateGroupsString;
        String candidateUsersString;
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)definition;
        Element extentionsElement = scopeElement.element("extensionElements");
        if (extentionsElement != null) {
            List<Element> potentialStarterElements = extentionsElement.elementsNS(CAMUNDA_BPMN_EXTENSIONS_NS, POTENTIAL_STARTER);
            for (Element element : potentialStarterElements) {
                this.parsePotentialStarterResourceAssignment(element, processDefinition);
            }
        }
        if ((candidateUsersString = scopeElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, CANDIDATE_STARTER_USERS_EXTENSION)) != null) {
            List<String> candidateUsers = this.parseCommaSeparatedList(candidateUsersString);
            for (String candidateUser : candidateUsers) {
                processDefinition.addCandidateStarterUserIdExpression(this.expressionManager.createExpression(candidateUser.trim()));
            }
        }
        if ((candidateGroupsString = scopeElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, CANDIDATE_STARTER_GROUPS_EXTENSION)) != null) {
            List<String> list = this.parseCommaSeparatedList(candidateGroupsString);
            for (String candidateGroup : list) {
                processDefinition.addCandidateStarterGroupIdExpression(this.expressionManager.createExpression(candidateGroup.trim()));
            }
        }
    }

    protected void parsePotentialStarterResourceAssignment(Element performerElement, ProcessDefinitionEntity processDefinition) {
        Element feElement;
        Element raeElement = performerElement.element(RESOURCE_ASSIGNMENT_EXPR);
        if (raeElement != null && (feElement = raeElement.element(FORMAL_EXPRESSION)) != null) {
            List<String> assignmentExpressions = this.parseCommaSeparatedList(feElement.getText());
            for (String assignmentExpression : assignmentExpressions) {
                if ((assignmentExpression = assignmentExpression.trim()).startsWith(USER_PREFIX)) {
                    String userAssignementId = this.getAssignmentId(assignmentExpression, USER_PREFIX);
                    processDefinition.addCandidateStarterUserIdExpression(this.expressionManager.createExpression(userAssignementId));
                    continue;
                }
                if (assignmentExpression.startsWith(GROUP_PREFIX)) {
                    String groupAssignementId = this.getAssignmentId(assignmentExpression, GROUP_PREFIX);
                    processDefinition.addCandidateStarterGroupIdExpression(this.expressionManager.createExpression(groupAssignementId));
                    continue;
                }
                processDefinition.addCandidateStarterGroupIdExpression(this.expressionManager.createExpression(assignmentExpression));
            }
        }
    }

    protected void parseAssociations(Element scopeElement, ScopeImpl parentScope, Map<String, Element> compensationHandlers) {
        for (Element associationElement : scopeElement.elements("association")) {
            String targetRef;
            String sourceRef = associationElement.attribute("sourceRef");
            if (sourceRef == null) {
                this.addError("association element missing attribute 'sourceRef'", associationElement);
            }
            if ((targetRef = associationElement.attribute("targetRef")) == null) {
                this.addError("association element missing attribute 'targetRef'", associationElement);
            }
            ActivityImpl sourceActivity = parentScope.findActivity(sourceRef);
            ActivityImpl targetActivity = parentScope.findActivity(targetRef);
            if (sourceActivity == null && !this.elementIds.contains(sourceRef)) {
                this.addError("Invalid reference sourceRef '" + sourceRef + "' of association element ", associationElement);
                continue;
            }
            if (targetActivity == null && !this.elementIds.contains(targetRef)) {
                this.addError("Invalid reference targetRef '" + targetRef + "' of association element ", associationElement);
                continue;
            }
            if (sourceActivity == null || !"compensationBoundaryCatch".equals(sourceActivity.getProperty(BpmnProperties.TYPE.getName()))) continue;
            if (targetActivity == null && compensationHandlers.containsKey(targetRef)) {
                targetActivity = this.parseCompensationHandlerForCompensationBoundaryEvent(parentScope, sourceActivity, targetRef, compensationHandlers);
                compensationHandlers.remove(targetActivity.getId());
            }
            if (targetActivity == null) continue;
            this.parseAssociationOfCompensationBoundaryEvent(associationElement, sourceActivity, targetActivity);
        }
    }

    protected ActivityImpl parseCompensationHandlerForCompensationBoundaryEvent(ScopeImpl parentScope, ActivityImpl sourceActivity, String targetRef, Map<String, Element> compensationHandlers) {
        Element compensationHandler = compensationHandlers.get(targetRef);
        ActivityImpl eventScope = (ActivityImpl)sourceActivity.getEventScope();
        ActivityImpl compensationHandlerActivity = null;
        if (eventScope.isMultiInstance()) {
            ScopeImpl miBody = eventScope.getFlowScope();
            compensationHandlerActivity = this.parseActivity(compensationHandler, null, miBody);
        } else {
            compensationHandlerActivity = this.parseActivity(compensationHandler, null, parentScope);
        }
        compensationHandlerActivity.getProperties().set(BpmnProperties.COMPENSATION_BOUNDARY_EVENT, sourceActivity);
        return compensationHandlerActivity;
    }

    protected void parseAssociationOfCompensationBoundaryEvent(Element associationElement, ActivityImpl sourceActivity, ActivityImpl targetActivity) {
        if (!targetActivity.isCompensationHandler()) {
            this.addError("compensation boundary catch must be connected to element with isForCompensation=true", associationElement, sourceActivity.getId(), targetActivity.getId());
        } else {
            ActivityImpl compensatedActivity = (ActivityImpl)sourceActivity.getEventScope();
            ActivityImpl compensationHandler = compensatedActivity.findCompensationHandler();
            if (compensationHandler != null && compensationHandler.isSubProcessScope()) {
                this.addError("compensation boundary event and event subprocess with compensation start event are not supported on the same scope", associationElement, compensatedActivity.getId(), sourceActivity.getId());
            } else {
                compensatedActivity.setProperty(PROPERTYNAME_COMPENSATION_HANDLER_ID, targetActivity.getId());
            }
        }
    }

    protected void parseCompensationHandlers(ScopeImpl parentScope, Map<String, Element> compensationHandlers) {
        for (Element compensationHandler : new HashSet<Element>(compensationHandlers.values())) {
            this.parseActivity(compensationHandler, null, parentScope);
        }
        compensationHandlers.clear();
    }

    public void parseStartEvents(Element parentElement, ScopeImpl scope) {
        ActivityImpl startEventActivity;
        List<Element> startEventElements = parentElement.elements("startEvent");
        ArrayList<ActivityImpl> startEventActivities = new ArrayList<ActivityImpl>();
        if (startEventElements.size() > 0) {
            for (Element startEventElement : startEventElements) {
                startEventActivity = this.createActivityOnScope(startEventElement, scope);
                this.parseAsynchronousContinuationForActivity(startEventElement, startEventActivity);
                if (scope instanceof ProcessDefinitionEntity) {
                    this.parseProcessDefinitionStartEvent(startEventActivity, startEventElement, parentElement, scope);
                    startEventActivities.add(startEventActivity);
                } else {
                    this.parseScopeStartEvent(startEventActivity, startEventElement, parentElement, (ActivityImpl)scope);
                }
                this.ensureNoIoMappingDefined(startEventElement);
                this.parseExecutionListenersOnScope(startEventElement, startEventActivity);
            }
        } else if (Arrays.asList("process", "subProcess").contains(parentElement.getTagName())) {
            this.addError(parentElement.getTagName() + " must define a startEvent element", parentElement);
        }
        if (scope instanceof ProcessDefinitionEntity) {
            this.selectInitial(startEventActivities, (ProcessDefinitionEntity)scope, parentElement);
            this.parseStartFormHandlers(startEventElements, (ProcessDefinitionEntity)scope);
        }
        for (Element startEventElement : startEventElements) {
            startEventActivity = scope.getChildActivity(startEventElement.attribute("id"));
            for (BpmnParseListener parseListener : this.parseListeners) {
                parseListener.parseStartEvent(startEventElement, scope, startEventActivity);
            }
        }
    }

    protected void selectInitial(List<ActivityImpl> startEventActivities, ProcessDefinitionEntity processDefinition, Element parentElement) {
        ActivityImpl initial = null;
        List<String> exclusiveStartEventTypes = Arrays.asList("startEvent", "startTimerEvent");
        for (ActivityImpl activityImpl : startEventActivities) {
            if (!exclusiveStartEventTypes.contains(activityImpl.getProperty(BpmnProperties.TYPE.getName()))) continue;
            if (initial == null) {
                initial = activityImpl;
                continue;
            }
            this.addError("multiple none start events or timer start events not supported on process definition", parentElement, activityImpl.getId());
        }
        if (initial == null && startEventActivities.size() == 1) {
            initial = startEventActivities.get(0);
        }
        processDefinition.setInitial(initial);
    }

    protected void parseProcessDefinitionStartEvent(ActivityImpl startEventActivity, Element startEventElement, Element parentElement, ScopeImpl scope) {
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)scope;
        String initiatorVariableName = startEventElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "initiator");
        if (initiatorVariableName != null) {
            processDefinition.setProperty(PROPERTYNAME_INITIATOR_VARIABLE_NAME, initiatorVariableName);
        }
        startEventActivity.setActivityBehavior(new NoneStartEventActivityBehavior());
        Element timerEventDefinition = startEventElement.element(TIMER_EVENT_DEFINITION);
        Element messageEventDefinition = startEventElement.element(MESSAGE_EVENT_DEFINITION);
        Element signalEventDefinition = startEventElement.element(SIGNAL_EVENT_DEFINITION);
        Element conditionEventDefinition = startEventElement.element(CONDITIONAL_EVENT_DEFINITION);
        if (timerEventDefinition != null) {
            this.parseTimerStartEventDefinition(timerEventDefinition, startEventActivity, processDefinition);
        } else if (messageEventDefinition != null) {
            startEventActivity.getProperties().set(BpmnProperties.TYPE, "messageStartEvent");
            EventSubscriptionDeclaration messageStartEventSubscriptionDeclaration = this.parseMessageEventDefinition(messageEventDefinition, startEventElement.attribute("id"));
            messageStartEventSubscriptionDeclaration.setActivityId(startEventActivity.getId());
            messageStartEventSubscriptionDeclaration.setStartEvent(true);
            this.ensureNoExpressionInMessageStartEvent(messageEventDefinition, messageStartEventSubscriptionDeclaration, startEventElement.attribute("id"));
            this.addEventSubscriptionDeclaration(messageStartEventSubscriptionDeclaration, processDefinition, startEventElement);
        } else if (signalEventDefinition != null) {
            startEventActivity.getProperties().set(BpmnProperties.TYPE, "signalStartEvent");
            startEventActivity.setEventScope(scope);
            this.parseSignalCatchEventDefinition(signalEventDefinition, startEventActivity, true);
        } else if (conditionEventDefinition != null) {
            startEventActivity.getProperties().set(BpmnProperties.TYPE, "conditionalStartEvent");
            ConditionalEventDefinition conditionalEventDefinition = this.parseConditionalEventDefinition(conditionEventDefinition, startEventActivity);
            conditionalEventDefinition.setStartEvent(true);
            conditionalEventDefinition.setActivityId(startEventActivity.getId());
            startEventActivity.getProperties().set(BpmnProperties.CONDITIONAL_EVENT_DEFINITION, conditionalEventDefinition);
            this.addEventSubscriptionDeclaration(conditionalEventDefinition, processDefinition, startEventElement);
        }
    }

    protected void parseStartFormHandlers(List<Element> startEventElements, ProcessDefinitionEntity processDefinition) {
        if (processDefinition.getInitial() != null) {
            for (Element startEventElement : startEventElements) {
                if (!startEventElement.attribute("id").equals(processDefinition.getInitial().getId())) continue;
                String startFormHandlerClassName = startEventElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "formHandlerClass");
                StartFormHandler startFormHandler = startFormHandlerClassName != null ? (StartFormHandler)ReflectUtil.instantiate(startFormHandlerClassName) : new DefaultStartFormHandler();
                startFormHandler.parseConfiguration(startEventElement, this.deployment, processDefinition, this);
                processDefinition.setStartFormHandler(new DelegateStartFormHandler(startFormHandler, this.deployment));
                FormDefinition formDefinition = this.parseFormDefinition(startEventElement);
                processDefinition.setStartFormDefinition(formDefinition);
                processDefinition.setHasStartFormKey(formDefinition.getFormKey() != null);
            }
        }
    }

    protected void parseScopeStartEvent(ActivityImpl startEventActivity, Element startEventElement, Element parentElement, ActivityImpl scopeActivity) {
        Properties scopeProperties = scopeActivity.getProperties();
        if (!scopeProperties.contains(BpmnProperties.INITIAL_ACTIVITY)) {
            scopeProperties.set(BpmnProperties.INITIAL_ACTIVITY, startEventActivity);
        } else {
            this.addError("multiple start events not supported for subprocess", parentElement, startEventActivity.getId());
        }
        Element errorEventDefinition = startEventElement.element(ERROR_EVENT_DEFINITION);
        Element messageEventDefinition = startEventElement.element(MESSAGE_EVENT_DEFINITION);
        Element signalEventDefinition = startEventElement.element(SIGNAL_EVENT_DEFINITION);
        Element timerEventDefinition = startEventElement.element(TIMER_EVENT_DEFINITION);
        Element compensateEventDefinition = startEventElement.element(COMPENSATE_EVENT_DEFINITION);
        Element escalationEventDefinitionElement = startEventElement.element(ESCALATION_EVENT_DEFINITION);
        Element conditionalEventDefinitionElement = startEventElement.element(CONDITIONAL_EVENT_DEFINITION);
        if (scopeActivity.isTriggeredByEvent()) {
            EventSubProcessStartEventActivityBehavior behavior = new EventSubProcessStartEventActivityBehavior();
            String isInterruptingAttr = startEventElement.attribute(INTERRUPTING);
            boolean isInterrupting = isInterruptingAttr.equalsIgnoreCase(TRUE);
            if (isInterrupting) {
                scopeActivity.setActivityStartBehavior(ActivityStartBehavior.INTERRUPT_EVENT_SCOPE);
            } else {
                scopeActivity.setActivityStartBehavior(ActivityStartBehavior.CONCURRENT_IN_FLOW_SCOPE);
            }
            startEventActivity.setEventScope(scopeActivity.getFlowScope());
            if (errorEventDefinition != null) {
                if (!isInterrupting) {
                    this.addError("error start event of event subprocess must be interrupting", startEventElement);
                }
                this.parseErrorStartEventDefinition(errorEventDefinition, startEventActivity);
            } else if (messageEventDefinition != null) {
                startEventActivity.getProperties().set(BpmnProperties.TYPE, "messageStartEvent");
                EventSubscriptionDeclaration messageStartEventSubscriptionDeclaration = this.parseMessageEventDefinition(messageEventDefinition, startEventActivity.getId());
                this.parseEventDefinitionForSubprocess(messageStartEventSubscriptionDeclaration, startEventActivity, messageEventDefinition);
            } else if (signalEventDefinition != null) {
                startEventActivity.getProperties().set(BpmnProperties.TYPE, "signalStartEvent");
                EventSubscriptionDeclaration eventSubscriptionDeclaration = this.parseSignalEventDefinition(signalEventDefinition, false, startEventActivity.getId());
                this.parseEventDefinitionForSubprocess(eventSubscriptionDeclaration, startEventActivity, signalEventDefinition);
            } else if (timerEventDefinition != null) {
                this.parseTimerStartEventDefinitionForEventSubprocess(timerEventDefinition, startEventActivity, isInterrupting);
            } else if (compensateEventDefinition != null) {
                this.parseCompensationEventSubprocess(startEventActivity, startEventElement, scopeActivity, compensateEventDefinition);
            } else if (escalationEventDefinitionElement != null) {
                startEventActivity.getProperties().set(BpmnProperties.TYPE, "escalationStartEvent");
                EscalationEventDefinition escalationEventDefinition = this.createEscalationEventDefinitionForEscalationHandler(escalationEventDefinitionElement, scopeActivity, isInterrupting, startEventActivity.getId());
                this.addEscalationEventDefinition(startEventActivity.getEventScope(), escalationEventDefinition, escalationEventDefinitionElement, startEventActivity.getId());
            } else if (conditionalEventDefinitionElement != null) {
                ConditionalEventDefinition conditionalEventDef = this.parseConditionalStartEventForEventSubprocess(conditionalEventDefinitionElement, startEventActivity, isInterrupting);
                behavior = new EventSubProcessStartConditionalEventActivityBehavior(conditionalEventDef);
            } else {
                this.addError("start event of event subprocess must be of type 'error', 'message', 'timer', 'signal', 'compensation' or 'escalation'", startEventElement);
            }
            startEventActivity.setActivityBehavior(behavior);
        } else {
            Element conditionalEventDefinition = startEventElement.element(CONDITIONAL_EVENT_DEFINITION);
            if (conditionalEventDefinition != null) {
                this.addError("conditionalEventDefinition is not allowed on start event within a subprocess", conditionalEventDefinition, startEventActivity.getId());
            }
            if (timerEventDefinition != null) {
                this.addError("timerEventDefinition is not allowed on start event within a subprocess", timerEventDefinition, startEventActivity.getId());
            }
            if (escalationEventDefinitionElement != null) {
                this.addError("escalationEventDefinition is not allowed on start event within a subprocess", escalationEventDefinitionElement, startEventActivity.getId());
            }
            if (compensateEventDefinition != null) {
                this.addError("compensateEventDefinition is not allowed on start event within a subprocess", compensateEventDefinition, startEventActivity.getId());
            }
            if (errorEventDefinition != null) {
                this.addError("errorEventDefinition only allowed on start event if subprocess is an event subprocess", errorEventDefinition, startEventActivity.getId());
            }
            if (messageEventDefinition != null) {
                this.addError("messageEventDefinition only allowed on start event if subprocess is an event subprocess", messageEventDefinition, startEventActivity.getId());
            }
            if (signalEventDefinition != null) {
                this.addError("signalEventDefintion only allowed on start event if subprocess is an event subprocess", signalEventDefinition, startEventActivity.getId());
            }
            startEventActivity.setActivityBehavior(new NoneStartEventActivityBehavior());
        }
    }

    protected void parseCompensationEventSubprocess(ActivityImpl startEventActivity, Element startEventElement, ActivityImpl scopeActivity, Element compensateEventDefinition) {
        ScopeImpl subprocess;
        ActivityImpl compensationHandler;
        startEventActivity.getProperties().set(BpmnProperties.TYPE, "compensationStartEvent");
        scopeActivity.setProperty(PROPERTYNAME_IS_FOR_COMPENSATION, Boolean.TRUE);
        if (scopeActivity.getFlowScope() instanceof ProcessDefinitionEntity) {
            this.addError("event subprocess with compensation start event is only supported for embedded subprocess (since throwing compensation through a call activity-induced process hierarchy is not supported)", startEventElement);
        }
        if ((compensationHandler = ((ActivityImpl)(subprocess = scopeActivity.getFlowScope())).findCompensationHandler()) == null) {
            subprocess.setProperty(PROPERTYNAME_COMPENSATION_HANDLER_ID, scopeActivity.getActivityId());
        } else if (compensationHandler.isSubProcessScope()) {
            this.addError("multiple event subprocesses with compensation start event are not supported on the same scope", startEventElement);
        } else {
            this.addError("compensation boundary event and event subprocess with compensation start event are not supported on the same scope", startEventElement);
        }
        this.validateCatchCompensateEventDefinition(compensateEventDefinition, startEventActivity.getId());
    }

    protected void parseErrorStartEventDefinition(Element errorEventDefinition, ActivityImpl startEventActivity) {
        startEventActivity.getProperties().set(BpmnProperties.TYPE, "errorStartEvent");
        String errorRef = errorEventDefinition.attribute("errorRef");
        Error error = null;
        String eventSubProcessActivity = startEventActivity.getFlowScope().getId();
        ErrorEventDefinition definition = new ErrorEventDefinition(eventSubProcessActivity);
        if (errorRef != null) {
            error = this.errors.get(errorRef);
            String errorCode = error == null ? errorRef : error.getErrorCode();
            definition.setErrorCode(errorCode);
        }
        definition.setPrecedence(10);
        this.setErrorCodeVariableOnErrorEventDefinition(errorEventDefinition, definition);
        this.setErrorMessageVariableOnErrorEventDefinition(errorEventDefinition, definition);
        this.addErrorEventDefinition(definition, startEventActivity.getEventScope());
    }

    protected void setErrorCodeVariableOnErrorEventDefinition(Element errorEventDefinition, ErrorEventDefinition definition) {
        String errorCodeVar = errorEventDefinition.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "errorCodeVariable");
        if (errorCodeVar != null) {
            definition.setErrorCodeVariable(errorCodeVar);
        }
    }

    protected void setErrorMessageVariableOnErrorEventDefinition(Element errorEventDefinition, ErrorEventDefinition definition) {
        String errorMessageVariable = errorEventDefinition.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "errorMessageVariable");
        if (errorMessageVariable != null) {
            definition.setErrorMessageVariable(errorMessageVariable);
        }
    }

    protected EventSubscriptionDeclaration parseMessageEventDefinition(Element messageEventDefinition, String messageElementId) {
        MessageDefinition messageDefinition;
        String messageRef = messageEventDefinition.attribute("messageRef");
        if (messageRef == null) {
            this.addError("attribute 'messageRef' is required", messageEventDefinition, messageElementId);
        }
        if ((messageDefinition = this.messages.get(this.resolveName(messageRef))) == null) {
            this.addError("Invalid 'messageRef': no message with id '" + messageRef + "' found.", messageEventDefinition, messageElementId);
        }
        return new EventSubscriptionDeclaration(messageDefinition.getExpression(), EventType.MESSAGE);
    }

    protected void addEventSubscriptionDeclaration(EventSubscriptionDeclaration subscription, ScopeImpl scope, Element element) {
        Map<String, EventSubscriptionDeclaration> eventDefinitions;
        if (subscription.getEventType().equals(EventType.MESSAGE.name()) && !subscription.hasEventName()) {
            this.addError("Cannot have a message event subscription with an empty or missing name", element, subscription.getActivityId());
        }
        if (this.hasMultipleMessageEventDefinitionsWithSameName(subscription, (eventDefinitions = scope.getProperties().get(BpmnProperties.EVENT_SUBSCRIPTION_DECLARATIONS)).values())) {
            this.addError("Cannot have more than one message event subscription with name '" + subscription.getUnresolvedEventName() + "' for scope '" + scope.getId() + "'", element, subscription.getActivityId());
        }
        if (this.hasMultipleSignalEventDefinitionsWithSameName(subscription, eventDefinitions.values())) {
            this.addError("Cannot have more than one signal event subscription with name '" + subscription.getUnresolvedEventName() + "' for scope '" + scope.getId() + "'", element, subscription.getActivityId());
        }
        if (subscription.isStartEvent() && this.hasMultipleConditionalEventDefinitionsWithSameCondition(subscription, eventDefinitions.values())) {
            this.addError("Cannot have more than one conditional event subscription with the same condition '" + ((ConditionalEventDefinition)subscription).getConditionAsString() + "'", element, subscription.getActivityId());
        }
        scope.getProperties().putMapEntry(BpmnProperties.EVENT_SUBSCRIPTION_DECLARATIONS, subscription.getActivityId(), subscription);
    }

    protected boolean hasMultipleMessageEventDefinitionsWithSameName(EventSubscriptionDeclaration subscription, Collection<EventSubscriptionDeclaration> eventDefinitions) {
        return this.hasMultipleEventDefinitionsWithSameName(subscription, eventDefinitions, EventType.MESSAGE.name());
    }

    protected boolean hasMultipleSignalEventDefinitionsWithSameName(EventSubscriptionDeclaration subscription, Collection<EventSubscriptionDeclaration> eventDefinitions) {
        return this.hasMultipleEventDefinitionsWithSameName(subscription, eventDefinitions, EventType.SIGNAL.name());
    }

    protected boolean hasMultipleConditionalEventDefinitionsWithSameCondition(EventSubscriptionDeclaration subscription, Collection<EventSubscriptionDeclaration> eventDefinitions) {
        if (subscription.getEventType().equals(EventType.CONDITONAL.name())) {
            for (EventSubscriptionDeclaration eventDefinition : eventDefinitions) {
                if (!eventDefinition.getEventType().equals(EventType.CONDITONAL.name()) || eventDefinition.isStartEvent() != subscription.isStartEvent() || !((ConditionalEventDefinition)eventDefinition).getConditionAsString().equals(((ConditionalEventDefinition)subscription).getConditionAsString())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean hasMultipleEventDefinitionsWithSameName(EventSubscriptionDeclaration subscription, Collection<EventSubscriptionDeclaration> eventDefinitions, String eventType) {
        if (subscription.getEventType().equals(eventType)) {
            for (EventSubscriptionDeclaration eventDefinition : eventDefinitions) {
                if (!eventDefinition.getEventType().equals(eventType) || !eventDefinition.getUnresolvedEventName().equals(subscription.getUnresolvedEventName()) || eventDefinition.isStartEvent() != subscription.isStartEvent()) continue;
                return true;
            }
        }
        return false;
    }

    protected void addEventSubscriptionJobDeclaration(EventSubscriptionJobDeclaration jobDeclaration, ActivityImpl activity, Element element) {
        ArrayList<EventSubscriptionJobDeclaration> jobDeclarationsForActivity = (ArrayList<EventSubscriptionJobDeclaration>)activity.getProperty(PROPERTYNAME_EVENT_SUBSCRIPTION_JOB_DECLARATION);
        if (jobDeclarationsForActivity == null) {
            jobDeclarationsForActivity = new ArrayList<EventSubscriptionJobDeclaration>();
            activity.setProperty(PROPERTYNAME_EVENT_SUBSCRIPTION_JOB_DECLARATION, jobDeclarationsForActivity);
        }
        if (this.activityAlreadyContainsJobDeclarationEventType(jobDeclarationsForActivity, jobDeclaration)) {
            this.addError("Activity contains already job declaration with type " + jobDeclaration.getEventType(), element, activity.getId());
        }
        jobDeclarationsForActivity.add(jobDeclaration);
    }

    protected boolean activityAlreadyContainsJobDeclarationEventType(List<EventSubscriptionJobDeclaration> jobDeclarationsForActivity, EventSubscriptionJobDeclaration jobDeclaration) {
        for (EventSubscriptionJobDeclaration declaration : jobDeclarationsForActivity) {
            if (!declaration.getEventType().equals(jobDeclaration.getEventType())) continue;
            return true;
        }
        return false;
    }

    public void parseActivities(List<Element> activityElements, Element parentElement, ScopeImpl scopeElement) {
        for (Element activityElement : activityElements) {
            this.parseActivity(activityElement, parentElement, scopeElement);
        }
    }

    protected ActivityImpl parseActivity(Element activityElement, Element parentElement, ScopeImpl scopeElement) {
        ActivityImpl activity = null;
        boolean isMultiInstance = false;
        ScopeImpl miBody = this.parseMultiInstanceLoopCharacteristics(activityElement, scopeElement);
        if (miBody != null) {
            scopeElement = miBody;
            isMultiInstance = true;
        }
        if (activityElement.getTagName().equals("exclusiveGateway")) {
            activity = this.parseExclusiveGateway(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("inclusiveGateway")) {
            activity = this.parseInclusiveGateway(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("parallelGateway")) {
            activity = this.parseParallelGateway(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("scriptTask")) {
            activity = this.parseScriptTask(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("serviceTask")) {
            activity = this.parseServiceTask(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("businessRuleTask")) {
            activity = this.parseBusinessRuleTask(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("task")) {
            activity = this.parseTask(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("manualTask")) {
            activity = this.parseManualTask(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("userTask")) {
            activity = this.parseUserTask(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("sendTask")) {
            activity = this.parseSendTask(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("receiveTask")) {
            activity = this.parseReceiveTask(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("subProcess")) {
            activity = this.parseSubProcess(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("callActivity")) {
            activity = this.parseCallActivity(activityElement, scopeElement, isMultiInstance);
        } else if (activityElement.getTagName().equals("intermediateThrowEvent")) {
            activity = this.parseIntermediateThrowEvent(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("eventBasedGateway")) {
            activity = this.parseEventBasedGateway(activityElement, parentElement, scopeElement);
        } else if (activityElement.getTagName().equals("transaction")) {
            activity = this.parseTransaction(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("adHocSubProcess") || activityElement.getTagName().equals("complexGateway")) {
            this.addWarning("Ignoring unsupported activity type", activityElement);
        }
        if (isMultiInstance) {
            activity.setProperty(PROPERTYNAME_IS_MULTI_INSTANCE, true);
        }
        if (activity != null) {
            activity.setName(activityElement.attribute("name"));
            this.parseActivityInputOutput(activityElement, activity);
        }
        return activity;
    }

    public void validateActivities(List<ActivityImpl> activities) {
        for (ActivityImpl activity : activities) {
            this.validateActivity(activity);
            if (activity.getActivities().size() <= 0) continue;
            this.validateActivities(activity.getActivities());
        }
    }

    protected void validateActivity(ActivityImpl activity) {
        if (activity.getActivityBehavior() instanceof ExclusiveGatewayActivityBehavior) {
            this.validateExclusiveGateway(activity);
        }
        this.validateOutgoingFlows(activity);
    }

    protected void validateOutgoingFlows(ActivityImpl activity) {
        if (activity.isAsyncAfter()) {
            for (PvmTransition transition : activity.getOutgoingTransitions()) {
                if (transition.getId() != null) continue;
                this.addError("Sequence flow with sourceRef='" + activity.getId() + "' must have an id, activity with id '" + activity.getId() + "' uses 'asyncAfter'.", null, activity.getId());
            }
        }
    }

    public void validateExclusiveGateway(ActivityImpl activity) {
        if (activity.getOutgoingTransitions().size() == 0) {
            this.addError("Exclusive Gateway '" + activity.getId() + "' has no outgoing sequence flows.", null, activity.getId());
        } else if (activity.getOutgoingTransitions().size() == 1) {
            PvmTransition flow = activity.getOutgoingTransitions().get(0);
            Condition condition = (Condition)flow.getProperty("condition");
            if (condition != null) {
                this.addError("Exclusive Gateway '" + activity.getId() + "' has only one outgoing sequence flow ('" + flow.getId() + "'). This is not allowed to have a condition.", null, activity.getId(), flow.getId());
            }
        } else {
            String defaultSequenceFlow = (String)activity.getProperty("default");
            boolean hasDefaultFlow = defaultSequenceFlow != null && defaultSequenceFlow.length() > 0;
            ArrayList<PvmTransition> flowsWithoutCondition = new ArrayList<PvmTransition>();
            for (PvmTransition flow : activity.getOutgoingTransitions()) {
                boolean hasConditon;
                Condition condition = (Condition)flow.getProperty("condition");
                boolean isDefaultFlow = flow.getId() != null && flow.getId().equals(defaultSequenceFlow);
                boolean bl = hasConditon = condition != null;
                if (!hasConditon && !isDefaultFlow) {
                    flowsWithoutCondition.add(flow);
                }
                if (!hasConditon || !isDefaultFlow) continue;
                this.addError("Exclusive Gateway '" + activity.getId() + "' has outgoing sequence flow '" + flow.getId() + "' which is the default flow but has a condition too.", null, activity.getId(), flow.getId());
            }
            if (hasDefaultFlow || flowsWithoutCondition.size() > 1) {
                for (PvmTransition flow : flowsWithoutCondition) {
                    this.addError("Exclusive Gateway '" + activity.getId() + "' has outgoing sequence flow '" + flow.getId() + "' without condition which is not the default flow.", null, activity.getId(), flow.getId());
                }
            } else if (flowsWithoutCondition.size() == 1) {
                PvmTransition flow = (PvmTransition)flowsWithoutCondition.get(0);
                this.addWarning("Exclusive Gateway '" + activity.getId() + "' has outgoing sequence flow '" + flow.getId() + "' without condition which is not the default flow. We assume it to be the default flow, but it is bad modeling practice, better set the default flow in your gateway.", null, activity.getId(), flow.getId());
            }
        }
    }

    public ActivityImpl parseIntermediateCatchEvent(Element intermediateEventElement, ScopeImpl scopeElement, ActivityImpl eventBasedGateway) {
        boolean isEventBaseGatewayPresent;
        ActivityImpl nestedActivity = this.createActivityOnScope(intermediateEventElement, scopeElement);
        Element timerEventDefinition = intermediateEventElement.element(TIMER_EVENT_DEFINITION);
        Element signalEventDefinition = intermediateEventElement.element(SIGNAL_EVENT_DEFINITION);
        Element messageEventDefinition = intermediateEventElement.element(MESSAGE_EVENT_DEFINITION);
        Element linkEventDefinitionElement = intermediateEventElement.element(LINK_EVENT_DEFINITION);
        Element conditionalEventDefinitionElement = intermediateEventElement.element(CONDITIONAL_EVENT_DEFINITION);
        IntermediateCatchEventActivityBehavior defaultCatchBehaviour = new IntermediateCatchEventActivityBehavior(eventBasedGateway != null);
        this.parseAsynchronousContinuationForActivity(intermediateEventElement, nestedActivity);
        boolean bl = isEventBaseGatewayPresent = eventBasedGateway != null;
        if (isEventBaseGatewayPresent) {
            nestedActivity.setEventScope(eventBasedGateway);
            nestedActivity.setActivityStartBehavior(ActivityStartBehavior.CANCEL_EVENT_SCOPE);
        } else {
            nestedActivity.setEventScope(nestedActivity);
            nestedActivity.setScope(true);
        }
        nestedActivity.setActivityBehavior(defaultCatchBehaviour);
        if (timerEventDefinition != null) {
            this.parseIntermediateTimerEventDefinition(timerEventDefinition, nestedActivity);
        } else if (signalEventDefinition != null) {
            this.parseIntermediateSignalEventDefinition(signalEventDefinition, nestedActivity);
        } else if (messageEventDefinition != null) {
            this.parseIntermediateMessageEventDefinition(messageEventDefinition, nestedActivity);
        } else if (linkEventDefinitionElement != null) {
            if (isEventBaseGatewayPresent) {
                this.addError("IntermediateCatchLinkEvent is not allowed after an EventBasedGateway.", intermediateEventElement);
            }
            nestedActivity.setActivityBehavior(new IntermediateCatchLinkEventActivityBehavior());
            this.parseIntermediateLinkEventCatchBehavior(intermediateEventElement, nestedActivity, linkEventDefinitionElement);
        } else if (conditionalEventDefinitionElement != null) {
            ConditionalEventDefinition conditionalEvent = this.parseIntermediateConditionalEventDefinition(conditionalEventDefinitionElement, nestedActivity);
            nestedActivity.setActivityBehavior(new IntermediateConditionalEventBehavior(conditionalEvent, isEventBaseGatewayPresent));
        } else {
            this.addError("Unsupported intermediate catch event type", intermediateEventElement);
        }
        this.parseExecutionListenersOnScope(intermediateEventElement, nestedActivity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseIntermediateCatchEvent(intermediateEventElement, scopeElement, nestedActivity);
        }
        return nestedActivity;
    }

    protected void parseIntermediateLinkEventCatchBehavior(Element intermediateEventElement, ActivityImpl activity, Element linkEventDefinitionElement) {
        activity.getProperties().set(BpmnProperties.TYPE, "intermediateLinkCatch");
        String linkName = linkEventDefinitionElement.attribute("name");
        String elementName = intermediateEventElement.attribute("name");
        String elementId = intermediateEventElement.attribute("id");
        if (this.eventLinkTargets.containsKey(linkName)) {
            this.addError("Multiple Intermediate Catch Events with the same link event name ('" + linkName + "') are not allowed.", intermediateEventElement);
        } else {
            if (!linkName.equals(elementName)) {
                this.addWarning("Link Event named '" + elementName + "' contains link event definition with name '" + linkName + "' - it is recommended to use the same name for both.", intermediateEventElement);
            }
            this.eventLinkTargets.put(linkName, elementId);
        }
    }

    protected void parseIntermediateMessageEventDefinition(Element messageEventDefinition, ActivityImpl nestedActivity) {
        nestedActivity.getProperties().set(BpmnProperties.TYPE, "intermediateMessageCatch");
        EventSubscriptionDeclaration messageDefinition = this.parseMessageEventDefinition(messageEventDefinition, nestedActivity.getId());
        messageDefinition.setActivityId(nestedActivity.getId());
        this.addEventSubscriptionDeclaration(messageDefinition, nestedActivity.getEventScope(), messageEventDefinition);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseIntermediateMessageCatchEventDefinition(messageEventDefinition, nestedActivity);
        }
    }

    public ActivityImpl parseIntermediateThrowEvent(Element intermediateEventElement, ScopeImpl scopeElement) {
        Element signalEventDefinitionElement = intermediateEventElement.element(SIGNAL_EVENT_DEFINITION);
        Element compensateEventDefinitionElement = intermediateEventElement.element(COMPENSATE_EVENT_DEFINITION);
        Element linkEventDefinitionElement = intermediateEventElement.element(LINK_EVENT_DEFINITION);
        Element messageEventDefinitionElement = intermediateEventElement.element(MESSAGE_EVENT_DEFINITION);
        Element escalationEventDefinition = intermediateEventElement.element(ESCALATION_EVENT_DEFINITION);
        String elementId = intermediateEventElement.attribute("id");
        if (linkEventDefinitionElement != null) {
            String linkName = linkEventDefinitionElement.attribute("name");
            this.eventLinkSources.put(elementId, linkName);
            return null;
        }
        ActivityImpl nestedActivityImpl = this.createActivityOnScope(intermediateEventElement, scopeElement);
        FlowNodeActivityBehavior activityBehavior = null;
        this.parseAsynchronousContinuationForActivity(intermediateEventElement, nestedActivityImpl);
        boolean isServiceTaskLike = this.isServiceTaskLike(messageEventDefinitionElement);
        if (signalEventDefinitionElement != null) {
            nestedActivityImpl.getProperties().set(BpmnProperties.TYPE, "intermediateSignalThrow");
            EventSubscriptionDeclaration signalDefinition = this.parseSignalEventDefinition(signalEventDefinitionElement, true, nestedActivityImpl.getId());
            activityBehavior = new ThrowSignalEventActivityBehavior(signalDefinition);
        } else if (compensateEventDefinitionElement != null) {
            nestedActivityImpl.getProperties().set(BpmnProperties.TYPE, "intermediateCompensationThrowEvent");
            CompensateEventDefinition compensateEventDefinition = this.parseThrowCompensateEventDefinition(compensateEventDefinitionElement, scopeElement, elementId);
            activityBehavior = new CompensationEventActivityBehavior(compensateEventDefinition);
            nestedActivityImpl.setProperty(PROPERTYNAME_THROWS_COMPENSATION, true);
            nestedActivityImpl.setScope(true);
        } else if (messageEventDefinitionElement != null) {
            if (isServiceTaskLike) {
                nestedActivityImpl.getProperties().set(BpmnProperties.TYPE, "intermediateMessageThrowEvent");
                this.parseServiceTaskLike(nestedActivityImpl, "intermediateMessageThrowEvent", messageEventDefinitionElement, intermediateEventElement, scopeElement);
            } else {
                nestedActivityImpl.getProperties().set(BpmnProperties.TYPE, "intermediateNoneThrowEvent");
                activityBehavior = new IntermediateThrowNoneEventActivityBehavior();
            }
        } else if (escalationEventDefinition != null) {
            nestedActivityImpl.getProperties().set(BpmnProperties.TYPE, "intermediateEscalationThrowEvent");
            Escalation escalation = this.findEscalationForEscalationEventDefinition(escalationEventDefinition, nestedActivityImpl.getId());
            if (escalation != null && escalation.getEscalationCode() == null) {
                this.addError("throwing escalation event must have an 'escalationCode'", escalationEventDefinition, nestedActivityImpl.getId());
            }
            activityBehavior = new ThrowEscalationEventActivityBehavior(escalation);
        } else {
            nestedActivityImpl.getProperties().set(BpmnProperties.TYPE, "intermediateNoneThrowEvent");
            activityBehavior = new IntermediateThrowNoneEventActivityBehavior();
        }
        if (activityBehavior != null) {
            nestedActivityImpl.setActivityBehavior(activityBehavior);
        }
        this.parseExecutionListenersOnScope(intermediateEventElement, nestedActivityImpl);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseIntermediateThrowEvent(intermediateEventElement, scopeElement, nestedActivityImpl);
        }
        if (isServiceTaskLike) {
            this.validateServiceTaskLike(nestedActivityImpl, "intermediateMessageThrowEvent", messageEventDefinitionElement);
        }
        return nestedActivityImpl;
    }

    protected CompensateEventDefinition parseThrowCompensateEventDefinition(final Element compensateEventDefinitionElement, ScopeImpl scopeElement, final String parentElementId) {
        final String activityRef = compensateEventDefinitionElement.attribute("activityRef");
        boolean waitForCompletion = TRUE.equals(compensateEventDefinitionElement.attribute("waitForCompletion", TRUE));
        if (activityRef != null && scopeElement.findActivityAtLevelOfSubprocess(activityRef) == null) {
            Boolean isTriggeredByEvent = scopeElement.getProperties().get(BpmnProperties.TRIGGERED_BY_EVENT);
            String type = (String)scopeElement.getProperty(PROPERTYNAME_TYPE);
            if (Boolean.TRUE == isTriggeredByEvent && "subProcess".equals(type)) {
                scopeElement = scopeElement.getFlowScope();
            }
            if (scopeElement.findActivityAtLevelOfSubprocess(activityRef) == null) {
                final String scopeId = scopeElement.getId();
                scopeElement.addToBacklog(activityRef, new ScopeImpl.BacklogErrorCallback(){

                    @Override
                    public void callback() {
                        BpmnParse.this.addError("Invalid attribute value for 'activityRef': no activity with id '" + activityRef + "' in scope '" + scopeId + "'", compensateEventDefinitionElement, parentElementId);
                    }
                });
            }
        }
        CompensateEventDefinition compensateEventDefinition = new CompensateEventDefinition();
        compensateEventDefinition.setActivityRef(activityRef);
        compensateEventDefinition.setWaitForCompletion(waitForCompletion);
        if (!waitForCompletion) {
            this.addWarning("Unsupported attribute value for 'waitForCompletion': 'waitForCompletion=false' is not supported. Compensation event will wait for compensation to join.", compensateEventDefinitionElement, parentElementId);
        }
        return compensateEventDefinition;
    }

    protected void validateCatchCompensateEventDefinition(Element compensateEventDefinitionElement, String parentElementId) {
        String waitForCompletion;
        String activityRef = compensateEventDefinitionElement.attribute("activityRef");
        if (activityRef != null) {
            this.addWarning("attribute 'activityRef' is not supported on catching compensation event. attribute will be ignored", compensateEventDefinitionElement, parentElementId);
        }
        if ((waitForCompletion = compensateEventDefinitionElement.attribute("waitForCompletion")) != null) {
            this.addWarning("attribute 'waitForCompletion' is not supported on catching compensation event. attribute will be ignored", compensateEventDefinitionElement, parentElementId);
        }
    }

    protected void parseBoundaryCompensateEventDefinition(Element compensateEventDefinition, ActivityImpl activity) {
        activity.getProperties().set(BpmnProperties.TYPE, "compensationBoundaryCatch");
        ScopeImpl hostActivity = activity.getEventScope();
        for (ActivityImpl sibling : activity.getFlowScope().getActivities()) {
            if (!sibling.getProperty(BpmnProperties.TYPE.getName()).equals("compensationBoundaryCatch") || !sibling.getEventScope().equals(hostActivity) || sibling == activity) continue;
            this.addError("multiple boundary events with compensateEventDefinition not supported on same activity", compensateEventDefinition, activity.getId());
        }
        this.validateCatchCompensateEventDefinition(compensateEventDefinition, activity.getId());
    }

    protected ActivityBehavior parseBoundaryCancelEventDefinition(Element cancelEventDefinition, ActivityImpl activity) {
        activity.getProperties().set(BpmnProperties.TYPE, "cancelBoundaryCatch");
        LegacyBehavior.parseCancelBoundaryEvent(activity);
        ActivityImpl transaction = (ActivityImpl)activity.getEventScope();
        if (transaction.getActivityBehavior() != null && transaction.getActivityBehavior() instanceof MultiInstanceActivityBehavior) {
            transaction = transaction.getActivities().get(0);
        }
        if (!"transaction".equals(transaction.getProperty(BpmnProperties.TYPE.getName()))) {
            this.addError("boundary event with cancelEventDefinition only supported on transaction subprocesses", cancelEventDefinition, activity.getId());
        }
        for (ActivityImpl sibling : activity.getFlowScope().getActivities()) {
            if (!"cancelBoundaryCatch".equals(sibling.getProperty(BpmnProperties.TYPE.getName())) || sibling == activity || sibling.getEventScope() != transaction) continue;
            this.addError("multiple boundary events with cancelEventDefinition not supported on same transaction subprocess", cancelEventDefinition, activity.getId());
        }
        for (ActivityImpl childActivity : transaction.getActivities()) {
            ActivityBehavior activityBehavior = childActivity.getActivityBehavior();
            if (activityBehavior == null || !(activityBehavior instanceof CancelEndEventActivityBehavior)) continue;
            ((CancelEndEventActivityBehavior)activityBehavior).setCancelBoundaryEvent(activity);
        }
        return new CancelBoundaryEventActivityBehavior();
    }

    public ScopeImpl parseMultiInstanceLoopCharacteristics(Element activityElement, ScopeImpl scope) {
        Element inputDataItem;
        String elementVariable;
        String loopDataInputRefText;
        Element loopDataInputRef;
        String collection;
        Element completionCondition;
        Element miLoopCharacteristics = activityElement.element("multiInstanceLoopCharacteristics");
        if (miLoopCharacteristics == null) {
            return null;
        }
        String id = activityElement.attribute("id");
        LOG.parsingElement("mi body for activity", id);
        id = BpmnParse.getIdForMiBody(id);
        ActivityImpl miBodyScope = scope.createActivity(id);
        this.setActivityAsyncDelegates(miBodyScope);
        miBodyScope.setProperty(PROPERTYNAME_TYPE, "multiInstanceBody");
        miBodyScope.setScope(true);
        boolean isSequential = this.parseBooleanAttribute(miLoopCharacteristics.attribute("isSequential"), false);
        MultiInstanceActivityBehavior behavior = null;
        behavior = isSequential ? new SequentialMultiInstanceActivityBehavior() : new ParallelMultiInstanceActivityBehavior();
        miBodyScope.setActivityBehavior(behavior);
        Element loopCardinality = miLoopCharacteristics.element("loopCardinality");
        if (loopCardinality != null) {
            String loopCardinalityText = loopCardinality.getText();
            if (loopCardinalityText == null || "".equals(loopCardinalityText)) {
                this.addError("loopCardinality must be defined for a multiInstanceLoopCharacteristics definition ", miLoopCharacteristics, id);
            }
            behavior.setLoopCardinalityExpression(this.expressionManager.createExpression(loopCardinalityText));
        }
        if ((completionCondition = miLoopCharacteristics.element("completionCondition")) != null) {
            String completionConditionText = completionCondition.getText();
            behavior.setCompletionConditionExpression(this.expressionManager.createExpression(completionConditionText));
        }
        if ((collection = miLoopCharacteristics.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "collection")) != null) {
            if (collection.contains("{")) {
                behavior.setCollectionExpression(this.expressionManager.createExpression(collection));
            } else {
                behavior.setCollectionVariable(collection);
            }
        }
        if ((loopDataInputRef = miLoopCharacteristics.element("loopDataInputRef")) != null && (loopDataInputRefText = loopDataInputRef.getText()) != null) {
            if (loopDataInputRefText.contains("{")) {
                behavior.setCollectionExpression(this.expressionManager.createExpression(loopDataInputRefText));
            } else {
                behavior.setCollectionVariable(loopDataInputRefText);
            }
        }
        if ((elementVariable = miLoopCharacteristics.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "elementVariable")) != null) {
            behavior.setCollectionElementVariable(elementVariable);
        }
        if ((inputDataItem = miLoopCharacteristics.element("inputDataItem")) != null) {
            String inputDataItemName = inputDataItem.attribute("name");
            behavior.setCollectionElementVariable(inputDataItemName);
        }
        if (behavior.getLoopCardinalityExpression() == null && behavior.getCollectionExpression() == null && behavior.getCollectionVariable() == null) {
            this.addError("Either loopCardinality or loopDataInputRef/activiti:collection must be set", miLoopCharacteristics, id);
        }
        if (behavior.getCollectionExpression() == null && behavior.getCollectionVariable() == null && behavior.getCollectionElementVariable() != null) {
            this.addError("LoopDataInputRef/activiti:collection must be set when using inputDataItem or activiti:elementVariable", miLoopCharacteristics, id);
        }
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseMultiInstanceLoopCharacteristics(activityElement, miLoopCharacteristics, miBodyScope);
        }
        return miBodyScope;
    }

    public static String getIdForMiBody(String id) {
        return id + MULTI_INSTANCE_BODY_ID_SUFFIX;
    }

    public ActivityImpl createActivityOnScope(Element activityElement, ScopeImpl scopeElement) {
        String id = activityElement.attribute("id");
        LOG.parsingElement("activity", id);
        ActivityImpl activity = scopeElement.createActivity(id);
        activity.setProperty("name", activityElement.attribute("name"));
        activity.setProperty(PROPERTYNAME_DOCUMENTATION, this.parseDocumentation(activityElement));
        activity.setProperty("default", activityElement.attribute("default"));
        activity.getProperties().set(BpmnProperties.TYPE, activityElement.getTagName());
        activity.setProperty("line", activityElement.getLine());
        this.setActivityAsyncDelegates(activity);
        activity.setProperty(PROPERTYNAME_JOB_PRIORITY, this.parsePriority(activityElement, PROPERTYNAME_JOB_PRIORITY));
        if (this.isCompensationHandler(activityElement)) {
            activity.setProperty(PROPERTYNAME_IS_FOR_COMPENSATION, true);
        }
        return activity;
    }

    protected void setActivityAsyncDelegates(final ActivityImpl activity) {
        activity.setDelegateAsyncAfterUpdate(new ActivityImpl.AsyncAfterUpdate(){

            @Override
            public void updateAsyncAfter(boolean asyncAfter, boolean exclusive) {
                if (asyncAfter) {
                    BpmnParse.this.addMessageJobDeclaration(new AsyncAfterMessageJobDeclaration(), activity, exclusive);
                } else {
                    BpmnParse.this.removeMessageJobDeclarationWithJobConfiguration(activity, "async-after");
                }
            }
        });
        activity.setDelegateAsyncBeforeUpdate(new ActivityImpl.AsyncBeforeUpdate(){

            @Override
            public void updateAsyncBefore(boolean asyncBefore, boolean exclusive) {
                if (asyncBefore) {
                    BpmnParse.this.addMessageJobDeclaration(new AsyncBeforeMessageJobDeclaration(), activity, exclusive);
                } else {
                    BpmnParse.this.removeMessageJobDeclarationWithJobConfiguration(activity, "async-before");
                }
            }
        });
    }

    protected void addMessageJobDeclaration(MessageJobDeclaration messageJobDeclaration, ActivityImpl activity, boolean exclusive) {
        ProcessDefinition procDef = (ProcessDefinition)((Object)activity.getProcessDefinition());
        if (!this.exists(messageJobDeclaration, procDef.getKey(), activity.getActivityId())) {
            messageJobDeclaration.setExclusive(exclusive);
            messageJobDeclaration.setActivity(activity);
            messageJobDeclaration.setJobPriorityProvider((ParameterValueProvider)activity.getProperty(PROPERTYNAME_JOB_PRIORITY));
            this.addMessageJobDeclarationToActivity(messageJobDeclaration, activity);
            this.addJobDeclarationToProcessDefinition(messageJobDeclaration, procDef);
        }
    }

    protected boolean exists(MessageJobDeclaration msgJobdecl, String procDefKey, String activityId) {
        boolean exist = false;
        List<JobDeclaration<?, ?>> declarations = this.jobDeclarations.get(procDefKey);
        if (declarations != null) {
            for (int i = 0; i < declarations.size() && !exist; ++i) {
                JobDeclaration<?, ?> decl = declarations.get(i);
                if (!decl.getActivityId().equals(activityId) || !decl.getJobConfiguration().equalsIgnoreCase(msgJobdecl.getJobConfiguration())) continue;
                exist = true;
            }
        }
        return exist;
    }

    protected void removeMessageJobDeclarationWithJobConfiguration(ActivityImpl activity, String jobConfiguration) {
        ProcessDefinition procDef;
        List<JobDeclaration<?, ?>> declarations;
        List messageJobDeclarations = (List)activity.getProperty(PROPERTYNAME_MESSAGE_JOB_DECLARATION);
        if (messageJobDeclarations != null) {
            Iterator iter = messageJobDeclarations.iterator();
            while (iter.hasNext()) {
                MessageJobDeclaration msgDecl = (MessageJobDeclaration)iter.next();
                if (!msgDecl.getJobConfiguration().equalsIgnoreCase(jobConfiguration) || !msgDecl.getActivityId().equalsIgnoreCase(activity.getActivityId())) continue;
                iter.remove();
            }
        }
        if ((declarations = this.jobDeclarations.get((procDef = (ProcessDefinition)((Object)activity.getProcessDefinition())).getKey())) != null) {
            Iterator<JobDeclaration<?, ?>> iter = declarations.iterator();
            while (iter.hasNext()) {
                JobDeclaration<?, ?> jobDcl = iter.next();
                if (!jobDcl.getJobConfiguration().equalsIgnoreCase(jobConfiguration) || !jobDcl.getActivityId().equalsIgnoreCase(activity.getActivityId())) continue;
                iter.remove();
            }
        }
    }

    public String parseDocumentation(Element element) {
        List<Element> docElements = element.elements(PROPERTYNAME_DOCUMENTATION);
        ArrayList<String> docStrings = new ArrayList<String>();
        for (Element e : docElements) {
            docStrings.add(e.getText());
        }
        return BpmnParse.parseDocumentation(docStrings);
    }

    public static String parseDocumentation(List<String> docStrings) {
        if (docStrings.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (String e : docStrings) {
            if (builder.length() != 0) {
                builder.append("\n\n");
            }
            builder.append(e.trim());
        }
        return builder.toString();
    }

    protected boolean isCompensationHandler(Element activityElement) {
        String isForCompensation = activityElement.attribute(PROPERTYNAME_IS_FOR_COMPENSATION);
        return isForCompensation != null && isForCompensation.equalsIgnoreCase(TRUE);
    }

    public ActivityImpl parseExclusiveGateway(Element exclusiveGwElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(exclusiveGwElement, scope);
        activity.setActivityBehavior(new ExclusiveGatewayActivityBehavior());
        this.parseAsynchronousContinuationForActivity(exclusiveGwElement, activity);
        this.parseExecutionListenersOnScope(exclusiveGwElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseExclusiveGateway(exclusiveGwElement, scope, activity);
        }
        return activity;
    }

    public ActivityImpl parseInclusiveGateway(Element inclusiveGwElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(inclusiveGwElement, scope);
        activity.setActivityBehavior(new InclusiveGatewayActivityBehavior());
        this.parseAsynchronousContinuationForActivity(inclusiveGwElement, activity);
        this.parseExecutionListenersOnScope(inclusiveGwElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseInclusiveGateway(inclusiveGwElement, scope, activity);
        }
        return activity;
    }

    public ActivityImpl parseEventBasedGateway(Element eventBasedGwElement, Element parentElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(eventBasedGwElement, scope);
        activity.setActivityBehavior(new EventBasedGatewayActivityBehavior());
        activity.setScope(true);
        this.parseAsynchronousContinuationForActivity(eventBasedGwElement, activity);
        if (activity.isAsyncAfter()) {
            this.addError("'asyncAfter' not supported for " + eventBasedGwElement.getTagName() + " elements.", eventBasedGwElement);
        }
        this.parseExecutionListenersOnScope(eventBasedGwElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseEventBasedGateway(eventBasedGwElement, scope, activity);
        }
        List<Element> sequenceFlows = parentElement.elements("sequenceFlow");
        HashMap<String, Element> siblingsMap = new HashMap<String, Element>();
        List<Element> siblings = parentElement.elements();
        for (Element sibling : siblings) {
            siblingsMap.put(sibling.attribute("id"), sibling);
        }
        for (Element sequenceFlow : sequenceFlows) {
            Element sibling;
            String sourceRef = sequenceFlow.attribute("sourceRef");
            String targetRef = sequenceFlow.attribute("targetRef");
            if (!activity.getId().equals(sourceRef) || (sibling = (Element)siblingsMap.get(targetRef)) == null) continue;
            if (sibling.getTagName().equals("intermediateCatchEvent")) {
                ActivityImpl catchEventActivity = this.parseIntermediateCatchEvent(sibling, scope, activity);
                if (catchEventActivity == null) continue;
                this.parseActivityInputOutput(sibling, catchEventActivity);
                continue;
            }
            this.addError("Event based gateway can only be connected to elements of type intermediateCatchEvent", eventBasedGwElement);
        }
        return activity;
    }

    public ActivityImpl parseParallelGateway(Element parallelGwElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(parallelGwElement, scope);
        activity.setActivityBehavior(new ParallelGatewayActivityBehavior());
        this.parseAsynchronousContinuationForActivity(parallelGwElement, activity);
        this.parseExecutionListenersOnScope(parallelGwElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseParallelGateway(parallelGwElement, scope, activity);
        }
        return activity;
    }

    public ActivityImpl parseScriptTask(Element scriptTaskElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(scriptTaskElement, scope);
        ScriptTaskActivityBehavior activityBehavior = this.parseScriptTaskElement(scriptTaskElement);
        if (activityBehavior != null) {
            this.parseAsynchronousContinuationForActivity(scriptTaskElement, activity);
            activity.setActivityBehavior(activityBehavior);
            this.parseExecutionListenersOnScope(scriptTaskElement, activity);
            for (BpmnParseListener parseListener : this.parseListeners) {
                parseListener.parseScriptTask(scriptTaskElement, scope, activity);
            }
        }
        return activity;
    }

    protected ScriptTaskActivityBehavior parseScriptTaskElement(Element scriptTaskElement) {
        String language = scriptTaskElement.attribute("scriptFormat");
        if (language == null) {
            language = "juel";
        }
        String resultVariableName = this.parseResultVariable(scriptTaskElement);
        String scriptSource = null;
        Element scriptElement = scriptTaskElement.element("script");
        if (scriptElement != null) {
            scriptSource = scriptElement.getText();
        }
        String scriptResource = scriptTaskElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, PROPERTYNAME_RESOURCE);
        try {
            ExecutableScript script = ScriptUtil.getScript(language, scriptSource, scriptResource, this.expressionManager);
            return new ScriptTaskActivityBehavior(script, resultVariableName);
        }
        catch (ProcessEngineException e) {
            this.addError("Unable to process ScriptTask: " + e.getMessage(), scriptElement);
            return null;
        }
    }

    protected String parseResultVariable(Element element) {
        String resultVariableName = element.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "resultVariable");
        if (resultVariableName == null) {
            resultVariableName = element.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "resultVariableName");
        }
        return resultVariableName;
    }

    public ActivityImpl parseServiceTask(Element serviceTaskElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(serviceTaskElement, scope);
        this.parseAsynchronousContinuationForActivity(serviceTaskElement, activity);
        String elementName = "serviceTask";
        this.parseServiceTaskLike(activity, elementName, serviceTaskElement, serviceTaskElement, scope);
        this.parseExecutionListenersOnScope(serviceTaskElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseServiceTask(serviceTaskElement, scope, activity);
        }
        this.validateServiceTaskLike(activity, elementName, serviceTaskElement);
        return activity;
    }

    public void parseServiceTaskLike(ActivityImpl activity, String elementName, Element serviceTaskElement, Element camundaPropertiesElement, ScopeImpl scope) {
        String type = serviceTaskElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, TYPE);
        String className = serviceTaskElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, PROPERTYNAME_CLASS);
        String expression = serviceTaskElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, PROPERTYNAME_EXPRESSION);
        String delegateExpression = serviceTaskElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, PROPERTYNAME_DELEGATE_EXPRESSION);
        String resultVariableName = this.parseResultVariable(serviceTaskElement);
        if (type != null) {
            if (type.equalsIgnoreCase("mail")) {
                this.parseEmailServiceTask(activity, serviceTaskElement, this.parseFieldDeclarations(serviceTaskElement));
            } else if (type.equalsIgnoreCase("shell")) {
                this.parseShellServiceTask(activity, serviceTaskElement, this.parseFieldDeclarations(serviceTaskElement));
            } else if (type.equalsIgnoreCase("external")) {
                this.parseExternalServiceTask(activity, serviceTaskElement, camundaPropertiesElement);
            } else {
                this.addError("Invalid usage of type attribute on " + elementName + ": '" + type + "'", serviceTaskElement);
            }
        } else if (className != null && className.trim().length() > 0) {
            if (resultVariableName != null) {
                this.addError("'resultVariableName' not supported for " + elementName + " elements using 'class'", serviceTaskElement);
            }
            activity.setActivityBehavior(new ClassDelegateActivityBehavior(className, this.parseFieldDeclarations(serviceTaskElement)));
        } else if (delegateExpression != null) {
            if (resultVariableName != null) {
                this.addError("'resultVariableName' not supported for " + elementName + " elements using 'delegateExpression'", serviceTaskElement);
            }
            activity.setActivityBehavior(new ServiceTaskDelegateExpressionActivityBehavior(this.expressionManager.createExpression(delegateExpression), this.parseFieldDeclarations(serviceTaskElement)));
        } else if (expression != null && expression.trim().length() > 0) {
            activity.setActivityBehavior(new ServiceTaskExpressionActivityBehavior(this.expressionManager.createExpression(expression), resultVariableName));
        }
    }

    protected void validateServiceTaskLike(ActivityImpl activity, String elementName, Element serviceTaskElement) {
        if (activity.getActivityBehavior() == null) {
            this.addError("One of the attributes 'class', 'delegateExpression', 'type', or 'expression' is mandatory on " + elementName + ". If you are using a connector, make sure theconnect process engine plugin is registered with the process engine.", serviceTaskElement);
        }
    }

    public ActivityImpl parseBusinessRuleTask(Element businessRuleTaskElement, ScopeImpl scope) {
        String decisionRef = businessRuleTaskElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "decisionRef");
        if (decisionRef != null) {
            return this.parseDmnBusinessRuleTask(businessRuleTaskElement, scope);
        }
        ActivityImpl activity = this.createActivityOnScope(businessRuleTaskElement, scope);
        this.parseAsynchronousContinuationForActivity(businessRuleTaskElement, activity);
        String elementName = "businessRuleTask";
        this.parseServiceTaskLike(activity, elementName, businessRuleTaskElement, businessRuleTaskElement, scope);
        this.parseExecutionListenersOnScope(businessRuleTaskElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseBusinessRuleTask(businessRuleTaskElement, scope, activity);
        }
        this.validateServiceTaskLike(activity, elementName, businessRuleTaskElement);
        return activity;
    }

    protected ActivityImpl parseDmnBusinessRuleTask(Element businessRuleTaskElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(businessRuleTaskElement, scope);
        activity.setScope(true);
        this.parseAsynchronousContinuationForActivity(businessRuleTaskElement, activity);
        String decisionRef = businessRuleTaskElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "decisionRef");
        BaseCallableElement callableElement = new BaseCallableElement();
        callableElement.setDeploymentId(this.deployment.getId());
        ParameterValueProvider definitionKeyProvider = this.createParameterValueProvider(decisionRef, this.expressionManager);
        callableElement.setDefinitionKeyValueProvider(definitionKeyProvider);
        this.parseBinding(businessRuleTaskElement, activity, callableElement, "decisionRefBinding");
        this.parseVersion(businessRuleTaskElement, activity, callableElement, "decisionRefBinding", "decisionRefVersion");
        this.parseVersionTag(businessRuleTaskElement, activity, callableElement, "decisionRefBinding", "decisionRefVersionTag");
        this.parseTenantId(businessRuleTaskElement, activity, callableElement, "decisionRefTenantId");
        String resultVariable = this.parseResultVariable(businessRuleTaskElement);
        DecisionResultMapper decisionResultMapper = this.parseDecisionResultMapper(businessRuleTaskElement);
        DmnBusinessRuleTaskActivityBehavior behavior = new DmnBusinessRuleTaskActivityBehavior(callableElement, resultVariable, decisionResultMapper);
        activity.setActivityBehavior(behavior);
        this.parseExecutionListenersOnScope(businessRuleTaskElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseBusinessRuleTask(businessRuleTaskElement, scope, activity);
        }
        return activity;
    }

    protected DecisionResultMapper parseDecisionResultMapper(Element businessRuleTaskElement) {
        String decisionResultMapper = businessRuleTaskElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "mapDecisionResult");
        DecisionResultMapper mapper = DecisionEvaluationUtil.getDecisionResultMapperForName(decisionResultMapper);
        if (mapper == null) {
            this.addError("No decision result mapper found for name '" + decisionResultMapper + "'. Supported mappers are 'singleEntry', 'singleResult', 'collectEntries' and 'resultList'.", businessRuleTaskElement);
        }
        return mapper;
    }

    protected void parseAsynchronousContinuationForActivity(Element activityElement, ActivityImpl activity) {
        ActivityImpl parentFlowScopeActivity = activity.getParentFlowScopeActivity();
        if (parentFlowScopeActivity != null && parentFlowScopeActivity.getActivityBehavior() instanceof MultiInstanceActivityBehavior && !activity.isCompensationHandler()) {
            this.parseAsynchronousContinuation(activityElement, parentFlowScopeActivity);
            Element miLoopCharacteristics = activityElement.element("multiInstanceLoopCharacteristics");
            this.parseAsynchronousContinuation(miLoopCharacteristics, activity);
        } else {
            this.parseAsynchronousContinuation(activityElement, activity);
        }
    }

    protected void parseAsynchronousContinuation(Element element, ActivityImpl activity) {
        boolean isAsyncBefore = this.isAsyncBefore(element);
        boolean isAsyncAfter = this.isAsyncAfter(element);
        boolean exclusive = this.isExclusive(element);
        activity.setAsyncBefore(isAsyncBefore, exclusive);
        activity.setAsyncAfter(isAsyncAfter, exclusive);
    }

    protected ParameterValueProvider parsePriority(Element element, String priorityAttribute) {
        String priorityAttributeValue = element.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, priorityAttribute);
        if (priorityAttributeValue == null) {
            return null;
        }
        Object value = priorityAttributeValue;
        if (!StringUtil.isExpression(priorityAttributeValue)) {
            try {
                value = Integer.parseInt(priorityAttributeValue);
            }
            catch (NumberFormatException e) {
                this.addError("Value '" + priorityAttributeValue + "' for attribute '" + priorityAttribute + "' is not a valid number", element);
            }
        }
        return this.createParameterValueProvider(value, this.expressionManager);
    }

    protected ParameterValueProvider parseTopic(Element element, String topicAttribute) {
        String topicAttributeValue = element.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, topicAttribute);
        if (topicAttributeValue == null) {
            this.addError("External tasks must specify a 'topic' attribute in the camunda namespace", element);
            return null;
        }
        return this.createParameterValueProvider(topicAttributeValue, this.expressionManager);
    }

    protected void addMessageJobDeclarationToActivity(MessageJobDeclaration messageJobDeclaration, ActivityImpl activity) {
        ArrayList<MessageJobDeclaration> messageJobDeclarations = (ArrayList<MessageJobDeclaration>)activity.getProperty(PROPERTYNAME_MESSAGE_JOB_DECLARATION);
        if (messageJobDeclarations == null) {
            messageJobDeclarations = new ArrayList<MessageJobDeclaration>();
            activity.setProperty(PROPERTYNAME_MESSAGE_JOB_DECLARATION, messageJobDeclarations);
        }
        messageJobDeclarations.add(messageJobDeclaration);
    }

    protected void addJobDeclarationToProcessDefinition(JobDeclaration<?, ?> jobDeclaration, ProcessDefinition processDefinition) {
        String key = processDefinition.getKey();
        List<JobDeclaration<?, ?>> containingJobDeclarations = this.jobDeclarations.get(key);
        if (containingJobDeclarations == null) {
            containingJobDeclarations = new ArrayList();
            this.jobDeclarations.put(key, containingJobDeclarations);
        }
        containingJobDeclarations.add(jobDeclaration);
    }

    public ActivityImpl parseSendTask(Element sendTaskElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(sendTaskElement, scope);
        if (this.isServiceTaskLike(sendTaskElement)) {
            String elementName = "sendTask";
            this.parseAsynchronousContinuationForActivity(sendTaskElement, activity);
            this.parseServiceTaskLike(activity, elementName, sendTaskElement, sendTaskElement, scope);
            this.parseExecutionListenersOnScope(sendTaskElement, activity);
            for (BpmnParseListener parseListener : this.parseListeners) {
                parseListener.parseSendTask(sendTaskElement, scope, activity);
            }
            this.validateServiceTaskLike(activity, elementName, sendTaskElement);
        } else {
            this.parseAsynchronousContinuationForActivity(sendTaskElement, activity);
            this.parseExecutionListenersOnScope(sendTaskElement, activity);
            for (BpmnParseListener parseListener : this.parseListeners) {
                parseListener.parseSendTask(sendTaskElement, scope, activity);
            }
            if (activity.getActivityBehavior() == null) {
                this.addError("One of the attributes 'class', 'delegateExpression', 'type', or 'expression' is mandatory on sendTask.", sendTaskElement);
            }
        }
        return activity;
    }

    protected void parseEmailServiceTask(ActivityImpl activity, Element serviceTaskElement, List<FieldDeclaration> fieldDeclarations) {
        this.validateFieldDeclarationsForEmail(serviceTaskElement, fieldDeclarations);
        activity.setActivityBehavior((MailActivityBehavior)ClassDelegateUtil.instantiateDelegate(MailActivityBehavior.class, fieldDeclarations));
    }

    protected void parseShellServiceTask(ActivityImpl activity, Element serviceTaskElement, List<FieldDeclaration> fieldDeclarations) {
        this.validateFieldDeclarationsForShell(serviceTaskElement, fieldDeclarations);
        activity.setActivityBehavior((ActivityBehavior)ClassDelegateUtil.instantiateDelegate(ShellActivityBehavior.class, fieldDeclarations));
    }

    protected void parseExternalServiceTask(ActivityImpl activity, Element serviceTaskElement, Element camundaPropertiesElement) {
        activity.setScope(true);
        ParameterValueProvider topicNameProvider = this.parseTopic(serviceTaskElement, PROPERTYNAME_EXTERNAL_TASK_TOPIC);
        ParameterValueProvider priorityProvider = this.parsePriority(serviceTaskElement, PROPERTYNAME_TASK_PRIORITY);
        Map<String, String> properties = BpmnParseUtil.parseCamundaExtensionProperties(camundaPropertiesElement);
        activity.getProperties().set(BpmnProperties.EXTENSION_PROPERTIES, properties);
        List<CamundaErrorEventDefinition> camundaErrorEventDefinitions = this.parseCamundaErrorEventDefinitions(activity, serviceTaskElement);
        activity.getProperties().set(BpmnProperties.CAMUNDA_ERROR_EVENT_DEFINITION, camundaErrorEventDefinitions);
        activity.setActivityBehavior(new ExternalTaskActivityBehavior(topicNameProvider, priorityProvider));
    }

    protected void validateFieldDeclarationsForEmail(Element serviceTaskElement, List<FieldDeclaration> fieldDeclarations) {
        boolean toDefined = false;
        boolean textOrHtmlDefined = false;
        for (FieldDeclaration fieldDeclaration : fieldDeclarations) {
            if (fieldDeclaration.getName().equals("to")) {
                toDefined = true;
            }
            if (fieldDeclaration.getName().equals("html")) {
                textOrHtmlDefined = true;
            }
            if (!fieldDeclaration.getName().equals("text")) continue;
            textOrHtmlDefined = true;
        }
        if (!toDefined) {
            this.addError("No recipient is defined on the mail activity", serviceTaskElement);
        }
        if (!textOrHtmlDefined) {
            this.addError("Text or html field should be provided", serviceTaskElement);
        }
    }

    protected void validateFieldDeclarationsForShell(Element serviceTaskElement, List<FieldDeclaration> fieldDeclarations) {
        boolean shellCommandDefined = false;
        for (FieldDeclaration fieldDeclaration : fieldDeclarations) {
            String fieldName = fieldDeclaration.getName();
            FixedValue fieldFixedValue = (FixedValue)fieldDeclaration.getValue();
            String fieldValue = fieldFixedValue.getExpressionText();
            shellCommandDefined |= fieldName.equals("command");
            if (!fieldName.equals("wait") && !fieldName.equals("redirectError") && !fieldName.equals("cleanEnv") || fieldValue.toLowerCase().equals(TRUE) || fieldValue.toLowerCase().equals("false")) continue;
            this.addError("undefined value for shell " + fieldName + " parameter :" + fieldValue.toString(), serviceTaskElement);
        }
        if (!shellCommandDefined) {
            this.addError("No shell command is defined on the shell activity", serviceTaskElement);
        }
    }

    public List<FieldDeclaration> parseFieldDeclarations(Element element) {
        List<Element> fieldDeclarationElements;
        ArrayList<FieldDeclaration> fieldDeclarations = new ArrayList<FieldDeclaration>();
        Element elementWithFieldInjections = element.element("extensionElements");
        if (elementWithFieldInjections == null) {
            elementWithFieldInjections = element;
        }
        if ((fieldDeclarationElements = elementWithFieldInjections.elementsNS(CAMUNDA_BPMN_EXTENSIONS_NS, "field")) != null && !fieldDeclarationElements.isEmpty()) {
            for (Element fieldDeclarationElement : fieldDeclarationElements) {
                FieldDeclaration fieldDeclaration = this.parseFieldDeclaration(element, fieldDeclarationElement);
                if (fieldDeclaration == null) continue;
                fieldDeclarations.add(fieldDeclaration);
            }
        }
        return fieldDeclarations;
    }

    protected FieldDeclaration parseFieldDeclaration(Element serviceTaskElement, Element fieldDeclarationElement) {
        String fieldName = fieldDeclarationElement.attribute("name");
        FieldDeclaration fieldDeclaration = this.parseStringFieldDeclaration(fieldDeclarationElement, serviceTaskElement, fieldName);
        if (fieldDeclaration == null) {
            fieldDeclaration = this.parseExpressionFieldDeclaration(fieldDeclarationElement, serviceTaskElement, fieldName);
        }
        if (fieldDeclaration == null) {
            this.addError("One of the following is mandatory on a field declaration: one of attributes stringValue|expression or one of child elements string|expression", serviceTaskElement);
        }
        return fieldDeclaration;
    }

    protected FieldDeclaration parseStringFieldDeclaration(Element fieldDeclarationElement, Element serviceTaskElement, String fieldName) {
        try {
            String fieldValue = this.getStringValueFromAttributeOrElement("stringValue", "string", fieldDeclarationElement, serviceTaskElement.attribute("id"));
            if (fieldValue != null) {
                return new FieldDeclaration(fieldName, Expression.class.getName(), new FixedValue(fieldValue));
            }
        }
        catch (ProcessEngineException ae) {
            if (ae.getMessage().contains("multiple elements with tag name")) {
                this.addError("Multiple string field declarations found", serviceTaskElement);
            }
            this.addError("Error when paring field declarations: " + ae.getMessage(), serviceTaskElement);
        }
        return null;
    }

    protected FieldDeclaration parseExpressionFieldDeclaration(Element fieldDeclarationElement, Element serviceTaskElement, String fieldName) {
        try {
            String expression = this.getStringValueFromAttributeOrElement(PROPERTYNAME_EXPRESSION, PROPERTYNAME_EXPRESSION, fieldDeclarationElement, serviceTaskElement.attribute("id"));
            if (expression != null && expression.trim().length() > 0) {
                return new FieldDeclaration(fieldName, Expression.class.getName(), this.expressionManager.createExpression(expression));
            }
        }
        catch (ProcessEngineException ae) {
            if (ae.getMessage().contains("multiple elements with tag name")) {
                this.addError("Multiple expression field declarations found", serviceTaskElement);
            }
            this.addError("Error when paring field declarations: " + ae.getMessage(), serviceTaskElement);
        }
        return null;
    }

    protected String getStringValueFromAttributeOrElement(String attributeName, String elementName, Element element, String ancestorElementId) {
        String value = null;
        String attributeValue = element.attribute(attributeName);
        Element childElement = element.elementNS(CAMUNDA_BPMN_EXTENSIONS_NS, elementName);
        String stringElementText = null;
        if (attributeValue != null && childElement != null) {
            this.addError("Can't use attribute '" + attributeName + "' and element '" + elementName + "' together, only use one", element, ancestorElementId);
        } else if (childElement != null) {
            stringElementText = childElement.getText();
            if (stringElementText == null || stringElementText.length() == 0) {
                this.addError("No valid value found in attribute '" + attributeName + "' nor element '" + elementName + "'", element, ancestorElementId);
            } else {
                value = stringElementText;
            }
        } else if (attributeValue != null && attributeValue.length() > 0) {
            value = attributeValue;
        }
        return value;
    }

    public ActivityImpl parseTask(Element taskElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(taskElement, scope);
        activity.setActivityBehavior(new TaskActivityBehavior());
        this.parseAsynchronousContinuationForActivity(taskElement, activity);
        this.parseExecutionListenersOnScope(taskElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseTask(taskElement, scope, activity);
        }
        return activity;
    }

    public ActivityImpl parseManualTask(Element manualTaskElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(manualTaskElement, scope);
        activity.setActivityBehavior(new ManualTaskActivityBehavior());
        this.parseAsynchronousContinuationForActivity(manualTaskElement, activity);
        this.parseExecutionListenersOnScope(manualTaskElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseManualTask(manualTaskElement, scope, activity);
        }
        return activity;
    }

    public ActivityImpl parseReceiveTask(Element receiveTaskElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(receiveTaskElement, scope);
        activity.setActivityBehavior(new ReceiveTaskActivityBehavior());
        this.parseAsynchronousContinuationForActivity(receiveTaskElement, activity);
        this.parseExecutionListenersOnScope(receiveTaskElement, activity);
        if (receiveTaskElement.attribute("messageRef") != null) {
            activity.setScope(true);
            activity.setEventScope(activity);
            EventSubscriptionDeclaration declaration = this.parseMessageEventDefinition(receiveTaskElement, activity.getId());
            declaration.setActivityId(activity.getActivityId());
            declaration.setEventScopeActivityId(activity.getActivityId());
            this.addEventSubscriptionDeclaration(declaration, activity, receiveTaskElement);
        }
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseReceiveTask(receiveTaskElement, scope, activity);
        }
        return activity;
    }

    public ActivityImpl parseUserTask(Element userTaskElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(userTaskElement, scope);
        this.parseAsynchronousContinuationForActivity(userTaskElement, activity);
        TaskDefinition taskDefinition = this.parseTaskDefinition(userTaskElement, activity.getId(), activity, (ProcessDefinitionEntity)scope.getProcessDefinition());
        TaskDecorator taskDecorator = new TaskDecorator(taskDefinition, this.expressionManager);
        UserTaskActivityBehavior userTaskActivity = new UserTaskActivityBehavior(taskDecorator);
        activity.setActivityBehavior(userTaskActivity);
        this.parseProperties(userTaskElement, activity);
        this.parseExecutionListenersOnScope(userTaskElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseUserTask(userTaskElement, scope, activity);
        }
        return activity;
    }

    public TaskDefinition parseTaskDefinition(Element taskElement, String taskDefinitionKey, ActivityImpl activity, ProcessDefinitionEntity processDefinition) {
        String descriptionStr;
        String taskFormHandlerClassName = taskElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "formHandlerClass");
        TaskFormHandler taskFormHandler = taskFormHandlerClassName != null ? (TaskFormHandler)ReflectUtil.instantiate(taskFormHandlerClassName) : new DefaultTaskFormHandler();
        taskFormHandler.parseConfiguration(taskElement, this.deployment, processDefinition, this);
        TaskDefinition taskDefinition = new TaskDefinition(new DelegateTaskFormHandler(taskFormHandler, this.deployment));
        taskDefinition.setKey(taskDefinitionKey);
        processDefinition.getTaskDefinitions().put(taskDefinitionKey, taskDefinition);
        FormDefinition formDefinition = this.parseFormDefinition(taskElement);
        taskDefinition.setFormDefinition(formDefinition);
        String name = taskElement.attribute("name");
        if (name != null) {
            taskDefinition.setNameExpression(this.expressionManager.createExpression(name));
        }
        if ((descriptionStr = this.parseDocumentation(taskElement)) != null) {
            taskDefinition.setDescriptionExpression(this.expressionManager.createExpression(descriptionStr));
        }
        this.parseHumanPerformer(taskElement, taskDefinition);
        this.parsePotentialOwner(taskElement, taskDefinition);
        this.parseUserTaskCustomExtensions(taskElement, activity, taskDefinition);
        return taskDefinition;
    }

    protected FormDefinition parseFormDefinition(Element flowNodeElement) {
        FormDefinition formDefinition = new FormDefinition();
        String formKeyAttribute = flowNodeElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "formKey");
        String formRefAttribute = flowNodeElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "formRef");
        if (formKeyAttribute != null && formRefAttribute != null) {
            this.addError("Invalid element definition: only one of the attributes formKey and formRef is allowed.", flowNodeElement);
        }
        if (formKeyAttribute != null) {
            formDefinition.setFormKey(this.expressionManager.createExpression(formKeyAttribute));
        }
        if (formRefAttribute != null) {
            formDefinition.setCamundaFormDefinitionKey(this.expressionManager.createExpression(formRefAttribute));
            String formRefBindingAttribute = flowNodeElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "formRefBinding");
            if (formRefBindingAttribute == null || !DefaultTaskFormHandler.ALLOWED_FORM_REF_BINDINGS.contains(formRefBindingAttribute)) {
                this.addError("Invalid element definition: value for formRefBinding attribute has to be one of " + DefaultTaskFormHandler.ALLOWED_FORM_REF_BINDINGS + " but was " + formRefBindingAttribute, flowNodeElement);
            }
            if (formRefBindingAttribute != null) {
                formDefinition.setCamundaFormDefinitionBinding(formRefBindingAttribute);
            }
            if ("version".equals(formRefBindingAttribute)) {
                String formRefVersionAttribute = flowNodeElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "formRefVersion");
                Expression camundaFormDefinitionVersion = this.expressionManager.createExpression(formRefVersionAttribute);
                if (formRefVersionAttribute != null) {
                    formDefinition.setCamundaFormDefinitionVersion(camundaFormDefinitionVersion);
                }
            }
        }
        return formDefinition;
    }

    protected void parseHumanPerformer(Element taskElement, TaskDefinition taskDefinition) {
        Element humanPerformerElement;
        List<Element> humanPerformerElements = taskElement.elements(HUMAN_PERFORMER);
        if (humanPerformerElements.size() > 1) {
            this.addError("Invalid task definition: multiple humanPerformer sub elements defined for " + taskDefinition.getNameExpression(), taskElement);
        } else if (humanPerformerElements.size() == 1 && (humanPerformerElement = humanPerformerElements.get(0)) != null) {
            this.parseHumanPerformerResourceAssignment(humanPerformerElement, taskDefinition);
        }
    }

    protected void parsePotentialOwner(Element taskElement, TaskDefinition taskDefinition) {
        List<Element> potentialOwnerElements = taskElement.elements(POTENTIAL_OWNER);
        for (Element potentialOwnerElement : potentialOwnerElements) {
            this.parsePotentialOwnerResourceAssignment(potentialOwnerElement, taskDefinition);
        }
    }

    protected void parseHumanPerformerResourceAssignment(Element performerElement, TaskDefinition taskDefinition) {
        Element feElement;
        Element raeElement = performerElement.element(RESOURCE_ASSIGNMENT_EXPR);
        if (raeElement != null && (feElement = raeElement.element(FORMAL_EXPRESSION)) != null) {
            taskDefinition.setAssigneeExpression(this.expressionManager.createExpression(feElement.getText()));
        }
    }

    protected void parsePotentialOwnerResourceAssignment(Element performerElement, TaskDefinition taskDefinition) {
        Element feElement;
        Element raeElement = performerElement.element(RESOURCE_ASSIGNMENT_EXPR);
        if (raeElement != null && (feElement = raeElement.element(FORMAL_EXPRESSION)) != null) {
            List<String> assignmentExpressions = this.parseCommaSeparatedList(feElement.getText());
            for (String assignmentExpression : assignmentExpressions) {
                if ((assignmentExpression = assignmentExpression.trim()).startsWith(USER_PREFIX)) {
                    String userAssignementId = this.getAssignmentId(assignmentExpression, USER_PREFIX);
                    taskDefinition.addCandidateUserIdExpression(this.expressionManager.createExpression(userAssignementId));
                    continue;
                }
                if (assignmentExpression.startsWith(GROUP_PREFIX)) {
                    String groupAssignementId = this.getAssignmentId(assignmentExpression, GROUP_PREFIX);
                    taskDefinition.addCandidateGroupIdExpression(this.expressionManager.createExpression(groupAssignementId));
                    continue;
                }
                taskDefinition.addCandidateGroupIdExpression(this.expressionManager.createExpression(assignmentExpression));
            }
        }
    }

    protected String getAssignmentId(String expression, String prefix) {
        return expression.substring(prefix.length(), expression.length() - 1).trim();
    }

    protected void parseUserTaskCustomExtensions(Element taskElement, ActivityImpl activity, TaskDefinition taskDefinition) {
        String priorityExpression;
        String string;
        String candidateGroupsString;
        String candidateUsersString;
        String assignee = taskElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, ASSIGNEE_EXTENSION);
        if (assignee != null) {
            if (taskDefinition.getAssigneeExpression() == null) {
                taskDefinition.setAssigneeExpression(this.expressionManager.createExpression(assignee));
            } else {
                this.addError("Invalid usage: duplicate assignee declaration for task " + taskDefinition.getNameExpression(), taskElement);
            }
        }
        if ((candidateUsersString = taskElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, CANDIDATE_USERS_EXTENSION)) != null) {
            List<String> candidateUsers = this.parseCommaSeparatedList(candidateUsersString);
            for (String string2 : candidateUsers) {
                taskDefinition.addCandidateUserIdExpression(this.expressionManager.createExpression(string2.trim()));
            }
        }
        if ((candidateGroupsString = taskElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, CANDIDATE_GROUPS_EXTENSION)) != null) {
            List<String> candidateGroups = this.parseCommaSeparatedList(candidateGroupsString);
            for (String candidateGroup : candidateGroups) {
                taskDefinition.addCandidateGroupIdExpression(this.expressionManager.createExpression(candidateGroup.trim()));
            }
        }
        this.parseTaskListeners(taskElement, activity, taskDefinition);
        String dueDateExpression = taskElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, DUE_DATE_EXTENSION);
        if (dueDateExpression != null) {
            taskDefinition.setDueDateExpression(this.expressionManager.createExpression(dueDateExpression));
        }
        if ((string = taskElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, FOLLOW_UP_DATE_EXTENSION)) != null) {
            taskDefinition.setFollowUpDateExpression(this.expressionManager.createExpression(string));
        }
        if ((priorityExpression = taskElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, PRIORITY_EXTENSION)) != null) {
            taskDefinition.setPriorityExpression(this.expressionManager.createExpression(priorityExpression));
        }
    }

    protected List<String> parseCommaSeparatedList(String s) {
        ArrayList<String> result = new ArrayList<String>();
        if (s != null && !"".equals(s)) {
            StringCharacterIterator iterator = new StringCharacterIterator(s);
            char c = iterator.first();
            StringBuilder strb = new StringBuilder();
            boolean insideExpression = false;
            while (c != '\uffff') {
                if (c == '{' || c == '$') {
                    insideExpression = true;
                } else if (c == '}') {
                    insideExpression = false;
                } else if (c == ',' && !insideExpression) {
                    result.add(strb.toString().trim());
                    strb.delete(0, strb.length());
                }
                if (c != ',' || insideExpression) {
                    strb.append(c);
                }
                c = iterator.next();
            }
            if (strb.length() > 0) {
                result.add(strb.toString().trim());
            }
        }
        return result;
    }

    protected void parseTaskListeners(Element userTaskElement, ActivityImpl activity, TaskDefinition taskDefinition) {
        Element extentionsElement = userTaskElement.element("extensionElements");
        if (extentionsElement != null) {
            List<Element> taskListenerElements = extentionsElement.elementsNS(CAMUNDA_BPMN_EXTENSIONS_NS, "taskListener");
            for (Element taskListenerElement : taskListenerElements) {
                String eventName = taskListenerElement.attribute("event");
                if (eventName != null) {
                    TaskListener taskListener;
                    if ("create".equals(eventName) || "assignment".equals(eventName) || "complete".equals(eventName) || "update".equals(eventName) || "delete".equals(eventName)) {
                        taskListener = this.parseTaskListener(taskListenerElement, activity.getId());
                        taskDefinition.addTaskListener(eventName, taskListener);
                        continue;
                    }
                    if ("timeout".equals(eventName)) {
                        taskListener = this.parseTimeoutTaskListener(taskListenerElement, activity, taskDefinition);
                        taskDefinition.addTimeoutTaskListener(taskListenerElement.attribute("id"), taskListener);
                        continue;
                    }
                    this.addError("Attribute 'event' must be one of {create|assignment|complete|update|delete|timeout}", userTaskElement);
                    continue;
                }
                this.addError("Attribute 'event' is mandatory on taskListener", userTaskElement);
            }
        }
    }

    protected TaskListener parseTaskListener(Element taskListenerElement, String taskElementId) {
        TaskListener taskListener = null;
        String className = taskListenerElement.attribute(PROPERTYNAME_CLASS);
        String expression = taskListenerElement.attribute(PROPERTYNAME_EXPRESSION);
        String delegateExpression = taskListenerElement.attribute(PROPERTYNAME_DELEGATE_EXPRESSION);
        Element scriptElement = taskListenerElement.elementNS(CAMUNDA_BPMN_EXTENSIONS_NS, "script");
        if (className != null) {
            taskListener = new ClassDelegateTaskListener(className, this.parseFieldDeclarations(taskListenerElement));
        } else if (expression != null) {
            taskListener = new ExpressionTaskListener(this.expressionManager.createExpression(expression));
        } else if (delegateExpression != null) {
            taskListener = new DelegateExpressionTaskListener(this.expressionManager.createExpression(delegateExpression), this.parseFieldDeclarations(taskListenerElement));
        } else if (scriptElement != null) {
            try {
                ExecutableScript executableScript = BpmnParseUtil.parseCamundaScript(scriptElement);
                if (executableScript != null) {
                    taskListener = new ScriptTaskListener(executableScript);
                }
            }
            catch (BpmnParseException e) {
                this.addError(e, taskElementId);
            }
        } else {
            this.addError("Element 'class', 'expression', 'delegateExpression' or 'script' is mandatory on taskListener", taskListenerElement, taskElementId);
        }
        return taskListener;
    }

    protected TaskListener parseTimeoutTaskListener(Element taskListenerElement, ActivityImpl timerActivity, TaskDefinition taskDefinition) {
        Element timerEventDefinition;
        String listenerId = taskListenerElement.attribute("id");
        String timerActivityId = timerActivity.getId();
        if (listenerId == null) {
            this.addError("Element 'id' is mandatory on taskListener of type 'timeout'", taskListenerElement, timerActivityId);
        }
        if ((timerEventDefinition = taskListenerElement.element(TIMER_EVENT_DEFINITION)) == null) {
            this.addError("Element 'timerEventDefinition' is mandatory on taskListener of type 'timeout'", taskListenerElement, timerActivityId);
        }
        timerActivity.setScope(true);
        timerActivity.setEventScope(timerActivity);
        TimerDeclarationImpl timerDeclaration = this.parseTimer(timerEventDefinition, timerActivity, "timer-task-listener");
        timerDeclaration.setRawJobHandlerConfiguration(timerActivityId + "$taskListener~" + listenerId);
        this.addTimerListenerDeclaration(listenerId, timerActivity, timerDeclaration);
        return this.parseTaskListener(taskListenerElement, timerActivityId);
    }

    public void parseEndEvents(Element parentElement, ScopeImpl scope) {
        for (Element endEventElement : parentElement.elements("endEvent")) {
            ActivityImpl activity = this.createActivityOnScope(endEventElement, scope);
            Element errorEventDefinition = endEventElement.element(ERROR_EVENT_DEFINITION);
            Element cancelEventDefinition = endEventElement.element(CANCEL_EVENT_DEFINITION);
            Element terminateEventDefinition = endEventElement.element("terminateEventDefinition");
            Element messageEventDefinitionElement = endEventElement.element(MESSAGE_EVENT_DEFINITION);
            Element signalEventDefinition = endEventElement.element(SIGNAL_EVENT_DEFINITION);
            Element compensateEventDefinitionElement = endEventElement.element(COMPENSATE_EVENT_DEFINITION);
            Element escalationEventDefinition = endEventElement.element(ESCALATION_EVENT_DEFINITION);
            boolean isServiceTaskLike = this.isServiceTaskLike(messageEventDefinitionElement);
            String activityId = activity.getId();
            if (errorEventDefinition != null) {
                String errorRef = errorEventDefinition.attribute("errorRef");
                if (errorRef == null || "".equals(errorRef)) {
                    this.addError("'errorRef' attribute is mandatory on error end event", errorEventDefinition, activityId);
                } else {
                    Error error = this.errors.get(errorRef);
                    if (error != null && (error.getErrorCode() == null || "".equals(error.getErrorCode()))) {
                        this.addError("'errorCode' is mandatory on errors referenced by throwing error event definitions, but the error '" + error.getId() + "' does not define one.", errorEventDefinition, activityId);
                    }
                    activity.getProperties().set(BpmnProperties.TYPE, "errorEndEvent");
                    if (error != null) {
                        activity.setActivityBehavior(new ErrorEndEventActivityBehavior(error.getErrorCode(), error.getErrorMessageExpression()));
                    } else {
                        activity.setActivityBehavior(new ErrorEndEventActivityBehavior(errorRef, null));
                    }
                }
            } else if (cancelEventDefinition != null) {
                if (scope.getProperty(BpmnProperties.TYPE.getName()) == null || !scope.getProperty(BpmnProperties.TYPE.getName()).equals("transaction")) {
                    this.addError("end event with cancelEventDefinition only supported inside transaction subprocess", cancelEventDefinition, activityId);
                } else {
                    activity.getProperties().set(BpmnProperties.TYPE, "cancelEndEvent");
                    activity.setActivityBehavior(new CancelEndEventActivityBehavior());
                    activity.setActivityStartBehavior(ActivityStartBehavior.INTERRUPT_FLOW_SCOPE);
                    activity.setProperty(PROPERTYNAME_THROWS_COMPENSATION, true);
                    activity.setScope(true);
                }
            } else if (terminateEventDefinition != null) {
                activity.getProperties().set(BpmnProperties.TYPE, "terminateEndEvent");
                activity.setActivityBehavior(new TerminateEndEventActivityBehavior());
                activity.setActivityStartBehavior(ActivityStartBehavior.INTERRUPT_FLOW_SCOPE);
            } else if (messageEventDefinitionElement != null) {
                if (isServiceTaskLike) {
                    this.parseServiceTaskLike(activity, "messageEndEvent", messageEventDefinitionElement, endEventElement, scope);
                    activity.getProperties().set(BpmnProperties.TYPE, "messageEndEvent");
                } else {
                    activity.setActivityBehavior(new IntermediateThrowNoneEventActivityBehavior());
                }
            } else if (signalEventDefinition != null) {
                activity.getProperties().set(BpmnProperties.TYPE, "signalEndEvent");
                EventSubscriptionDeclaration signalDefinition = this.parseSignalEventDefinition(signalEventDefinition, true, activityId);
                activity.setActivityBehavior(new ThrowSignalEventActivityBehavior(signalDefinition));
            } else if (compensateEventDefinitionElement != null) {
                activity.getProperties().set(BpmnProperties.TYPE, "compensationEndEvent");
                CompensateEventDefinition compensateEventDefinition = this.parseThrowCompensateEventDefinition(compensateEventDefinitionElement, scope, endEventElement.attribute("id"));
                activity.setActivityBehavior(new CompensationEventActivityBehavior(compensateEventDefinition));
                activity.setProperty(PROPERTYNAME_THROWS_COMPENSATION, true);
                activity.setScope(true);
            } else if (escalationEventDefinition != null) {
                activity.getProperties().set(BpmnProperties.TYPE, "escalationEndEvent");
                Escalation escalation = this.findEscalationForEscalationEventDefinition(escalationEventDefinition, activityId);
                if (escalation != null && escalation.getEscalationCode() == null) {
                    this.addError("escalation end event must have an 'escalationCode'", escalationEventDefinition, activityId);
                }
                activity.setActivityBehavior(new ThrowEscalationEventActivityBehavior(escalation));
            } else {
                activity.getProperties().set(BpmnProperties.TYPE, "noneEndEvent");
                activity.setActivityBehavior(new NoneEndEventActivityBehavior());
            }
            if (activity != null) {
                this.parseActivityInputOutput(endEventElement, activity);
            }
            this.parseAsynchronousContinuationForActivity(endEventElement, activity);
            this.parseExecutionListenersOnScope(endEventElement, activity);
            for (BpmnParseListener parseListener : this.parseListeners) {
                parseListener.parseEndEvent(endEventElement, scope, activity);
            }
            if (!isServiceTaskLike) continue;
            this.validateServiceTaskLike(activity, "messageEndEvent", messageEventDefinitionElement);
        }
    }

    public void parseBoundaryEvents(Element parentElement, ScopeImpl flowScope) {
        for (Element boundaryEventElement : parentElement.elements("boundaryEvent")) {
            String attachedToRef = boundaryEventElement.attribute("attachedToRef");
            if (attachedToRef == null || attachedToRef.equals("")) {
                this.addError("AttachedToRef is required when using a timerEventDefinition", boundaryEventElement);
            }
            String id = boundaryEventElement.attribute("id");
            LOG.parsingElement("boundary event", id);
            Element timerEventDefinition = boundaryEventElement.element(TIMER_EVENT_DEFINITION);
            Element errorEventDefinition = boundaryEventElement.element(ERROR_EVENT_DEFINITION);
            Element signalEventDefinition = boundaryEventElement.element(SIGNAL_EVENT_DEFINITION);
            Element cancelEventDefinition = boundaryEventElement.element(CANCEL_EVENT_DEFINITION);
            Element compensateEventDefinition = boundaryEventElement.element(COMPENSATE_EVENT_DEFINITION);
            Element messageEventDefinition = boundaryEventElement.element(MESSAGE_EVENT_DEFINITION);
            Element escalationEventDefinition = boundaryEventElement.element(ESCALATION_EVENT_DEFINITION);
            Element conditionalEventDefinition = boundaryEventElement.element(CONDITIONAL_EVENT_DEFINITION);
            ActivityImpl boundaryEventActivity = this.createActivityOnScope(boundaryEventElement, flowScope);
            this.parseAsynchronousContinuation(boundaryEventElement, boundaryEventActivity);
            ActivityImpl attachedActivity = flowScope.findActivityAtLevelOfSubprocess(attachedToRef);
            if (attachedActivity == null) {
                this.addError("Invalid reference in boundary event. Make sure that the referenced activity is defined in the same scope as the boundary event", boundaryEventElement);
            }
            if (compensateEventDefinition == null) {
                ActivityImpl multiInstanceScope = this.getMultiInstanceScope(attachedActivity);
                if (multiInstanceScope != null) {
                    boundaryEventActivity.setEventScope(multiInstanceScope);
                } else {
                    attachedActivity.setScope(true);
                    boundaryEventActivity.setEventScope(attachedActivity);
                }
            } else {
                boundaryEventActivity.setEventScope(attachedActivity);
            }
            String cancelActivityAttr = boundaryEventElement.attribute("cancelActivity", TRUE);
            boolean isCancelActivity = Boolean.parseBoolean(cancelActivityAttr);
            if (isCancelActivity) {
                boundaryEventActivity.setActivityStartBehavior(ActivityStartBehavior.CANCEL_EVENT_SCOPE);
            } else {
                boundaryEventActivity.setActivityStartBehavior(ActivityStartBehavior.CONCURRENT_IN_FLOW_SCOPE);
            }
            ActivityBehavior behavior = new BoundaryEventActivityBehavior();
            if (timerEventDefinition != null) {
                this.parseBoundaryTimerEventDefinition(timerEventDefinition, isCancelActivity, boundaryEventActivity);
            } else if (errorEventDefinition != null) {
                this.parseBoundaryErrorEventDefinition(errorEventDefinition, boundaryEventActivity);
            } else if (signalEventDefinition != null) {
                this.parseBoundarySignalEventDefinition(signalEventDefinition, isCancelActivity, boundaryEventActivity);
            } else if (cancelEventDefinition != null) {
                behavior = this.parseBoundaryCancelEventDefinition(cancelEventDefinition, boundaryEventActivity);
            } else if (compensateEventDefinition != null) {
                this.parseBoundaryCompensateEventDefinition(compensateEventDefinition, boundaryEventActivity);
            } else if (messageEventDefinition != null) {
                this.parseBoundaryMessageEventDefinition(messageEventDefinition, isCancelActivity, boundaryEventActivity);
            } else if (escalationEventDefinition != null) {
                if (attachedActivity.isSubProcessScope() || attachedActivity.getActivityBehavior() instanceof CallActivityBehavior || attachedActivity.getActivityBehavior() instanceof UserTaskActivityBehavior) {
                    this.parseBoundaryEscalationEventDefinition(escalationEventDefinition, isCancelActivity, boundaryEventActivity);
                } else {
                    this.addError("An escalation boundary event should only be attached to a subprocess, a call activity or an user task", boundaryEventElement);
                }
            } else if (conditionalEventDefinition != null) {
                behavior = this.parseBoundaryConditionalEventDefinition(conditionalEventDefinition, isCancelActivity, boundaryEventActivity);
            } else {
                this.addError("Unsupported boundary event type", boundaryEventElement);
            }
            this.ensureNoIoMappingDefined(boundaryEventElement);
            boundaryEventActivity.setActivityBehavior(behavior);
            this.parseExecutionListenersOnScope(boundaryEventElement, boundaryEventActivity);
            for (BpmnParseListener parseListener : this.parseListeners) {
                parseListener.parseBoundaryEvent(boundaryEventElement, flowScope, boundaryEventActivity);
            }
        }
    }

    public List<CamundaErrorEventDefinition> parseCamundaErrorEventDefinitions(ActivityImpl activity, Element scopeElement) {
        ArrayList<CamundaErrorEventDefinition> errorEventDefinitions = new ArrayList<CamundaErrorEventDefinition>();
        Element extensionElements = scopeElement.element("extensionElements");
        if (extensionElements != null) {
            List<Element> errorEventDefinitionElements = extensionElements.elements(ERROR_EVENT_DEFINITION);
            for (Element errorEventDefinitionElement : errorEventDefinitionElements) {
                String errorRef = errorEventDefinitionElement.attribute("errorRef");
                Error error = null;
                if (errorRef == null) continue;
                String camundaExpression = errorEventDefinitionElement.attribute(PROPERTYNAME_EXPRESSION);
                error = this.errors.get(errorRef);
                CamundaErrorEventDefinition definition = new CamundaErrorEventDefinition(activity.getId(), this.expressionManager.createExpression(camundaExpression));
                definition.setErrorCode(error == null ? errorRef : error.getErrorCode());
                this.setErrorCodeVariableOnErrorEventDefinition(errorEventDefinitionElement, definition);
                this.setErrorMessageVariableOnErrorEventDefinition(errorEventDefinitionElement, definition);
                errorEventDefinitions.add(definition);
            }
        }
        return errorEventDefinitions;
    }

    protected ActivityImpl getMultiInstanceScope(ActivityImpl activity) {
        if (activity.isMultiInstance()) {
            return activity.getParentFlowScopeActivity();
        }
        return null;
    }

    public void parseBoundaryTimerEventDefinition(Element timerEventDefinition, boolean interrupting, ActivityImpl boundaryActivity) {
        boundaryActivity.getProperties().set(BpmnProperties.TYPE, "boundaryTimer");
        TimerDeclarationImpl timerDeclaration = this.parseTimer(timerEventDefinition, boundaryActivity, "timer-transition");
        if (interrupting) {
            timerDeclaration.setInterruptingTimer(true);
            Element timeCycleElement = timerEventDefinition.element("timeCycle");
            if (timeCycleElement != null) {
                this.addTimeCycleWarning(timeCycleElement, "cancelling boundary", boundaryActivity.getId());
            }
        }
        this.addTimerDeclaration(boundaryActivity.getEventScope(), timerDeclaration);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseBoundaryTimerEventDefinition(timerEventDefinition, interrupting, boundaryActivity);
        }
    }

    public void parseBoundarySignalEventDefinition(Element element, boolean interrupting, ActivityImpl signalActivity) {
        signalActivity.getProperties().set(BpmnProperties.TYPE, "boundarySignal");
        EventSubscriptionDeclaration signalDefinition = this.parseSignalEventDefinition(element, false, signalActivity.getId());
        if (signalActivity.getId() == null) {
            this.addError("boundary event has no id", element);
        }
        signalDefinition.setActivityId(signalActivity.getId());
        this.addEventSubscriptionDeclaration(signalDefinition, signalActivity.getEventScope(), element);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseBoundarySignalEventDefinition(element, interrupting, signalActivity);
        }
    }

    public void parseBoundaryMessageEventDefinition(Element element, boolean interrupting, ActivityImpl messageActivity) {
        messageActivity.getProperties().set(BpmnProperties.TYPE, "boundaryMessage");
        EventSubscriptionDeclaration messageEventDefinition = this.parseMessageEventDefinition(element, messageActivity.getId());
        if (messageActivity.getId() == null) {
            this.addError("boundary event has no id", element);
        }
        messageEventDefinition.setActivityId(messageActivity.getId());
        this.addEventSubscriptionDeclaration(messageEventDefinition, messageActivity.getEventScope(), element);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseBoundaryMessageEventDefinition(element, interrupting, messageActivity);
        }
    }

    protected void parseTimerStartEventDefinition(Element timerEventDefinition, ActivityImpl timerActivity, ProcessDefinitionEntity processDefinition) {
        timerActivity.getProperties().set(BpmnProperties.TYPE, "startTimerEvent");
        TimerDeclarationImpl timerDeclaration = this.parseTimer(timerEventDefinition, timerActivity, "timer-start-event");
        timerDeclaration.setRawJobHandlerConfiguration(processDefinition.getKey());
        ArrayList<TimerDeclarationImpl> timerDeclarations = (ArrayList<TimerDeclarationImpl>)processDefinition.getProperty(PROPERTYNAME_START_TIMER);
        if (timerDeclarations == null) {
            timerDeclarations = new ArrayList<TimerDeclarationImpl>();
            processDefinition.setProperty(PROPERTYNAME_START_TIMER, timerDeclarations);
        }
        timerDeclarations.add(timerDeclaration);
    }

    protected void parseTimerStartEventDefinitionForEventSubprocess(Element timerEventDefinition, ActivityImpl timerActivity, boolean interrupting) {
        Element timeCycleElement;
        timerActivity.getProperties().set(BpmnProperties.TYPE, "startTimerEvent");
        TimerDeclarationImpl timerDeclaration = this.parseTimer(timerEventDefinition, timerActivity, "timer-start-event-subprocess");
        timerDeclaration.setActivity(timerActivity);
        timerDeclaration.setEventScopeActivityId(timerActivity.getEventScope().getId());
        timerDeclaration.setRawJobHandlerConfiguration(timerActivity.getFlowScope().getId());
        timerDeclaration.setInterruptingTimer(interrupting);
        if (interrupting && (timeCycleElement = timerEventDefinition.element("timeCycle")) != null) {
            this.addTimeCycleWarning(timeCycleElement, "interrupting start", timerActivity.getId());
        }
        this.addTimerDeclaration(timerActivity.getEventScope(), timerDeclaration);
    }

    protected void parseEventDefinitionForSubprocess(EventSubscriptionDeclaration subscriptionDeclaration, ActivityImpl activity, Element element) {
        subscriptionDeclaration.setActivityId(activity.getId());
        subscriptionDeclaration.setEventScopeActivityId(activity.getEventScope().getId());
        subscriptionDeclaration.setStartEvent(false);
        this.addEventSubscriptionDeclaration(subscriptionDeclaration, activity.getEventScope(), element);
    }

    protected void parseIntermediateSignalEventDefinition(Element element, ActivityImpl signalActivity) {
        signalActivity.getProperties().set(BpmnProperties.TYPE, "intermediateSignalCatch");
        this.parseSignalCatchEventDefinition(element, signalActivity, false);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseIntermediateSignalCatchEventDefinition(element, signalActivity);
        }
    }

    protected void parseSignalCatchEventDefinition(Element element, ActivityImpl signalActivity, boolean isStartEvent) {
        EventSubscriptionDeclaration signalDefinition = this.parseSignalEventDefinition(element, false, signalActivity.getId());
        signalDefinition.setActivityId(signalActivity.getId());
        signalDefinition.setStartEvent(isStartEvent);
        this.addEventSubscriptionDeclaration(signalDefinition, signalActivity.getEventScope(), element);
        EventSubscriptionJobDeclaration catchingAsyncDeclaration = new EventSubscriptionJobDeclaration(signalDefinition);
        catchingAsyncDeclaration.setJobPriorityProvider((ParameterValueProvider)signalActivity.getProperty(PROPERTYNAME_JOB_PRIORITY));
        catchingAsyncDeclaration.setActivity(signalActivity);
        signalDefinition.setJobDeclaration(catchingAsyncDeclaration);
        this.addEventSubscriptionJobDeclaration(catchingAsyncDeclaration, signalActivity, element);
    }

    protected EventSubscriptionDeclaration parseSignalEventDefinition(Element signalEventDefinitionElement, boolean isThrowing, String signalElementId) {
        EventSubscriptionDeclaration signalEventDefinition;
        String signalRef = signalEventDefinitionElement.attribute("signalRef");
        if (signalRef == null) {
            this.addError("signalEventDefinition does not have required property 'signalRef'", signalEventDefinitionElement, signalElementId);
            return null;
        }
        SignalDefinition signalDefinition = this.signals.get(this.resolveName(signalRef));
        if (signalDefinition == null) {
            this.addError("Could not find signal with id '" + signalRef + "'", signalEventDefinitionElement, signalElementId);
        }
        if (isThrowing) {
            CallableElement payload = new CallableElement();
            this.parseInputParameter(signalEventDefinitionElement, payload);
            signalEventDefinition = new EventSubscriptionDeclaration(signalDefinition.getExpression(), EventType.SIGNAL, payload);
        } else {
            signalEventDefinition = new EventSubscriptionDeclaration(signalDefinition.getExpression(), EventType.SIGNAL);
        }
        boolean throwingAsync = TRUE.equals(signalEventDefinitionElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "async", "false"));
        signalEventDefinition.setAsync(throwingAsync);
        return signalEventDefinition;
    }

    protected void parseIntermediateTimerEventDefinition(Element timerEventDefinition, ActivityImpl timerActivity) {
        timerActivity.getProperties().set(BpmnProperties.TYPE, "intermediateTimer");
        TimerDeclarationImpl timerDeclaration = this.parseTimer(timerEventDefinition, timerActivity, "timer-intermediate-transition");
        Element timeCycleElement = timerEventDefinition.element("timeCycle");
        if (timeCycleElement != null) {
            ProcessDefinition processDefinition = (ProcessDefinition)((Object)timerActivity.getProcessDefinition());
            LOG.intermediateCatchTimerEventWithTimeCycleNotRecommended(processDefinition.getKey(), timerActivity.getId());
        }
        this.addTimerDeclaration(timerActivity.getEventScope(), timerDeclaration);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseIntermediateTimerEventDefinition(timerEventDefinition, timerActivity);
        }
    }

    protected TimerDeclarationImpl parseTimer(Element timerEventDefinition, ActivityImpl timerActivity, String jobHandlerType) {
        TimerDeclarationType type = TimerDeclarationType.DATE;
        Expression expression = this.parseExpression(timerEventDefinition, "timeDate");
        if (expression == null) {
            type = TimerDeclarationType.CYCLE;
            expression = this.parseExpression(timerEventDefinition, "timeCycle");
        }
        if (expression == null) {
            type = TimerDeclarationType.DURATION;
            expression = this.parseExpression(timerEventDefinition, "timeDuration");
        }
        if (expression == null) {
            this.addError("Timer needs configuration (either timeDate, timeCycle or timeDuration is needed).", timerEventDefinition, timerActivity.getId());
        }
        TimerDeclarationImpl timerDeclaration = new TimerDeclarationImpl(expression, type, jobHandlerType);
        timerDeclaration.setRawJobHandlerConfiguration(timerActivity.getId());
        timerDeclaration.setExclusive(TRUE.equals(timerEventDefinition.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "exclusive", String.valueOf(true))));
        if (timerActivity.getId() == null) {
            this.addError("Attribute \"id\" is required!", timerEventDefinition);
        }
        timerDeclaration.setActivity(timerActivity);
        timerDeclaration.setJobConfiguration(type.toString() + ": " + expression.getExpressionText());
        this.addJobDeclarationToProcessDefinition(timerDeclaration, (ProcessDefinition)((Object)timerActivity.getProcessDefinition()));
        timerDeclaration.setJobPriorityProvider((ParameterValueProvider)timerActivity.getProperty(PROPERTYNAME_JOB_PRIORITY));
        return timerDeclaration;
    }

    protected Expression parseExpression(Element parent, String name) {
        Element value = parent.element(name);
        if (value != null) {
            String expressionText = value.getText().trim();
            return this.expressionManager.createExpression(expressionText);
        }
        return null;
    }

    public void parseBoundaryErrorEventDefinition(Element errorEventDefinition, ActivityImpl boundaryEventActivity) {
        boundaryEventActivity.getProperties().set(BpmnProperties.TYPE, "boundaryError");
        String errorRef = errorEventDefinition.attribute("errorRef");
        Error error = null;
        ErrorEventDefinition definition = new ErrorEventDefinition(boundaryEventActivity.getId());
        if (errorRef != null) {
            error = this.errors.get(errorRef);
            definition.setErrorCode(error == null ? errorRef : error.getErrorCode());
        }
        this.setErrorCodeVariableOnErrorEventDefinition(errorEventDefinition, definition);
        this.setErrorMessageVariableOnErrorEventDefinition(errorEventDefinition, definition);
        this.addErrorEventDefinition(definition, boundaryEventActivity.getEventScope());
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseBoundaryErrorEventDefinition(errorEventDefinition, true, (ActivityImpl)boundaryEventActivity.getEventScope(), boundaryEventActivity);
        }
    }

    protected void addErrorEventDefinition(ErrorEventDefinition errorEventDefinition, ScopeImpl catchingScope) {
        catchingScope.getProperties().addListItem(BpmnProperties.ERROR_EVENT_DEFINITIONS, errorEventDefinition);
        List<ErrorEventDefinition> errorEventDefinitions = catchingScope.getProperties().get(BpmnProperties.ERROR_EVENT_DEFINITIONS);
        Collections.sort(errorEventDefinitions, ErrorEventDefinition.comparator);
    }

    protected void parseBoundaryEscalationEventDefinition(Element escalationEventDefinitionElement, boolean cancelActivity, ActivityImpl boundaryEventActivity) {
        boundaryEventActivity.getProperties().set(BpmnProperties.TYPE, "boundaryEscalation");
        EscalationEventDefinition escalationEventDefinition = this.createEscalationEventDefinitionForEscalationHandler(escalationEventDefinitionElement, boundaryEventActivity, cancelActivity, boundaryEventActivity.getId());
        this.addEscalationEventDefinition(boundaryEventActivity.getEventScope(), escalationEventDefinition, escalationEventDefinitionElement, boundaryEventActivity.getId());
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseBoundaryEscalationEventDefinition(escalationEventDefinitionElement, cancelActivity, boundaryEventActivity);
        }
    }

    protected Escalation findEscalationForEscalationEventDefinition(Element escalationEventDefinition, String escalationElementId) {
        String escalationRef = escalationEventDefinition.attribute("escalationRef");
        if (escalationRef == null) {
            this.addError("escalationEventDefinition does not have required attribute 'escalationRef'", escalationEventDefinition, escalationElementId);
        } else if (!this.escalations.containsKey(escalationRef)) {
            this.addError("could not find escalation with id '" + escalationRef + "'", escalationEventDefinition, escalationElementId);
        } else {
            return this.escalations.get(escalationRef);
        }
        return null;
    }

    protected EscalationEventDefinition createEscalationEventDefinitionForEscalationHandler(Element escalationEventDefinitionElement, ActivityImpl escalationHandler, boolean cancelActivity, String parentElementId) {
        String escalationCodeVariable;
        EscalationEventDefinition escalationEventDefinition = new EscalationEventDefinition(escalationHandler, cancelActivity);
        String escalationRef = escalationEventDefinitionElement.attribute("escalationRef");
        if (escalationRef != null) {
            if (!this.escalations.containsKey(escalationRef)) {
                this.addError("could not find escalation with id '" + escalationRef + "'", escalationEventDefinitionElement, parentElementId);
            } else {
                Escalation escalation = this.escalations.get(escalationRef);
                escalationEventDefinition.setEscalationCode(escalation.getEscalationCode());
            }
        }
        if ((escalationCodeVariable = escalationEventDefinitionElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "escalationCodeVariable")) != null) {
            escalationEventDefinition.setEscalationCodeVariable(escalationCodeVariable);
        }
        return escalationEventDefinition;
    }

    protected void addEscalationEventDefinition(ScopeImpl catchingScope, EscalationEventDefinition escalationEventDefinition, Element element, String escalationElementId) {
        for (EscalationEventDefinition existingEscalationEventDefinition : catchingScope.getProperties().get(BpmnProperties.ESCALATION_EVENT_DEFINITIONS)) {
            if (existingEscalationEventDefinition.getEscalationHandler().isSubProcessScope() && escalationEventDefinition.getEscalationHandler().isSubProcessScope()) {
                if (existingEscalationEventDefinition.getEscalationCode() == null && escalationEventDefinition.getEscalationCode() == null) {
                    this.addError("The same scope can not contains more than one escalation event subprocess without escalation code. An escalation event subprocess without escalation code catch all escalation events.", element, escalationElementId);
                    continue;
                }
                if (existingEscalationEventDefinition.getEscalationCode() == null || escalationEventDefinition.getEscalationCode() == null) {
                    this.addError("The same scope can not contains an escalation event subprocess without escalation code and another one with escalation code. The escalation event subprocess without escalation code catch all escalation events.", element, escalationElementId);
                    continue;
                }
                if (!existingEscalationEventDefinition.getEscalationCode().equals(escalationEventDefinition.getEscalationCode())) continue;
                this.addError("multiple escalation event subprocesses with the same escalationCode '" + escalationEventDefinition.getEscalationCode() + "' are not supported on same scope", element, escalationElementId);
                continue;
            }
            if (existingEscalationEventDefinition.getEscalationHandler().isSubProcessScope() || escalationEventDefinition.getEscalationHandler().isSubProcessScope()) continue;
            if (existingEscalationEventDefinition.getEscalationCode() == null && escalationEventDefinition.getEscalationCode() == null) {
                this.addError("The same scope can not contains more than one escalation boundary event without escalation code. An escalation boundary event without escalation code catch all escalation events.", element, escalationElementId);
                continue;
            }
            if (existingEscalationEventDefinition.getEscalationCode() == null || escalationEventDefinition.getEscalationCode() == null) {
                this.addError("The same scope can not contains an escalation boundary event without escalation code and another one with escalation code. The escalation boundary event without escalation code catch all escalation events.", element, escalationElementId);
                continue;
            }
            if (!existingEscalationEventDefinition.getEscalationCode().equals(escalationEventDefinition.getEscalationCode())) continue;
            this.addError("multiple escalation boundary events with the same escalationCode '" + escalationEventDefinition.getEscalationCode() + "' are not supported on same scope", element, escalationElementId);
        }
        catchingScope.getProperties().addListItem(BpmnProperties.ESCALATION_EVENT_DEFINITIONS, escalationEventDefinition);
    }

    protected void addTimerDeclaration(ScopeImpl scope, TimerDeclarationImpl timerDeclaration) {
        scope.getProperties().putMapEntry(BpmnProperties.TIMER_DECLARATIONS, timerDeclaration.getActivityId(), timerDeclaration);
    }

    protected void addTimerListenerDeclaration(String listenerId, ScopeImpl scope, TimerDeclarationImpl timerDeclaration) {
        if (scope.getProperties().get(BpmnProperties.TIMEOUT_LISTENER_DECLARATIONS) != null && scope.getProperties().get(BpmnProperties.TIMEOUT_LISTENER_DECLARATIONS).get(timerDeclaration.getActivityId()) != null) {
            scope.getProperties().get(BpmnProperties.TIMEOUT_LISTENER_DECLARATIONS).get(timerDeclaration.getActivityId()).put(listenerId, timerDeclaration);
        } else {
            HashMap<String, TimerDeclarationImpl> activityDeclarations = new HashMap<String, TimerDeclarationImpl>();
            activityDeclarations.put(listenerId, timerDeclaration);
            scope.getProperties().putMapEntry(BpmnProperties.TIMEOUT_LISTENER_DECLARATIONS, timerDeclaration.getActivityId(), activityDeclarations);
        }
    }

    protected void addVariableDeclaration(ScopeImpl scope, VariableDeclaration variableDeclaration) {
        ArrayList<VariableDeclaration> variableDeclarations = (ArrayList<VariableDeclaration>)scope.getProperty(PROPERTYNAME_VARIABLE_DECLARATIONS);
        if (variableDeclarations == null) {
            variableDeclarations = new ArrayList<VariableDeclaration>();
            scope.setProperty(PROPERTYNAME_VARIABLE_DECLARATIONS, variableDeclarations);
        }
        variableDeclarations.add(variableDeclaration);
    }

    public BoundaryConditionalEventActivityBehavior parseBoundaryConditionalEventDefinition(Element element, boolean interrupting, ActivityImpl conditionalActivity) {
        conditionalActivity.getProperties().set(BpmnProperties.TYPE, "boundaryConditional");
        ConditionalEventDefinition conditionalEventDefinition = this.parseConditionalEventDefinition(element, conditionalActivity);
        conditionalEventDefinition.setInterrupting(interrupting);
        this.addEventSubscriptionDeclaration(conditionalEventDefinition, conditionalActivity.getEventScope(), element);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseBoundaryConditionalEventDefinition(element, interrupting, conditionalActivity);
        }
        return new BoundaryConditionalEventActivityBehavior(conditionalEventDefinition);
    }

    public ConditionalEventDefinition parseIntermediateConditionalEventDefinition(Element element, ActivityImpl conditionalActivity) {
        conditionalActivity.getProperties().set(BpmnProperties.TYPE, "intermediateConditional");
        ConditionalEventDefinition conditionalEventDefinition = this.parseConditionalEventDefinition(element, conditionalActivity);
        this.addEventSubscriptionDeclaration(conditionalEventDefinition, conditionalActivity.getEventScope(), element);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseIntermediateConditionalEventDefinition(element, conditionalActivity);
        }
        return conditionalEventDefinition;
    }

    public ConditionalEventDefinition parseConditionalStartEventForEventSubprocess(Element element, ActivityImpl conditionalActivity, boolean interrupting) {
        conditionalActivity.getProperties().set(BpmnProperties.TYPE, "conditionalStartEvent");
        ConditionalEventDefinition conditionalEventDefinition = this.parseConditionalEventDefinition(element, conditionalActivity);
        conditionalEventDefinition.setInterrupting(interrupting);
        this.addEventSubscriptionDeclaration(conditionalEventDefinition, conditionalActivity.getEventScope(), element);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseConditionalStartEventForEventSubprocess(element, conditionalActivity, interrupting);
        }
        return conditionalEventDefinition;
    }

    protected ConditionalEventDefinition parseConditionalEventDefinition(Element element, ActivityImpl conditionalActivity) {
        ConditionalEventDefinition conditionalEventDefinition = null;
        Element conditionExprElement = element.element("condition");
        String conditionalActivityId = conditionalActivity.getId();
        if (conditionExprElement != null) {
            Condition condition = this.parseConditionExpression(conditionExprElement, conditionalActivityId);
            conditionalEventDefinition = new ConditionalEventDefinition(condition, conditionalActivity);
            String expression = conditionExprElement.getText().trim();
            conditionalEventDefinition.setConditionAsString(expression);
            conditionalActivity.getProcessDefinition().getProperties().set(BpmnProperties.HAS_CONDITIONAL_EVENTS, true);
            String variableName = element.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "variableName");
            conditionalEventDefinition.setVariableName(variableName);
            String variableEvents = element.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "variableEvents");
            List<String> variableEventsList = this.parseCommaSeparatedList(variableEvents);
            conditionalEventDefinition.setVariableEvents(new HashSet<String>(variableEventsList));
            for (String variableEvent : variableEventsList) {
                if (VARIABLE_EVENTS.contains(variableEvent)) continue;
                this.addWarning("Variable event: " + variableEvent + " is not valid. Possible variable change events are: " + Arrays.toString(VARIABLE_EVENTS.toArray()), element, conditionalActivityId);
            }
        } else {
            this.addError("Conditional event must contain an expression for evaluation.", element, conditionalActivityId);
        }
        return conditionalEventDefinition;
    }

    public ActivityImpl parseSubProcess(Element subProcessElement, ScopeImpl scope) {
        ActivityImpl subProcessActivity = this.createActivityOnScope(subProcessElement, scope);
        subProcessActivity.setSubProcessScope(true);
        this.parseAsynchronousContinuationForActivity(subProcessElement, subProcessActivity);
        Boolean isTriggeredByEvent = this.parseBooleanAttribute(subProcessElement.attribute("triggeredByEvent"), false);
        subProcessActivity.getProperties().set(BpmnProperties.TRIGGERED_BY_EVENT, isTriggeredByEvent);
        subProcessActivity.setProperty(PROPERTYNAME_CONSUMES_COMPENSATION, isTriggeredByEvent == false);
        subProcessActivity.setScope(true);
        if (isTriggeredByEvent.booleanValue()) {
            subProcessActivity.setActivityBehavior(new EventSubProcessActivityBehavior());
            subProcessActivity.setEventScope(scope);
        } else {
            subProcessActivity.setActivityBehavior(new SubProcessActivityBehavior());
        }
        this.parseScope(subProcessElement, subProcessActivity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseSubProcess(subProcessElement, scope, subProcessActivity);
        }
        return subProcessActivity;
    }

    protected ActivityImpl parseTransaction(Element transactionElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(transactionElement, scope);
        this.parseAsynchronousContinuationForActivity(transactionElement, activity);
        activity.setScope(true);
        activity.setSubProcessScope(true);
        activity.setActivityBehavior(new SubProcessActivityBehavior());
        activity.getProperties().set(BpmnProperties.TRIGGERED_BY_EVENT, false);
        this.parseScope(transactionElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseTransaction(transactionElement, scope, activity);
        }
        return activity;
    }

    public ActivityImpl parseCallActivity(Element callActivityElement, ScopeImpl scope, boolean isMultiInstance) {
        ActivityImpl activity = this.createActivityOnScope(callActivityElement, scope);
        this.parseAsynchronousContinuationForActivity(callActivityElement, activity);
        String calledElement = callActivityElement.attribute("calledElement");
        String caseRef = callActivityElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "caseRef");
        String className = callActivityElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, PROPERTYNAME_VARIABLE_MAPPING_CLASS);
        String delegateExpression = callActivityElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, PROPERTYNAME_VARIABLE_MAPPING_DELEGATE_EXPRESSION);
        if (calledElement == null && caseRef == null) {
            this.addError("Missing attribute 'calledElement' or 'caseRef'", callActivityElement);
        } else if (calledElement != null && caseRef != null) {
            this.addError("The attributes 'calledElement' or 'caseRef' cannot be used together: Use either 'calledElement' or 'caseRef'", callActivityElement);
        }
        String bindingAttributeName = "calledElementBinding";
        String versionAttributeName = "calledElementVersion";
        String versionTagAttributeName = "calledElementVersionTag";
        String tenantIdAttributeName = "calledElementTenantId";
        String deploymentId = this.deployment.getId();
        CallableElement callableElement = new CallableElement();
        callableElement.setDeploymentId(deploymentId);
        CallableElementActivityBehavior behavior = null;
        if (calledElement != null) {
            if (className != null) {
                behavior = new CallActivityBehavior(className);
            } else if (delegateExpression != null) {
                Expression exp = this.expressionManager.createExpression(delegateExpression);
                behavior = new CallActivityBehavior(exp);
            } else {
                behavior = new CallActivityBehavior();
            }
            definitionKeyProvider = this.createParameterValueProvider(calledElement, this.expressionManager);
            callableElement.setDefinitionKeyValueProvider(definitionKeyProvider);
        } else {
            behavior = new CaseCallActivityBehavior();
            definitionKeyProvider = this.createParameterValueProvider(caseRef, this.expressionManager);
            callableElement.setDefinitionKeyValueProvider(definitionKeyProvider);
            bindingAttributeName = "caseBinding";
            versionAttributeName = "caseVersion";
            tenantIdAttributeName = "caseTenantId";
        }
        behavior.setCallableElement(callableElement);
        this.parseBinding(callActivityElement, activity, callableElement, bindingAttributeName);
        this.parseVersion(callActivityElement, activity, callableElement, bindingAttributeName, versionAttributeName);
        this.parseVersionTag(callActivityElement, activity, callableElement, bindingAttributeName, versionTagAttributeName);
        this.parseTenantId(callActivityElement, activity, callableElement, tenantIdAttributeName);
        this.parseInputParameter(callActivityElement, callableElement);
        this.parseOutputParameter(callActivityElement, activity, callableElement);
        if (!isMultiInstance) {
            activity.setScope(true);
        }
        activity.setActivityBehavior(behavior);
        this.parseExecutionListenersOnScope(callActivityElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseCallActivity(callActivityElement, scope, activity);
        }
        return activity;
    }

    protected void parseBinding(Element callActivityElement, ActivityImpl activity, BaseCallableElement callableElement, String bindingAttributeName) {
        String binding = callActivityElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, bindingAttributeName);
        if (BaseCallableElement.CallableElementBinding.DEPLOYMENT.getValue().equals(binding)) {
            callableElement.setBinding(BaseCallableElement.CallableElementBinding.DEPLOYMENT);
        } else if (BaseCallableElement.CallableElementBinding.LATEST.getValue().equals(binding)) {
            callableElement.setBinding(BaseCallableElement.CallableElementBinding.LATEST);
        } else if (BaseCallableElement.CallableElementBinding.VERSION.getValue().equals(binding)) {
            callableElement.setBinding(BaseCallableElement.CallableElementBinding.VERSION);
        } else if (BaseCallableElement.CallableElementBinding.VERSION_TAG.getValue().equals(binding)) {
            callableElement.setBinding(BaseCallableElement.CallableElementBinding.VERSION_TAG);
        }
    }

    protected void parseTenantId(Element callingActivityElement, ActivityImpl activity, BaseCallableElement callableElement, String attrName) {
        ParameterValueProvider tenantIdValueProvider = null;
        String tenantId = callingActivityElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, attrName);
        if (tenantId != null && tenantId.length() > 0) {
            tenantIdValueProvider = this.createParameterValueProvider(tenantId, this.expressionManager);
        }
        callableElement.setTenantIdProvider(tenantIdValueProvider);
    }

    protected void parseVersion(Element callingActivityElement, ActivityImpl activity, BaseCallableElement callableElement, String bindingAttributeName, String versionAttributeName) {
        String version = null;
        BaseCallableElement.CallableElementBinding binding = callableElement.getBinding();
        version = callingActivityElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, versionAttributeName);
        if (binding != null && binding.equals((Object)BaseCallableElement.CallableElementBinding.VERSION) && version == null) {
            this.addError("Missing attribute '" + versionAttributeName + "' when '" + bindingAttributeName + "' has value '" + BaseCallableElement.CallableElementBinding.VERSION.getValue() + "'", callingActivityElement);
        }
        ParameterValueProvider versionProvider = this.createParameterValueProvider(version, this.expressionManager);
        callableElement.setVersionValueProvider(versionProvider);
    }

    protected void parseVersionTag(Element callingActivityElement, ActivityImpl activity, BaseCallableElement callableElement, String bindingAttributeName, String versionTagAttributeName) {
        String versionTag = null;
        BaseCallableElement.CallableElementBinding binding = callableElement.getBinding();
        versionTag = callingActivityElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, versionTagAttributeName);
        if (binding != null && binding.equals((Object)BaseCallableElement.CallableElementBinding.VERSION_TAG) && versionTag == null) {
            this.addError("Missing attribute '" + versionTagAttributeName + "' when '" + bindingAttributeName + "' has value '" + BaseCallableElement.CallableElementBinding.VERSION_TAG.getValue() + "'", callingActivityElement);
        }
        ParameterValueProvider versionTagProvider = this.createParameterValueProvider(versionTag, this.expressionManager);
        callableElement.setVersionTagValueProvider(versionTagProvider);
    }

    protected void parseInputParameter(Element elementWithParameters, CallableElement callableElement) {
        Element extensionsElement = elementWithParameters.element("extensionElements");
        if (extensionsElement != null) {
            for (Element inElement : extensionsElement.elementsNS(CAMUNDA_BPMN_EXTENSIONS_NS, "in")) {
                String businessKey = inElement.attribute("businessKey");
                if (businessKey != null && !businessKey.isEmpty()) {
                    ParameterValueProvider businessKeyValueProvider = this.createParameterValueProvider(businessKey, this.expressionManager);
                    callableElement.setBusinessKeyValueProvider(businessKeyValueProvider);
                    continue;
                }
                CallableElementParameter parameter = this.parseCallableElementProvider(inElement, elementWithParameters.attribute("id"));
                if (this.attributeValueEquals(inElement, "local", TRUE)) {
                    parameter.setReadLocal(true);
                }
                callableElement.addInput(parameter);
            }
        }
    }

    protected void parseOutputParameter(Element callActivityElement, ActivityImpl activity, CallableElement callableElement) {
        Element extensionsElement = callActivityElement.element("extensionElements");
        if (extensionsElement != null) {
            for (Element outElement : extensionsElement.elementsNS(CAMUNDA_BPMN_EXTENSIONS_NS, "out")) {
                CallableElementParameter parameter = this.parseCallableElementProvider(outElement, callActivityElement.attribute("id"));
                if (this.attributeValueEquals(outElement, "local", TRUE)) {
                    callableElement.addOutputLocal(parameter);
                    continue;
                }
                callableElement.addOutput(parameter);
            }
        }
    }

    protected boolean attributeValueEquals(Element element, String attribute, String comparisonValue) {
        String value = element.attribute(attribute);
        return comparisonValue.equals(value);
    }

    protected CallableElementParameter parseCallableElementProvider(Element parameterElement, String ancestorElementId) {
        CallableElementParameter parameter = new CallableElementParameter();
        String variables = parameterElement.attribute("variables");
        if (ALL.equals(variables)) {
            parameter.setAllVariables(true);
        } else {
            boolean strictValidation = !Context.getProcessEngineConfiguration().getDisableStrictCallActivityValidation();
            ParameterValueProvider sourceValueProvider = new NullValueProvider();
            String source = parameterElement.attribute("source");
            if (source != null) {
                if (!source.isEmpty()) {
                    sourceValueProvider = new ConstantValueProvider(source);
                } else if (strictValidation) {
                    this.addError("Empty attribute 'source' when passing variables", parameterElement, ancestorElementId);
                } else {
                    source = null;
                }
            }
            if (source == null && (source = parameterElement.attribute("sourceExpression")) != null) {
                if (!source.isEmpty()) {
                    Expression expression = this.expressionManager.createExpression(source);
                    sourceValueProvider = new ElValueProvider(expression);
                } else if (strictValidation) {
                    this.addError("Empty attribute 'sourceExpression' when passing variables", parameterElement, ancestorElementId);
                }
            }
            if (strictValidation && source == null) {
                this.addError("Missing parameter 'source' or 'sourceExpression' when passing variables", parameterElement, ancestorElementId);
            }
            parameter.setSourceValueProvider(sourceValueProvider);
            String target = parameterElement.attribute("target");
            if ((strictValidation || source != null && !source.isEmpty()) && target == null) {
                this.addError("Missing attribute 'target' when attribute 'source' or 'sourceExpression' is set", parameterElement, ancestorElementId);
            } else if (strictValidation && target != null && target.isEmpty()) {
                this.addError("Empty attribute 'target' when attribute 'source' or 'sourceExpression' is set", parameterElement, ancestorElementId);
            }
            parameter.setTarget(target);
        }
        return parameter;
    }

    public void parseProperties(Element element, ActivityImpl activity) {
        List<Element> propertyElements = element.elements("property");
        for (Element propertyElement : propertyElements) {
            this.parseProperty(propertyElement, activity);
        }
    }

    public void parseProperty(Element propertyElement, ActivityImpl activity) {
        String id = propertyElement.attribute("id");
        String name = propertyElement.attribute("name");
        if (name == null) {
            if (id == null) {
                this.addError("Invalid property usage on line " + propertyElement.getLine() + ": no id or name specified.", propertyElement, activity.getId());
            } else {
                name = id;
            }
        }
        String type = null;
        this.parsePropertyCustomExtensions(activity, propertyElement, name, type);
    }

    public void parsePropertyCustomExtensions(ActivityImpl activity, Element propertyElement, String propertyName, String propertyType) {
        String linkExpr;
        String link;
        String destExpr;
        String dst;
        String srcExpr;
        if (propertyType == null) {
            String type = propertyElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, TYPE);
            propertyType = type != null ? type : "string";
        }
        VariableDeclaration variableDeclaration = new VariableDeclaration(propertyName, propertyType);
        this.addVariableDeclaration(activity, variableDeclaration);
        activity.setScope(true);
        String src = propertyElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "src");
        if (src != null) {
            variableDeclaration.setSourceVariableName(src);
        }
        if ((srcExpr = propertyElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "srcExpr")) != null) {
            Expression sourceExpression = this.expressionManager.createExpression(srcExpr);
            variableDeclaration.setSourceExpression(sourceExpression);
        }
        if ((dst = propertyElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "dst")) != null) {
            variableDeclaration.setDestinationVariableName(dst);
        }
        if ((destExpr = propertyElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "dstExpr")) != null) {
            Expression destinationExpression = this.expressionManager.createExpression(destExpr);
            variableDeclaration.setDestinationExpression(destinationExpression);
        }
        if ((link = propertyElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "link")) != null) {
            variableDeclaration.setLink(link);
        }
        if ((linkExpr = propertyElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "linkExpr")) != null) {
            Expression linkExpression = this.expressionManager.createExpression(linkExpr);
            variableDeclaration.setLinkExpression(linkExpression);
        }
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseProperty(propertyElement, variableDeclaration, activity);
        }
    }

    public void parseSequenceFlow(Element processElement, ScopeImpl scope, Map<String, Element> compensationHandlers) {
        for (Element sequenceFlowElement : processElement.elements("sequenceFlow")) {
            String linkName;
            String id = sequenceFlowElement.attribute("id");
            String sourceRef = sequenceFlowElement.attribute("sourceRef");
            String destinationRef = sequenceFlowElement.attribute("targetRef");
            if (this.eventLinkSources.containsKey(destinationRef) && (destinationRef = this.eventLinkTargets.get(linkName = this.eventLinkSources.get(destinationRef))) == null) {
                this.addError("sequence flow points to link event source with name '" + linkName + "' but no event target with that name exists. Most probably your link events are not configured correctly.", sequenceFlowElement);
                return;
            }
            ActivityImpl sourceActivity = scope.findActivityAtLevelOfSubprocess(sourceRef);
            ActivityImpl destinationActivity = scope.findActivityAtLevelOfSubprocess(destinationRef);
            if (sourceActivity == null && compensationHandlers.containsKey(sourceRef) || sourceActivity != null && sourceActivity.isCompensationHandler()) {
                this.addError("Invalid outgoing sequence flow of compensation activity '" + sourceRef + "'. A compensation activity should not have an incoming or outgoing sequence flow.", sequenceFlowElement, sourceRef, id);
                continue;
            }
            if (destinationActivity == null && compensationHandlers.containsKey(destinationRef) || destinationActivity != null && destinationActivity.isCompensationHandler()) {
                this.addError("Invalid incoming sequence flow of compensation activity '" + destinationRef + "'. A compensation activity should not have an incoming or outgoing sequence flow.", sequenceFlowElement, destinationRef, id);
                continue;
            }
            if (sourceActivity == null) {
                this.addError("Invalid source '" + sourceRef + "' of sequence flow '" + id + "'", sequenceFlowElement);
                continue;
            }
            if (destinationActivity == null) {
                this.addError("Invalid destination '" + destinationRef + "' of sequence flow '" + id + "'", sequenceFlowElement);
                continue;
            }
            if (sourceActivity.getActivityBehavior() instanceof EventBasedGatewayActivityBehavior) continue;
            if (destinationActivity.getActivityBehavior() instanceof IntermediateCatchEventActivityBehavior && destinationActivity.getEventScope() != null && destinationActivity.getEventScope().getActivityBehavior() instanceof EventBasedGatewayActivityBehavior) {
                this.addError("Invalid incoming sequenceflow for intermediateCatchEvent with id '" + destinationActivity.getId() + "' connected to an event-based gateway.", sequenceFlowElement);
                continue;
            }
            if (sourceActivity.getActivityBehavior() instanceof SubProcessActivityBehavior && sourceActivity.isTriggeredByEvent()) {
                this.addError("Invalid outgoing sequence flow of event subprocess", sequenceFlowElement);
                continue;
            }
            if (destinationActivity.getActivityBehavior() instanceof SubProcessActivityBehavior && destinationActivity.isTriggeredByEvent()) {
                this.addError("Invalid incoming sequence flow of event subprocess", sequenceFlowElement);
                continue;
            }
            if (this.getMultiInstanceScope(sourceActivity) != null) {
                sourceActivity = this.getMultiInstanceScope(sourceActivity);
            }
            if (this.getMultiInstanceScope(destinationActivity) != null) {
                destinationActivity = this.getMultiInstanceScope(destinationActivity);
            }
            TransitionImpl transition = sourceActivity.createOutgoingTransition(id);
            this.sequenceFlows.put(id, transition);
            transition.setProperty("name", sequenceFlowElement.attribute("name"));
            transition.setProperty(PROPERTYNAME_DOCUMENTATION, this.parseDocumentation(sequenceFlowElement));
            transition.setDestination(destinationActivity);
            this.parseSequenceFlowConditionExpression(sequenceFlowElement, transition);
            this.parseExecutionListenersOnTransition(sequenceFlowElement, transition);
            for (BpmnParseListener parseListener : this.parseListeners) {
                parseListener.parseSequenceFlow(sequenceFlowElement, scope, transition);
            }
        }
    }

    public void parseSequenceFlowConditionExpression(Element seqFlowElement, TransitionImpl seqFlow) {
        Element conditionExprElement = seqFlowElement.element(CONDITION_EXPRESSION);
        if (conditionExprElement != null) {
            Condition condition = this.parseConditionExpression(conditionExprElement, seqFlow.getId());
            seqFlow.setProperty(PROPERTYNAME_CONDITION_TEXT, conditionExprElement.getText().trim());
            seqFlow.setProperty("condition", condition);
        }
    }

    protected Condition parseConditionExpression(Element conditionExprElement, String ancestorElementId) {
        String expression = conditionExprElement.getText().trim();
        String type = conditionExprElement.attributeNS(XSI_NS, TYPE);
        String language = conditionExprElement.attribute(PROPERTYNAME_LANGUAGE);
        String resource = conditionExprElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, PROPERTYNAME_RESOURCE);
        if (type != null) {
            Object value;
            Object object = value = type.contains(":") ? this.resolveName(type) : "http://www.omg.org/spec/BPMN/20100524/MODEL:" + type;
            if (!((String)value).equals(ATTRIBUTEVALUE_T_FORMAL_EXPRESSION)) {
                this.addError("Invalid type, only tFormalExpression is currently supported", conditionExprElement, ancestorElementId);
            }
        }
        Condition condition = null;
        if (language == null) {
            condition = new UelExpressionCondition(this.expressionManager.createExpression(expression));
        } else {
            try {
                ExecutableScript script = ScriptUtil.getScript(language, expression, resource, this.expressionManager);
                condition = new ScriptCondition(script);
            }
            catch (ProcessEngineException e) {
                this.addError("Unable to process condition expression:" + e.getMessage(), conditionExprElement, ancestorElementId);
            }
        }
        return condition;
    }

    public void parseExecutionListenersOnScope(Element scopeElement, ScopeImpl scope) {
        Element extentionsElement = scopeElement.element("extensionElements");
        String scopeElementId = scopeElement.attribute("id");
        if (extentionsElement != null) {
            List<Element> listenerElements = extentionsElement.elementsNS(CAMUNDA_BPMN_EXTENSIONS_NS, "executionListener");
            for (Element listenerElement : listenerElements) {
                ExecutionListener listener;
                String eventName = listenerElement.attribute("event");
                if (!this.isValidEventNameForScope(eventName, listenerElement, scopeElementId) || (listener = this.parseExecutionListener(listenerElement, scopeElementId)) == null) continue;
                scope.addExecutionListener(eventName, listener);
            }
        }
    }

    protected boolean isValidEventNameForScope(String eventName, Element listenerElement, String ancestorElementId) {
        if (eventName != null && eventName.trim().length() > 0) {
            if ("start".equals(eventName) || "end".equals(eventName)) {
                return true;
            }
            this.addError("Attribute 'event' must be one of {start|end}", listenerElement, ancestorElementId);
        } else {
            this.addError("Attribute 'event' is mandatory on listener", listenerElement, ancestorElementId);
        }
        return false;
    }

    public void parseExecutionListenersOnTransition(Element activitiElement, TransitionImpl activity) {
        Element extensionElements = activitiElement.element("extensionElements");
        if (extensionElements != null) {
            List<Element> listenerElements = extensionElements.elementsNS(CAMUNDA_BPMN_EXTENSIONS_NS, "executionListener");
            for (Element listenerElement : listenerElements) {
                ExecutionListener listener = this.parseExecutionListener(listenerElement, activity.getId());
                if (listener == null) continue;
                activity.addExecutionListener(listener);
            }
        }
    }

    public ExecutionListener parseExecutionListener(Element executionListenerElement, String ancestorElementId) {
        ExecutionListener executionListener = null;
        String className = executionListenerElement.attribute(PROPERTYNAME_CLASS);
        String expression = executionListenerElement.attribute(PROPERTYNAME_EXPRESSION);
        String delegateExpression = executionListenerElement.attribute(PROPERTYNAME_DELEGATE_EXPRESSION);
        Element scriptElement = executionListenerElement.elementNS(CAMUNDA_BPMN_EXTENSIONS_NS, "script");
        if (className != null) {
            if (className.isEmpty()) {
                this.addError("Attribute 'class' cannot be empty", executionListenerElement, ancestorElementId);
            } else {
                executionListener = new ClassDelegateExecutionListener(className, this.parseFieldDeclarations(executionListenerElement));
            }
        } else if (expression != null) {
            executionListener = new ExpressionExecutionListener(this.expressionManager.createExpression(expression));
        } else if (delegateExpression != null) {
            if (delegateExpression.isEmpty()) {
                this.addError("Attribute 'delegateExpression' cannot be empty", executionListenerElement, ancestorElementId);
            } else {
                executionListener = new DelegateExpressionExecutionListener(this.expressionManager.createExpression(delegateExpression), this.parseFieldDeclarations(executionListenerElement));
            }
        } else if (scriptElement != null) {
            try {
                ExecutableScript executableScript = BpmnParseUtil.parseCamundaScript(scriptElement);
                if (executableScript != null) {
                    executionListener = new ScriptExecutionListener(executableScript);
                }
            }
            catch (BpmnParseException e) {
                this.addError(e, ancestorElementId);
            }
        } else {
            this.addError("Element 'class', 'expression', 'delegateExpression' or 'script' is mandatory on executionListener", executionListenerElement, ancestorElementId);
        }
        return executionListener;
    }

    public void parseDiagramInterchangeElements() {
        List<Element> diagrams = this.rootElement.elementsNS(BPMN_DI_NS, "BPMNDiagram");
        if (!diagrams.isEmpty()) {
            for (Element diagramElement : diagrams) {
                this.parseBPMNDiagram(diagramElement);
            }
        }
    }

    public void parseBPMNDiagram(Element bpmndiagramElement) {
        Element bpmnPlane = bpmndiagramElement.elementNS(BPMN_DI_NS, "BPMNPlane");
        if (bpmnPlane != null) {
            this.parseBPMNPlane(bpmnPlane);
        }
    }

    public void parseBPMNPlane(Element bpmnPlaneElement) {
        String bpmnElement = bpmnPlaneElement.attribute("bpmnElement");
        if (bpmnElement != null && !"".equals(bpmnElement)) {
            if (this.getProcessDefinition(bpmnElement) != null) {
                this.getProcessDefinition(bpmnElement).setGraphicalNotationDefined(true);
            }
            List<Element> shapes = bpmnPlaneElement.elementsNS(BPMN_DI_NS, "BPMNShape");
            for (Element shape : shapes) {
                this.parseBPMNShape(shape);
            }
            List<Element> edges = bpmnPlaneElement.elementsNS(BPMN_DI_NS, "BPMNEdge");
            for (Element edge : edges) {
                this.parseBPMNEdge(edge);
            }
        } else {
            this.addError("'bpmnElement' attribute is required on BPMNPlane ", bpmnPlaneElement);
        }
    }

    public void parseBPMNShape(Element bpmnShapeElement) {
        String bpmnElement = bpmnShapeElement.attribute("bpmnElement");
        if (bpmnElement != null && !"".equals(bpmnElement)) {
            if (this.participantProcesses.get(bpmnElement) != null) {
                ProcessDefinitionEntity procDef = this.getProcessDefinition(this.participantProcesses.get(bpmnElement));
                procDef.setGraphicalNotationDefined(true);
                this.parseDIBounds(bpmnShapeElement, procDef.getParticipantProcess());
                return;
            }
            for (ProcessDefinitionEntity processDefinition : this.getProcessDefinitions()) {
                ActivityImpl activity = processDefinition.findActivity(bpmnElement);
                if (activity != null) {
                    this.parseDIBounds(bpmnShapeElement, activity);
                    String isExpanded = bpmnShapeElement.attribute(PROPERTYNAME_ISEXPANDED);
                    if (isExpanded == null) continue;
                    activity.setProperty(PROPERTYNAME_ISEXPANDED, this.parseBooleanAttribute(isExpanded));
                    continue;
                }
                Lane lane = processDefinition.getLaneForId(bpmnElement);
                if (lane != null) {
                    this.parseDIBounds(bpmnShapeElement, lane);
                    continue;
                }
                if (this.elementIds.contains(bpmnElement)) continue;
                this.addError("Invalid reference in 'bpmnElement' attribute, activity " + bpmnElement + " not found", bpmnShapeElement);
            }
        } else {
            this.addError("'bpmnElement' attribute is required on BPMNShape", bpmnShapeElement);
        }
    }

    protected void parseDIBounds(Element bpmnShapeElement, HasDIBounds target) {
        Element bounds = bpmnShapeElement.elementNS(BPMN_DC_NS, "Bounds");
        if (bounds != null) {
            target.setX(this.parseDoubleAttribute(bpmnShapeElement, "x", bounds.attribute("x"), true).intValue());
            target.setY(this.parseDoubleAttribute(bpmnShapeElement, "y", bounds.attribute("y"), true).intValue());
            target.setWidth(this.parseDoubleAttribute(bpmnShapeElement, "width", bounds.attribute("width"), true).intValue());
            target.setHeight(this.parseDoubleAttribute(bpmnShapeElement, "height", bounds.attribute("height"), true).intValue());
        } else {
            this.addError("'Bounds' element is required", bpmnShapeElement);
        }
    }

    public void parseBPMNEdge(Element bpmnEdgeElement) {
        String sequenceFlowId = bpmnEdgeElement.attribute("bpmnElement");
        if (sequenceFlowId != null && !"".equals(sequenceFlowId)) {
            if (this.sequenceFlows != null && this.sequenceFlows.containsKey(sequenceFlowId)) {
                TransitionImpl sequenceFlow = this.sequenceFlows.get(sequenceFlowId);
                List<Element> waypointElements = bpmnEdgeElement.elementsNS(OMG_DI_NS, "waypoint");
                if (waypointElements.size() >= 2) {
                    ArrayList<Integer> waypoints = new ArrayList<Integer>();
                    for (Element waypointElement : waypointElements) {
                        waypoints.add(this.parseDoubleAttribute(waypointElement, "x", waypointElement.attribute("x"), true).intValue());
                        waypoints.add(this.parseDoubleAttribute(waypointElement, "y", waypointElement.attribute("y"), true).intValue());
                    }
                    sequenceFlow.setWaypoints(waypoints);
                } else {
                    this.addError("Minimum 2 waypoint elements must be definted for a 'BPMNEdge'", bpmnEdgeElement);
                }
            } else if (!this.elementIds.contains(sequenceFlowId)) {
                this.addError("Invalid reference in 'bpmnElement' attribute, sequenceFlow " + sequenceFlowId + "not found", bpmnEdgeElement);
            }
        } else {
            this.addError("'bpmnElement' attribute is required on BPMNEdge", bpmnEdgeElement);
        }
    }

    public List<ProcessDefinitionEntity> getProcessDefinitions() {
        return this.processDefinitions;
    }

    public ProcessDefinitionEntity getProcessDefinition(String processDefinitionKey) {
        for (ProcessDefinitionEntity processDefinition : this.processDefinitions) {
            if (!processDefinition.getKey().equals(processDefinitionKey)) continue;
            return processDefinition;
        }
        return null;
    }

    @Override
    public BpmnParse name(String name) {
        super.name(name);
        return this;
    }

    @Override
    public BpmnParse sourceInputStream(InputStream inputStream) {
        super.sourceInputStream(inputStream);
        return this;
    }

    @Override
    public BpmnParse sourceResource(String resource, ClassLoader classLoader) {
        super.sourceResource(resource, classLoader);
        return this;
    }

    @Override
    public BpmnParse sourceResource(String resource) {
        super.sourceResource(resource);
        return this;
    }

    @Override
    public BpmnParse sourceString(String string) {
        super.sourceString(string);
        return this;
    }

    @Override
    public BpmnParse sourceUrl(String url) {
        super.sourceUrl(url);
        return this;
    }

    @Override
    public BpmnParse sourceUrl(URL url) {
        super.sourceUrl(url);
        return this;
    }

    public Boolean parseBooleanAttribute(String booleanText, boolean defaultValue) {
        if (booleanText == null) {
            return defaultValue;
        }
        return this.parseBooleanAttribute(booleanText);
    }

    public Boolean parseBooleanAttribute(String booleanText) {
        if (TRUE.equals(booleanText) || "enabled".equals(booleanText) || "on".equals(booleanText) || "active".equals(booleanText) || "yes".equals(booleanText)) {
            return Boolean.TRUE;
        }
        if ("false".equals(booleanText) || "disabled".equals(booleanText) || "off".equals(booleanText) || "inactive".equals(booleanText) || "no".equals(booleanText)) {
            return Boolean.FALSE;
        }
        return null;
    }

    public Double parseDoubleAttribute(Element element, String attributeName, String doubleText, boolean required) {
        if (required && (doubleText == null || "".equals(doubleText))) {
            this.addError(attributeName + " is required", element);
        } else {
            try {
                return Double.parseDouble(doubleText);
            }
            catch (NumberFormatException e) {
                this.addError("Cannot parse " + attributeName + ": " + e.getMessage(), element);
            }
        }
        return -1.0;
    }

    protected boolean isStartable(Element element) {
        return TRUE.equalsIgnoreCase(element.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "isStartableInTasklist", TRUE));
    }

    protected boolean isExclusive(Element element) {
        return TRUE.equals(element.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "exclusive", String.valueOf(true)));
    }

    protected boolean isAsyncBefore(Element element) {
        return TRUE.equals(element.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "async")) || TRUE.equals(element.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "asyncBefore"));
    }

    protected boolean isAsyncAfter(Element element) {
        return TRUE.equals(element.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "asyncAfter"));
    }

    protected boolean isServiceTaskLike(Element element) {
        return element != null && (element.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, PROPERTYNAME_CLASS) != null || element.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, PROPERTYNAME_EXPRESSION) != null || element.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, PROPERTYNAME_DELEGATE_EXPRESSION) != null || element.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, TYPE) != null || this.hasConnector(element));
    }

    protected boolean hasConnector(Element element) {
        Element extensionElements = element.element("extensionElements");
        return extensionElements != null && extensionElements.element("connector") != null;
    }

    public Map<String, List<JobDeclaration<?, ?>>> getJobDeclarations() {
        return this.jobDeclarations;
    }

    public List<JobDeclaration<?, ?>> getJobDeclarationsByKey(String processDefinitionKey) {
        return this.jobDeclarations.get(processDefinitionKey);
    }

    protected void parseActivityInputOutput(Element activityElement, ActivityImpl activity) {
        Element extensionElements = activityElement.element("extensionElements");
        if (extensionElements != null) {
            IoMapping inputOutput = null;
            try {
                inputOutput = BpmnParseUtil.parseInputOutput(extensionElements);
            }
            catch (BpmnParseException e) {
                this.addError(e, activity.getId());
            }
            if (inputOutput != null) {
                if (this.checkActivityInputOutputSupported(activityElement, activity, inputOutput)) {
                    activity.setIoMapping(inputOutput);
                    if (this.getMultiInstanceScope(activity) == null) {
                        activity.setScope(true);
                    }
                }
                for (BpmnParseListener parseListener : this.parseListeners) {
                    parseListener.parseIoMapping(extensionElements, activity, inputOutput);
                }
            }
        }
    }

    protected boolean checkActivityInputOutputSupported(Element activityElement, ActivityImpl activity, IoMapping inputOutput) {
        String tagName = activityElement.getTagName();
        if (!(tagName.toLowerCase().contains("task") || tagName.contains("Event") || tagName.equals("transaction") || tagName.equals("subProcess") || tagName.equals("callActivity"))) {
            this.addError("camunda:inputOutput mapping unsupported for element type '" + tagName + "'.", activityElement);
            return false;
        }
        if (tagName.equals("subProcess") && TRUE.equals(activityElement.attribute("triggeredByEvent"))) {
            this.addError("camunda:inputOutput mapping unsupported for element type '" + tagName + "' with attribute 'triggeredByEvent = true'.", activityElement);
            return false;
        }
        if (!inputOutput.getOutputParameters().isEmpty()) {
            return this.checkActivityOutputParameterSupported(activityElement, activity);
        }
        return true;
    }

    protected boolean checkActivityOutputParameterSupported(Element activityElement, ActivityImpl activity) {
        String tagName = activityElement.getTagName();
        if (tagName.equals("endEvent")) {
            this.addError("camunda:outputParameter not allowed for element type '" + tagName + "'.", activityElement);
            return true;
        }
        if (this.getMultiInstanceScope(activity) != null) {
            this.addError("camunda:outputParameter not allowed for multi-instance constructs", activityElement);
            return false;
        }
        return true;
    }

    protected void ensureNoIoMappingDefined(Element element) {
        Element inputOutput = BpmnParseUtil.findCamundaExtensionElement(element, "inputOutput");
        if (inputOutput != null) {
            this.addError("camunda:inputOutput mapping unsupported for element type '" + element.getTagName() + "'.", element);
        }
    }

    protected ParameterValueProvider createParameterValueProvider(Object value, ExpressionManager expressionManager) {
        if (value == null) {
            return new NullValueProvider();
        }
        if (value instanceof String) {
            Expression expression = expressionManager.createExpression((String)value);
            return new ElValueProvider(expression);
        }
        return new ConstantValueProvider(value);
    }

    protected void addTimeCycleWarning(Element timeCycleElement, String type, String timerElementId) {
        String warning = "It is not recommended to use a " + type + " timer event with a time cycle.";
        this.addWarning(warning, timeCycleElement, timerElementId);
    }

    protected void ensureNoExpressionInMessageStartEvent(Element element, EventSubscriptionDeclaration messageStartEventSubscriptionDeclaration, String parentElementId) {
        boolean eventNameContainsExpression = false;
        if (messageStartEventSubscriptionDeclaration.hasEventName()) {
            boolean bl = eventNameContainsExpression = !messageStartEventSubscriptionDeclaration.isEventNameLiteralText();
        }
        if (eventNameContainsExpression) {
            String messageStartName = messageStartEventSubscriptionDeclaration.getUnresolvedEventName();
            this.addError("Invalid message name '" + messageStartName + "' for element '" + element.getTagName() + "': expressions in the message start event name are not allowed!", element, parentElementId);
        }
    }
}

