/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.cfg.jta;

import org.eximeebpms.bpm.engine.impl.ProcessEngineLogger;
import org.eximeebpms.bpm.engine.impl.cfg.TransactionContext;
import org.eximeebpms.bpm.engine.impl.cfg.TransactionListener;
import org.eximeebpms.bpm.engine.impl.cfg.TransactionLogger;
import org.eximeebpms.bpm.engine.impl.cfg.TransactionState;
import org.eximeebpms.bpm.engine.impl.context.Context;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;

public abstract class AbstractTransactionContext
implements TransactionContext {
    public static final TransactionLogger LOG = ProcessEngineLogger.TX_LOGGER;

    @Override
    public void commit() {
    }

    @Override
    public void rollback() {
        try {
            this.doRollback();
        }
        catch (Exception e) {
            throw LOG.exceptionWhileInteractingWithTransaction("setting transaction rollback only", e);
        }
    }

    @Override
    public void addTransactionListener(TransactionState transactionState, TransactionListener transactionListener) {
        CommandContext commandContext = Context.getCommandContext();
        try {
            this.addTransactionListener(transactionState, transactionListener, commandContext);
        }
        catch (Exception e) {
            throw LOG.exceptionWhileInteractingWithTransaction("registering synchronization", e);
        }
    }

    @Override
    public boolean isTransactionActive() {
        try {
            return this.isTransactionActiveInternal();
        }
        catch (Exception e) {
            throw LOG.exceptionWhileInteractingWithTransaction("getting transaction state", e);
        }
    }

    protected abstract void doRollback() throws Exception;

    protected abstract boolean isTransactionActiveInternal() throws Exception;

    protected abstract void addTransactionListener(TransactionState var1, TransactionListener var2, CommandContext var3) throws Exception;

    public static abstract class TransactionStateSynchronization {
        protected final TransactionListener transactionListener;
        protected final TransactionState transactionState;
        private final CommandContext commandContext;

        public TransactionStateSynchronization(TransactionState transactionState, TransactionListener transactionListener, CommandContext commandContext) {
            this.transactionState = transactionState;
            this.transactionListener = transactionListener;
            this.commandContext = commandContext;
        }

        public void beforeCompletion() {
            if (TransactionState.COMMITTING.equals((Object)this.transactionState) || TransactionState.ROLLINGBACK.equals((Object)this.transactionState)) {
                this.transactionListener.execute(this.commandContext);
            }
        }

        public void afterCompletion(int status) {
            if (this.isRolledBack(status) && TransactionState.ROLLED_BACK.equals((Object)this.transactionState)) {
                this.transactionListener.execute(this.commandContext);
            } else if (this.isCommitted(status) && TransactionState.COMMITTED.equals((Object)this.transactionState)) {
                this.transactionListener.execute(this.commandContext);
            }
        }

        protected abstract boolean isCommitted(int var1);

        protected abstract boolean isRolledBack(int var1);
    }
}

