/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.cfg.jta;

import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.eximeebpms.bpm.engine.impl.cfg.TransactionListener;
import org.eximeebpms.bpm.engine.impl.cfg.TransactionState;
import org.eximeebpms.bpm.engine.impl.cfg.jta.AbstractTransactionContext;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;

public class JtaTransactionContext
extends AbstractTransactionContext {
    protected final TransactionManager transactionManager;

    public JtaTransactionContext(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    protected void doRollback() throws Exception {
        Transaction transaction = this.getTransaction();
        int status = transaction.getStatus();
        if (status != 6 && status != 4) {
            transaction.setRollbackOnly();
        }
    }

    @Override
    protected void addTransactionListener(TransactionState transactionState, TransactionListener transactionListener, CommandContext commandContext) throws Exception {
        this.getTransaction().registerSynchronization((Synchronization)new JtaTransactionStateSynchronization(transactionState, transactionListener, commandContext));
    }

    protected Transaction getTransaction() {
        try {
            return this.transactionManager.getTransaction();
        }
        catch (Exception e) {
            throw LOG.exceptionWhileInteractingWithTransaction("getting transaction", e);
        }
    }

    @Override
    protected boolean isTransactionActiveInternal() throws Exception {
        return this.transactionManager.getStatus() != 1 && this.transactionManager.getStatus() != 6;
    }

    public static class JtaTransactionStateSynchronization
    extends AbstractTransactionContext.TransactionStateSynchronization
    implements Synchronization {
        public JtaTransactionStateSynchronization(TransactionState transactionState, TransactionListener transactionListener, CommandContext commandContext) {
            super(transactionState, transactionListener, commandContext);
        }

        @Override
        protected boolean isRolledBack(int status) {
            return 4 == status;
        }

        @Override
        protected boolean isCommitted(int status) {
            return 3 == status;
        }
    }
}

