/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.cmd;

import java.io.InputStream;
import org.eximeebpms.bpm.engine.BadUserRequestException;
import org.eximeebpms.bpm.engine.exception.DeploymentResourceNotFoundException;
import org.eximeebpms.bpm.engine.exception.NotFoundException;
import org.eximeebpms.bpm.engine.form.CamundaFormRef;
import org.eximeebpms.bpm.engine.form.FormData;
import org.eximeebpms.bpm.engine.impl.cmd.GetCamundaFormDefinitionCmd;
import org.eximeebpms.bpm.engine.impl.cmd.GetDeploymentResourceCmd;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.repository.CamundaFormDefinition;

public abstract class AbstractGetDeployedFormCmd
implements Command<InputStream> {
    protected static String EMBEDDED_KEY = "embedded:";
    protected static String CAMUNDA_FORMS_KEY = "eximeebpms-forms:";
    protected static int EMBEDDED_KEY_LENGTH = EMBEDDED_KEY.length();
    protected static int CAMUNDA_FORMS_KEY_LENGTH = CAMUNDA_FORMS_KEY.length();
    protected static String DEPLOYMENT_KEY = "deployment:";
    protected static int DEPLOYMENT_KEY_LENGTH = DEPLOYMENT_KEY.length();
    protected CommandContext commandContext;

    @Override
    public InputStream execute(CommandContext commandContext) {
        this.commandContext = commandContext;
        this.checkAuthorization();
        FormData formData = this.getFormData();
        String formKey = formData.getFormKey();
        CamundaFormRef camundaFormRef = formData.getCamundaFormRef();
        if (formKey != null) {
            return this.getResourceForFormKey(formData, formKey);
        }
        if (camundaFormRef != null && camundaFormRef.getKey() != null) {
            return this.getResourceForCamundaFormRef(camundaFormRef, formData.getDeploymentId());
        }
        throw new BadUserRequestException("One of the attributes 'formKey' and 'camunda:formRef' must be supplied but none were set.");
    }

    protected InputStream getResourceForFormKey(FormData formData, String formKey) {
        String resourceName = formKey;
        if (resourceName.startsWith(EMBEDDED_KEY)) {
            resourceName = resourceName.substring(EMBEDDED_KEY_LENGTH, resourceName.length());
        } else if (resourceName.startsWith(CAMUNDA_FORMS_KEY)) {
            resourceName = resourceName.substring(CAMUNDA_FORMS_KEY_LENGTH, resourceName.length());
        }
        if (!resourceName.startsWith(DEPLOYMENT_KEY)) {
            throw new BadUserRequestException("The form key '" + formKey + "' does not reference a deployed form.");
        }
        resourceName = resourceName.substring(DEPLOYMENT_KEY_LENGTH, resourceName.length());
        return this.getDeploymentResource(formData.getDeploymentId(), resourceName);
    }

    protected InputStream getResourceForCamundaFormRef(CamundaFormRef camundaFormRef, String deploymentId) {
        CamundaFormDefinition definition = this.commandContext.runWithoutAuthorization(new GetCamundaFormDefinitionCmd(camundaFormRef, deploymentId));
        if (definition == null) {
            throw new NotFoundException("No Camunda Form Definition was found for Camunda Form Ref: " + camundaFormRef);
        }
        return this.getDeploymentResource(definition.getDeploymentId(), definition.getResourceName());
    }

    protected InputStream getDeploymentResource(String deploymentId, String resourceName) {
        GetDeploymentResourceCmd getDeploymentResourceCmd = new GetDeploymentResourceCmd(deploymentId, resourceName);
        try {
            return this.commandContext.runWithoutAuthorization(getDeploymentResourceCmd);
        }
        catch (DeploymentResourceNotFoundException e) {
            throw new NotFoundException("The form with the resource name '" + resourceName + "' cannot be found in deployment with id " + deploymentId, e);
        }
    }

    protected abstract FormData getFormData();

    protected abstract void checkAuthorization();
}

