/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.cmd;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.impl.ActivityExecutionTreeMapping;
import org.eximeebpms.bpm.engine.impl.context.Context;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.eximeebpms.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.eximeebpms.bpm.engine.impl.pvm.process.ScopeImpl;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;
import org.eximeebpms.bpm.engine.runtime.ActivityInstance;
import org.eximeebpms.bpm.engine.runtime.ProcessElementInstance;
import org.eximeebpms.bpm.engine.runtime.TransitionInstance;

public abstract class AbstractProcessInstanceModificationCommand
implements Command<Void> {
    protected String processInstanceId;
    protected boolean skipCustomListeners;
    protected boolean skipIoMappings;
    protected boolean externallyTerminated;

    public AbstractProcessInstanceModificationCommand(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public void setSkipCustomListeners(boolean skipCustomListeners) {
        this.skipCustomListeners = skipCustomListeners;
    }

    public void setSkipIoMappings(boolean skipIoMappings) {
        this.skipIoMappings = skipIoMappings;
    }

    public void setExternallyTerminated(boolean externallyTerminated) {
        this.externallyTerminated = externallyTerminated;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    protected ActivityInstance findActivityInstance(ActivityInstance tree, String activityInstanceId) {
        if (activityInstanceId.equals(tree.getId())) {
            return tree;
        }
        for (ActivityInstance child : tree.getChildActivityInstances()) {
            ActivityInstance matchingChildInstance = this.findActivityInstance(child, activityInstanceId);
            if (matchingChildInstance == null) continue;
            return matchingChildInstance;
        }
        return null;
    }

    protected TransitionInstance findTransitionInstance(ActivityInstance tree, String transitionInstanceId) {
        for (TransitionInstance transitionInstance : tree.getChildTransitionInstances()) {
            if (!this.matchesRequestedTransitionInstance(transitionInstance, transitionInstanceId)) continue;
            return transitionInstance;
        }
        for (ProcessElementInstance processElementInstance : tree.getChildActivityInstances()) {
            TransitionInstance matchingChildInstance = this.findTransitionInstance((ActivityInstance)processElementInstance, transitionInstanceId);
            if (matchingChildInstance == null) continue;
            return matchingChildInstance;
        }
        return null;
    }

    protected boolean matchesRequestedTransitionInstance(TransitionInstance instance, String queryInstanceId) {
        ExecutionEntity replacingExecution;
        ExecutionEntity cachedExecution;
        boolean match = instance.getId().equals(queryInstanceId);
        if (!match && (cachedExecution = Context.getCommandContext().getDbEntityManager().getCachedEntity(ExecutionEntity.class, queryInstanceId)) != null && (replacingExecution = cachedExecution.resolveReplacedBy()) != null) {
            match = replacingExecution.getId().equals(instance.getId());
        }
        return match;
    }

    protected ScopeImpl getScopeForActivityInstance(ProcessDefinitionImpl processDefinition, ActivityInstance activityInstance) {
        String scopeId = activityInstance.getActivityId();
        if (processDefinition.getId().equals(scopeId)) {
            return processDefinition;
        }
        return processDefinition.findActivity(scopeId);
    }

    protected ExecutionEntity getScopeExecutionForActivityInstance(ExecutionEntity processInstance, ActivityExecutionTreeMapping mapping, ActivityInstance activityInstance) {
        EnsureUtil.ensureNotNull("activityInstance", (Object)activityInstance);
        ProcessDefinitionEntity processDefinition = processInstance.getProcessDefinition();
        ScopeImpl scope = this.getScopeForActivityInstance(processDefinition, activityInstance);
        Set<ExecutionEntity> executions = mapping.getExecutions(scope);
        HashSet<String> activityInstanceExecutions = new HashSet<String>(Arrays.asList(activityInstance.getExecutionIds()));
        for (String activityInstanceExecutionId : activityInstance.getExecutionIds()) {
            ExecutionEntity execution = Context.getCommandContext().getExecutionManager().findExecutionById(activityInstanceExecutionId);
            if (!execution.isConcurrent() || !execution.hasChildren()) continue;
            ExecutionEntity child = execution.getExecutions().get(0);
            activityInstanceExecutions.add(child.getId());
        }
        HashSet<ExecutionEntity> retainedExecutionsForInstance = new HashSet<ExecutionEntity>();
        for (ExecutionEntity execution : executions) {
            if (!activityInstanceExecutions.contains(execution.getId())) continue;
            retainedExecutionsForInstance.add(execution);
        }
        if (retainedExecutionsForInstance.size() != 1) {
            throw new ProcessEngineException("There are " + retainedExecutionsForInstance.size() + " (!= 1) executions for activity instance " + activityInstance.getId());
        }
        return (ExecutionEntity)retainedExecutionsForInstance.iterator().next();
    }

    protected String describeFailure(String detailMessage) {
        return "Cannot perform instruction: " + this.describe() + "; " + detailMessage;
    }

    protected abstract String describe();

    public String toString() {
        return this.describe();
    }
}

