/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.cmd;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eximeebpms.bpm.engine.BadUserRequestException;
import org.eximeebpms.bpm.engine.impl.ExternalTaskQueryImpl;
import org.eximeebpms.bpm.engine.impl.HistoricProcessInstanceQueryImpl;
import org.eximeebpms.bpm.engine.impl.ProcessInstanceQueryImpl;
import org.eximeebpms.bpm.engine.impl.batch.BatchElementConfiguration;
import org.eximeebpms.bpm.engine.impl.cmd.UpdateExternalTaskRetriesBuilderImpl;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.entity.PropertyChange;
import org.eximeebpms.bpm.engine.impl.util.CollectionUtil;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;

public abstract class AbstractSetExternalTaskRetriesCmd<T>
implements Command<T> {
    protected UpdateExternalTaskRetriesBuilderImpl builder;

    public AbstractSetExternalTaskRetriesCmd(UpdateExternalTaskRetriesBuilderImpl builder) {
        this.builder = builder;
    }

    protected List<String> collectProcessInstanceIds() {
        HistoricProcessInstanceQueryImpl historicProcessInstanceQuery;
        ProcessInstanceQueryImpl processInstanceQuery;
        HashSet<String> collectedProcessInstanceIds = new HashSet<String>();
        List<String> processInstanceIds = this.builder.getProcessInstanceIds();
        if (processInstanceIds != null && !processInstanceIds.isEmpty()) {
            collectedProcessInstanceIds.addAll(processInstanceIds);
        }
        if ((processInstanceQuery = (ProcessInstanceQueryImpl)this.builder.getProcessInstanceQuery()) != null) {
            collectedProcessInstanceIds.addAll(processInstanceQuery.listIds());
        }
        if ((historicProcessInstanceQuery = (HistoricProcessInstanceQueryImpl)this.builder.getHistoricProcessInstanceQuery()) != null) {
            collectedProcessInstanceIds.addAll(historicProcessInstanceQuery.listIds());
        }
        return new ArrayList<String>(collectedProcessInstanceIds);
    }

    protected BatchElementConfiguration collectExternalTaskIds(CommandContext commandContext) {
        List<String> collectedProcessInstanceIds;
        ExternalTaskQueryImpl externalTaskQuery;
        BatchElementConfiguration elementConfiguration = new BatchElementConfiguration();
        List<String> externalTaskIds = this.builder.getExternalTaskIds();
        if (!CollectionUtil.isEmpty(externalTaskIds)) {
            EnsureUtil.ensureNotContainsNull(BadUserRequestException.class, "External task id cannot be null", "externalTaskIds", externalTaskIds);
            ExternalTaskQueryImpl taskQuery = new ExternalTaskQueryImpl();
            taskQuery.externalTaskIdIn(new HashSet<String>(externalTaskIds));
            elementConfiguration.addDeploymentMappings(commandContext.runWithoutAuthorization(taskQuery::listDeploymentIdMappings), externalTaskIds);
        }
        if ((externalTaskQuery = (ExternalTaskQueryImpl)this.builder.getExternalTaskQuery()) != null) {
            elementConfiguration.addDeploymentMappings(externalTaskQuery.listDeploymentIdMappings());
        }
        if (!(collectedProcessInstanceIds = this.collectProcessInstanceIds()).isEmpty()) {
            ExternalTaskQueryImpl query = new ExternalTaskQueryImpl();
            query.processInstanceIdIn(collectedProcessInstanceIds.toArray(new String[0]));
            elementConfiguration.addDeploymentMappings(commandContext.runWithoutAuthorization(query::listDeploymentIdMappings));
        }
        return elementConfiguration;
    }

    protected void writeUserOperationLog(CommandContext commandContext, int numInstances, boolean async) {
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        propertyChanges.add(new PropertyChange("nrOfInstances", null, numInstances));
        propertyChanges.add(new PropertyChange("async", null, async));
        propertyChanges.add(new PropertyChange("retries", null, this.builder.getRetries()));
        commandContext.getOperationLogManager().logExternalTaskOperation("SetExternalTaskRetries", null, propertyChanges);
    }

    protected void writeUserOperationLogAsync(CommandContext commandContext, int numInstances) {
        this.writeUserOperationLog(commandContext, numInstances, true);
    }
}

