/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.cmd;

import org.eximeebpms.bpm.engine.exception.NotValidException;
import org.eximeebpms.bpm.engine.impl.ActivityExecutionTreeMapping;
import org.eximeebpms.bpm.engine.impl.cmd.AbstractInstanceCancellationCmd;
import org.eximeebpms.bpm.engine.impl.cmd.GetActivityInstanceCmd;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;
import org.eximeebpms.bpm.engine.runtime.ActivityInstance;

public class ActivityInstanceCancellationCmd
extends AbstractInstanceCancellationCmd {
    protected String activityInstanceId;

    public ActivityInstanceCancellationCmd(String processInstanceId, String activityInstanceId) {
        super(processInstanceId);
        this.activityInstanceId = activityInstanceId;
    }

    public ActivityInstanceCancellationCmd(String processInstanceId, String activityInstanceId, String cancellationReason) {
        super(processInstanceId, cancellationReason);
        this.activityInstanceId = activityInstanceId;
    }

    public String getActivityInstanceId() {
        return this.activityInstanceId;
    }

    @Override
    protected ExecutionEntity determineSourceInstanceExecution(CommandContext commandContext) {
        ExecutionEntity processInstance = commandContext.getExecutionManager().findExecutionById(this.processInstanceId);
        ActivityExecutionTreeMapping mapping = new ActivityExecutionTreeMapping(commandContext, this.processInstanceId);
        ActivityInstance instance = commandContext.runWithoutAuthorization(new GetActivityInstanceCmd(this.processInstanceId));
        ActivityInstance instanceToCancel = this.findActivityInstance(instance, this.activityInstanceId);
        EnsureUtil.ensureNotNull(NotValidException.class, this.describeFailure("Activity instance '" + this.activityInstanceId + "' does not exist"), "activityInstance", (Object)instanceToCancel);
        ExecutionEntity scopeExecution = this.getScopeExecutionForActivityInstance(processInstance, mapping, instanceToCancel);
        return scopeExecution;
    }

    @Override
    protected String describe() {
        return "Cancel activity instance '" + this.activityInstanceId + "'";
    }
}

