/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.cmd;

import java.util.List;
import java.util.Objects;
import org.eximeebpms.bpm.engine.authorization.Permission;
import org.eximeebpms.bpm.engine.authorization.Resource;
import org.eximeebpms.bpm.engine.authorization.Resources;
import org.eximeebpms.bpm.engine.impl.ProcessEngineLogger;
import org.eximeebpms.bpm.engine.impl.db.EnginePersistenceLogger;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;

public class AuthorizationCheckCmd
implements Command<Boolean> {
    protected static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;
    protected String userId;
    protected List<String> groupIds;
    protected Permission permission;
    protected Resource resource;
    protected String resourceId;

    public AuthorizationCheckCmd(String userId, List<String> groupIds, Permission permission, Resource resource, String resourceId) {
        this.userId = userId;
        this.groupIds = groupIds;
        this.permission = permission;
        this.resource = resource;
        this.resourceId = resourceId;
        this.validate(userId, groupIds, permission, resource);
    }

    @Override
    public Boolean execute(CommandContext commandContext) {
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        if (authorizationManager.isPermissionDisabled(this.permission)) {
            throw LOG.disabledPermissionException(this.permission.getName());
        }
        if (this.isHistoricInstancePermissionsDisabled(commandContext) && this.isHistoricInstanceResource()) {
            throw LOG.disabledHistoricInstancePermissionsException();
        }
        return authorizationManager.isAuthorized(this.userId, this.groupIds, this.permission, this.resource, this.resourceId);
    }

    protected void validate(String userId, List<String> groupIds, Permission permission, Resource resource) {
        EnsureUtil.ensureAtLeastOneNotNull("Authorization must have a 'userId' or/and a 'groupId'.", userId, groupIds);
        EnsureUtil.ensureNotNull("Invalid permission for an authorization", "authorization.getResource()", (Object)permission);
        EnsureUtil.ensureNotNull("Invalid resource for an authorization", "authorization.getResource()", (Object)resource);
    }

    protected boolean isHistoricInstancePermissionsDisabled(CommandContext commandContext) {
        return !commandContext.getProcessEngineConfiguration().isEnableHistoricInstancePermissions();
    }

    protected boolean isHistoricInstanceResource() {
        return Objects.equals(Resources.HISTORIC_TASK, this.resource) || Objects.equals(Resources.HISTORIC_PROCESS_INSTANCE, this.resource);
    }
}

