/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.cmd;

import java.io.Serializable;
import org.eximeebpms.bpm.engine.BadUserRequestException;
import org.eximeebpms.bpm.engine.exception.NotFoundException;
import org.eximeebpms.bpm.engine.impl.cfg.CommandChecker;
import org.eximeebpms.bpm.engine.impl.core.model.CoreActivity;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.PropertyChange;
import org.eximeebpms.bpm.engine.impl.repository.ResourceDefinitionEntity;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;

public class DeleteHistoricVariableInstanceCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    private String variableInstanceId;

    public DeleteHistoricVariableInstanceCmd(String variableInstanceId) {
        this.variableInstanceId = variableInstanceId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        EnsureUtil.ensureNotEmpty(BadUserRequestException.class, "variableInstanceId", this.variableInstanceId);
        HistoricVariableInstanceEntity variable = commandContext.getHistoricVariableInstanceManager().findHistoricVariableInstanceByVariableInstanceId(this.variableInstanceId);
        EnsureUtil.ensureNotNull(NotFoundException.class, "No historic variable instance found with id: " + this.variableInstanceId, "variable", (Object)variable);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkDeleteHistoricVariableInstance(variable);
        }
        commandContext.getHistoricDetailManager().deleteHistoricDetailsByVariableInstanceId(this.variableInstanceId);
        commandContext.getHistoricVariableInstanceManager().deleteHistoricVariableInstanceByVariableInstanceId(this.variableInstanceId);
        CoreActivity definition = null;
        try {
            if (variable.getProcessDefinitionId() != null) {
                definition = commandContext.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(variable.getProcessDefinitionId());
            } else if (variable.getCaseDefinitionId() != null) {
                definition = commandContext.getProcessEngineConfiguration().getDeploymentCache().findDeployedCaseDefinitionById(variable.getCaseDefinitionId());
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        commandContext.getOperationLogManager().logHistoricVariableOperation("DeleteHistory", variable, (ResourceDefinitionEntity<?>)((Object)definition), new PropertyChange("name", null, variable.getName()));
        return null;
    }
}

