/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.cmd;

import java.util.ArrayList;
import java.util.List;
import org.eximeebpms.bpm.engine.impl.context.Context;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.entity.JobEntity;

public class DeleteJobsCmd
implements Command<Void> {
    private static final long serialVersionUID = 1L;
    protected List<String> jobIds;
    protected boolean cascade;

    public DeleteJobsCmd(List<String> jobIds) {
        this(jobIds, false);
    }

    public DeleteJobsCmd(List<String> jobIds, boolean cascade) {
        this.jobIds = jobIds;
        this.cascade = cascade;
    }

    public DeleteJobsCmd(String jobId) {
        this(jobId, false);
    }

    public DeleteJobsCmd(String jobId, boolean cascade) {
        this.jobIds = new ArrayList<String>();
        this.jobIds.add(jobId);
        this.cascade = cascade;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        JobEntity jobToDelete = null;
        for (String jobId : this.jobIds) {
            jobToDelete = Context.getCommandContext().getJobManager().findJobById(jobId);
            if (jobToDelete == null) continue;
            jobToDelete.delete();
            if (!this.cascade) continue;
            commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(jobId);
        }
        return null;
    }
}

