/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.cmd;

import org.eximeebpms.bpm.engine.impl.ManagementServiceImpl;
import org.eximeebpms.bpm.engine.impl.cfg.CommandChecker;
import org.eximeebpms.bpm.engine.impl.cmd.DeletePropertyCmd;
import org.eximeebpms.bpm.engine.impl.cmd.LicenseCmd;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.entity.PropertyEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.PropertyManager;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ResourceEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ResourceManager;

public class DeleteLicenseKeyCmd
extends LicenseCmd
implements Command<Object> {
    boolean deleteProperty;
    boolean updateDiagnostics;

    public DeleteLicenseKeyCmd(boolean deleteProperty) {
        this(deleteProperty, true);
    }

    public DeleteLicenseKeyCmd(boolean deleteProperty, boolean updateDiagnostics) {
        this.deleteProperty = deleteProperty;
        this.updateDiagnostics = updateDiagnostics;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        commandContext.getAuthorizationManager().checkCamundaAdminOrPermission(CommandChecker::checkDeleteLicenseKey);
        ResourceManager resourceManager = commandContext.getResourceManager();
        PropertyManager propertyManager = commandContext.getPropertyManager();
        PropertyEntity licenseProperty = propertyManager.findPropertyById("eximeebpms-license-key-id");
        ResourceEntity licenseKey = resourceManager.findLicenseKeyResource();
        if (licenseKey != null) {
            resourceManager.delete(licenseKey);
        }
        new DeletePropertyCmd("eximeebpms-license-key").execute(commandContext);
        if (this.deleteProperty) {
            new DeletePropertyCmd("eximeebpms-license-key-id").execute(commandContext);
        }
        if (this.updateDiagnostics) {
            ((ManagementServiceImpl)commandContext.getProcessEngineConfiguration().getManagementService()).setLicenseKeyForDiagnostics(null);
        }
        return null;
    }
}

