/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.eximeebpms.bpm.engine.BadUserRequestException;
import org.eximeebpms.bpm.engine.impl.cfg.CommandChecker;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.entity.CommentEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.PropertyChange;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;
import org.eximeebpms.bpm.engine.task.Comment;

public class DeleteProcessInstanceCommentCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String commentId;
    protected String processInstanceId;

    public DeleteProcessInstanceCommentCmd(String processInstanceId, String commentId) {
        this.processInstanceId = processInstanceId;
        this.commentId = commentId;
    }

    public DeleteProcessInstanceCommentCmd(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "processInstanceId", (Object)this.processInstanceId);
        ExecutionEntity processInstance = commandContext.getExecutionManager().findExecutionById(this.processInstanceId);
        EnsureUtil.ensureNotNull("No processInstance exists with processInstanceId: " + this.processInstanceId, "processInstance", (Object)processInstance);
        this.checkUpdateProcessInstanceById(this.processInstanceId, commandContext);
        if (this.commentId != null) {
            CommentEntity comment = commandContext.getCommentManager().findCommentByProcessInstanceIdAndCommentId(this.processInstanceId, this.commentId);
            if (comment != null) {
                commandContext.getDbEntityManager().delete(comment);
            }
        } else {
            List<Comment> comments = commandContext.getCommentManager().findCommentsByProcessInstanceId(this.processInstanceId);
            if (!comments.isEmpty()) {
                commandContext.getCommentManager().deleteCommentsByProcessInstanceIds(Collections.singletonList(this.processInstanceId));
            }
        }
        this.logOperation(processInstance, commandContext);
        return null;
    }

    protected void logOperation(ExecutionEntity processInstance, CommandContext commandContext) {
        PropertyChange propertyChange = new PropertyChange("comment", null, null);
        commandContext.getOperationLogManager().logCommentOperation("DeleteComment", processInstance, propertyChange);
    }

    protected void checkUpdateProcessInstanceById(String processInstanceId, CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkUpdateProcessInstanceById(processInstanceId);
        }
    }
}

