/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.cmd;

import java.util.Collections;
import org.eximeebpms.bpm.engine.impl.cfg.CommandChecker;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.entity.PropertyChange;
import org.eximeebpms.bpm.engine.impl.persistence.entity.PropertyEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.PropertyManager;

public class DeletePropertyCmd
implements Command<Object> {
    protected String name;

    public DeletePropertyCmd(String name) {
        this.name = name;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        commandContext.getAuthorizationManager().checkCamundaAdminOrPermission(CommandChecker::checkDeleteProperty);
        PropertyManager propertyManager = commandContext.getPropertyManager();
        PropertyEntity propertyEntity = propertyManager.findPropertyById(this.name);
        if (propertyEntity != null) {
            propertyManager.delete(propertyEntity);
            commandContext.getOperationLogManager().logPropertyOperation("Delete", Collections.singletonList(new PropertyChange("name", null, this.name)));
        }
        return null;
    }
}

