/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.cmd;

import org.eximeebpms.bpm.engine.exception.NotValidException;
import org.eximeebpms.bpm.engine.history.UserOperationLogEntry;
import org.eximeebpms.bpm.engine.impl.cfg.CommandChecker;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;

public class DeleteUserOperationLogEntryCmd
implements Command<Void> {
    protected String entryId;

    public DeleteUserOperationLogEntryCmd(String entryId) {
        this.entryId = entryId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull(NotValidException.class, "entryId", (Object)this.entryId);
        UserOperationLogEntry entry = commandContext.getOperationLogManager().findOperationLogById(this.entryId);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkDeleteUserOperationLog(entry);
        }
        commandContext.getOperationLogManager().deleteOperationLogEntryById(this.entryId);
        return null;
    }
}

