/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.cmd;

import org.eximeebpms.bpm.engine.BadUserRequestException;
import org.eximeebpms.bpm.engine.impl.cmd.HandleExternalTaskCmd;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ExternalTaskEntity;
import org.eximeebpms.bpm.engine.impl.util.ClockUtil;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;

public class ExtendLockOnExternalTaskCmd
extends HandleExternalTaskCmd {
    private long newLockTime;

    public ExtendLockOnExternalTaskCmd(String externalTaskId, String workerId, long newLockTime) {
        super(externalTaskId, workerId);
        EnsureUtil.ensurePositive(BadUserRequestException.class, "lockTime", (Long)newLockTime);
        this.newLockTime = newLockTime;
    }

    @Override
    public String getErrorMessageOnWrongWorkerAccess() {
        return "The lock of the External Task " + this.externalTaskId + " cannot be extended by worker '" + this.workerId + "'";
    }

    @Override
    protected void execute(ExternalTaskEntity externalTask) {
        EnsureUtil.ensureGreaterThanOrEqual(BadUserRequestException.class, "Cannot extend a lock that expired", "lockExpirationTime", externalTask.getLockExpirationTime().getTime(), ClockUtil.getCurrentTime().getTime());
        externalTask.extendLock(this.newLockTime);
    }
}

