/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.cmd;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import org.eximeebpms.bpm.engine.exception.DeploymentResourceNotFoundException;
import org.eximeebpms.bpm.engine.impl.cfg.CommandChecker;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ResourceEntity;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;

public class GetDeploymentResourceCmd
implements Command<InputStream>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String deploymentId;
    protected String resourceName;

    public GetDeploymentResourceCmd(String deploymentId, String resourceName) {
        this.deploymentId = deploymentId;
        this.resourceName = resourceName;
    }

    @Override
    public InputStream execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("deploymentId", (Object)this.deploymentId);
        EnsureUtil.ensureNotNull("resourceName", (Object)this.resourceName);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadDeployment(this.deploymentId);
        }
        ResourceEntity resource = commandContext.getResourceManager().findResourceByDeploymentIdAndResourceName(this.deploymentId, this.resourceName);
        EnsureUtil.ensureNotNull(DeploymentResourceNotFoundException.class, "no resource found with name '" + this.resourceName + "' in deployment '" + this.deploymentId + "'", "resource", (Object)resource);
        return new ByteArrayInputStream(resource.getBytes());
    }
}

