/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.cmd;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import org.eximeebpms.bpm.engine.impl.cfg.CommandChecker;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ResourceEntity;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;

public class GetDeploymentResourceForIdCmd
implements Command<InputStream>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String deploymentId;
    protected String resourceId;

    public GetDeploymentResourceForIdCmd(String deploymentId, String resourceId) {
        this.deploymentId = deploymentId;
        this.resourceId = resourceId;
    }

    @Override
    public InputStream execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("deploymentId", (Object)this.deploymentId);
        EnsureUtil.ensureNotNull("resourceId", (Object)this.resourceId);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadDeployment(this.deploymentId);
        }
        ResourceEntity resource = commandContext.getResourceManager().findResourceByDeploymentIdAndResourceId(this.deploymentId, this.resourceId);
        EnsureUtil.ensureNotNull("no resource found with id '" + this.resourceId + "' in deployment '" + this.deploymentId + "'", "resource", (Object)resource);
        return new ByteArrayInputStream(resource.getBytes());
    }
}

