/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.eximeebpms.bpm.engine.impl.cfg.CommandChecker;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.entity.IdentityLinkEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.TaskEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.TaskManager;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;
import org.eximeebpms.bpm.engine.task.IdentityLink;

public class GetIdentityLinksForTaskCmd
implements Command<List<IdentityLink>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;

    public GetIdentityLinksForTaskCmd(String taskId) {
        this.taskId = taskId;
    }

    @Override
    public List<IdentityLink> execute(CommandContext commandContext) {
        IdentityLinkEntity identityLink;
        EnsureUtil.ensureNotNull("taskId", (Object)this.taskId);
        TaskManager taskManager = commandContext.getTaskManager();
        TaskEntity task = taskManager.findTaskById(this.taskId);
        EnsureUtil.ensureNotNull("Cannot find task with id " + this.taskId, "task", (Object)task);
        this.checkGetIdentityLink(task, commandContext);
        List<IdentityLink> identityLinks = task.getIdentityLinks().stream().collect(Collectors.toList());
        if (task.getAssignee() != null) {
            identityLink = new IdentityLinkEntity();
            identityLink.setUserId(task.getAssignee());
            identityLink.setTask(task);
            identityLink.setType("assignee");
            identityLinks.add(identityLink);
        }
        if (task.getOwner() != null) {
            identityLink = new IdentityLinkEntity();
            identityLink.setUserId(task.getOwner());
            identityLink.setTask(task);
            identityLink.setType("owner");
            identityLinks.add(identityLink);
        }
        return identityLinks;
    }

    protected void checkGetIdentityLink(TaskEntity task, CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadTask(task);
        }
    }
}

