/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.cmd;

import java.io.Serializable;
import org.eximeebpms.bpm.engine.impl.cfg.CommandChecker;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.entity.JobEntity;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;

public class GetJobExceptionStacktraceCmd
implements Command<String>,
Serializable {
    private static final long serialVersionUID = 1L;
    private String jobId;

    public GetJobExceptionStacktraceCmd(String jobId) {
        this.jobId = jobId;
    }

    @Override
    public String execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("jobId", (Object)this.jobId);
        JobEntity job = commandContext.getJobManager().findJobById(this.jobId);
        EnsureUtil.ensureNotNull("No job found with id " + this.jobId, "job", (Object)job);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadJob(job);
        }
        return job.getExceptionStacktrace();
    }
}

