/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.cmd;

import java.util.Collection;
import org.eximeebpms.bpm.engine.form.FormField;
import org.eximeebpms.bpm.engine.form.StartFormData;
import org.eximeebpms.bpm.engine.impl.cfg.CommandChecker;
import org.eximeebpms.bpm.engine.impl.cmd.AbstractGetFormVariablesCmd;
import org.eximeebpms.bpm.engine.impl.cmd.GetStartFormCmd;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.eximeebpms.bpm.engine.repository.ProcessDefinition;
import org.eximeebpms.bpm.engine.variable.VariableMap;
import org.eximeebpms.bpm.engine.variable.impl.VariableMapImpl;

public class GetStartFormVariablesCmd
extends AbstractGetFormVariablesCmd {
    private static final long serialVersionUID = 1L;

    public GetStartFormVariablesCmd(String resourceId, Collection<String> formVariableNames, boolean deserializeObjectValues) {
        super(resourceId, formVariableNames, deserializeObjectValues);
    }

    @Override
    public VariableMap execute(CommandContext commandContext) {
        StartFormData startFormData = commandContext.runWithoutAuthorization(new GetStartFormCmd(this.resourceId));
        ProcessDefinition definition = startFormData.getProcessDefinition();
        this.checkGetStartFormVariables((ProcessDefinitionEntity)definition, commandContext);
        VariableMapImpl result = new VariableMapImpl();
        for (FormField formField : startFormData.getFormFields()) {
            if (this.formVariableNames != null && !this.formVariableNames.contains(formField.getId())) continue;
            result.put((Object)formField.getId(), (Object)this.createVariable(formField, null));
        }
        return result;
    }

    protected void checkGetStartFormVariables(ProcessDefinitionEntity definition, CommandContext commandContext) {
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadProcessDefinition(definition);
        }
    }
}

