/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.cmd;

import java.io.Serializable;
import org.eximeebpms.bpm.engine.form.TaskFormData;
import org.eximeebpms.bpm.engine.impl.cfg.CommandChecker;
import org.eximeebpms.bpm.engine.impl.form.handler.TaskFormHandler;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.entity.TaskEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.TaskManager;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;

public class GetTaskFormCmd
implements Command<TaskFormData>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;

    public GetTaskFormCmd(String taskId) {
        this.taskId = taskId;
    }

    @Override
    public TaskFormData execute(CommandContext commandContext) {
        TaskManager taskManager = commandContext.getTaskManager();
        TaskEntity task = taskManager.findTaskById(this.taskId);
        EnsureUtil.ensureNotNull("No task found for taskId '" + this.taskId + "'", "task", (Object)task);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadTaskVariable(task);
        }
        if (task.getTaskDefinition() != null) {
            TaskFormHandler taskFormHandler = task.getTaskDefinition().getTaskFormHandler();
            EnsureUtil.ensureNotNull("No taskFormHandler specified for task '" + this.taskId + "'", "taskFormHandler", (Object)taskFormHandler);
            return taskFormHandler.createTaskForm(task);
        }
        return null;
    }
}

