/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.cmd;

import java.util.Map;
import org.eximeebpms.bpm.engine.impl.cmd.HandleExternalTaskCmd;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ExternalTaskEntity;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;

public class HandleExternalTaskBpmnErrorCmd
extends HandleExternalTaskCmd {
    protected String errorCode;
    protected String errorMessage;
    protected Map<String, Object> variables;

    public HandleExternalTaskBpmnErrorCmd(String externalTaskId, String workerId, String errorCode) {
        super(externalTaskId, workerId);
        this.errorCode = errorCode;
    }

    public HandleExternalTaskBpmnErrorCmd(String externalTaskId, String workerId, String errorCode, String errorMessage, Map<String, Object> variables) {
        super(externalTaskId, workerId);
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.variables = variables;
    }

    @Override
    protected void validateInput() {
        super.validateInput();
        EnsureUtil.ensureNotNull("errorCode", (Object)this.errorCode);
    }

    @Override
    public String getErrorMessageOnWrongWorkerAccess() {
        return "Bpmn error of External Task " + this.externalTaskId + " cannot be reported by worker '" + this.workerId;
    }

    @Override
    public void execute(ExternalTaskEntity externalTask) {
        externalTask.bpmnError(this.errorCode, this.errorMessage, this.variables);
    }
}

