/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.impl.db.DbEntity;
import org.eximeebpms.bpm.engine.impl.db.entitymanager.DbEntityManager;
import org.eximeebpms.bpm.engine.impl.db.entitymanager.operation.DbBulkOperation;
import org.eximeebpms.bpm.engine.impl.db.entitymanager.operation.DbOperationType;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.management.DatabasePurgeReport;
import org.eximeebpms.bpm.engine.impl.management.PurgeReport;
import org.eximeebpms.bpm.engine.impl.persistence.deploy.cache.CachePurgeReport;
import org.eximeebpms.bpm.engine.impl.persistence.deploy.cache.DeploymentCache;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ByteArrayEntity;

public class PurgeDatabaseAndCacheCmd
implements Command<PurgeReport>,
Serializable {
    protected static final String DELETE_TABLE_DATA = "deleteTableData";
    protected static final String SELECT_TABLE_COUNT = "selectTableCount";
    protected static final String TABLE_NAME = "tableName";
    protected static final String EMPTY_STRING = "";
    public static final List<String> TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK = Arrays.asList("ACT_GE_PROPERTY", "ACT_GE_SCHEMA_LOG");

    @Override
    public PurgeReport execute(CommandContext commandContext) {
        PurgeReport purgeReport = new PurgeReport();
        DatabasePurgeReport databasePurgeReport = this.purgeDatabase(commandContext);
        purgeReport.setDatabasePurgeReport(databasePurgeReport);
        DeploymentCache deploymentCache = commandContext.getProcessEngineConfiguration().getDeploymentCache();
        CachePurgeReport cachePurgeReport = deploymentCache.purgeCache();
        purgeReport.setCachePurgeReport(cachePurgeReport);
        return purgeReport;
    }

    private DatabasePurgeReport purgeDatabase(CommandContext commandContext) {
        DbEntityManager dbEntityManager = commandContext.getDbEntityManager();
        dbEntityManager.setIgnoreForeignKeysForNextFlush(true);
        List<String> tablesNames = dbEntityManager.getTableNamesPresentInDatabase();
        String databaseTablePrefix = commandContext.getProcessEngineConfiguration().getDatabaseTablePrefix().trim();
        DatabasePurgeReport databasePurgeReport = new DatabasePurgeReport();
        for (String tableName : tablesNames) {
            String tableNameWithoutPrefix = tableName.replace(databaseTablePrefix, EMPTY_STRING);
            if (TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK.contains(tableNameWithoutPrefix)) continue;
            HashMap<String, String> param = new HashMap<String, String>();
            param.put(TABLE_NAME, tableName);
            Long count = (Long)dbEntityManager.selectOne(SELECT_TABLE_COUNT, param);
            if (count <= 0L) continue;
            if (tableNameWithoutPrefix.equals("ACT_GE_BYTEARRAY") && commandContext.getResourceManager().findLicenseKeyResource() != null) {
                if (count != 1L) {
                    DbBulkOperation purgeByteArrayPreserveLicenseKeyBulkOp = new DbBulkOperation(DbOperationType.DELETE_BULK, ByteArrayEntity.class, "purgeTablePreserveLicenseKey", "eximeebpms-license-key-id");
                    databasePurgeReport.addPurgeInformation(tableName, count - 1L);
                    dbEntityManager.getDbOperationManager().addOperation(purgeByteArrayPreserveLicenseKeyBulkOp);
                }
                databasePurgeReport.setDbContainsLicenseKey(true);
                continue;
            }
            databasePurgeReport.addPurgeInformation(tableName, count);
            List<Class<? extends DbEntity>> entities = commandContext.getTableDataManager().getEntities(tableName);
            if (entities.isEmpty()) {
                throw new ProcessEngineException("No mapped implementation of " + DbEntity.class.getName() + " was found for: " + tableName);
            }
            Class<? extends DbEntity> entity = entities.get(0);
            DbBulkOperation deleteBulkOp = new DbBulkOperation(DbOperationType.DELETE_BULK, entity, DELETE_TABLE_DATA, param);
            dbEntityManager.getDbOperationManager().addOperation(deleteBulkOp);
        }
        return databasePurgeReport;
    }
}

