/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.cmd;

import org.eximeebpms.bpm.engine.impl.cfg.CommandChecker;
import org.eximeebpms.bpm.engine.impl.context.Context;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;

public class RegisterDeploymentCmd
implements Command<Void> {
    protected String deploymentId;

    public RegisterDeploymentCmd(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        DeploymentEntity deployment = commandContext.getDeploymentManager().findDeploymentById(this.deploymentId);
        EnsureUtil.ensureNotNull("Deployment " + this.deploymentId + " does not exist", "deployment", (Object)deployment);
        commandContext.getAuthorizationManager().checkCamundaAdminOrPermission(CommandChecker::checkRegisterDeployment);
        Context.getProcessEngineConfiguration().getRegisteredDeployments().add(this.deploymentId);
        return null;
    }
}

