/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.cmd;

import java.util.Collections;
import java.util.Set;
import org.eximeebpms.bpm.application.ProcessApplicationReference;
import org.eximeebpms.bpm.application.ProcessApplicationRegistration;
import org.eximeebpms.bpm.engine.impl.application.ProcessApplicationManager;
import org.eximeebpms.bpm.engine.impl.cfg.CommandChecker;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.context.Context;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;

public class RegisterProcessApplicationCmd
implements Command<ProcessApplicationRegistration> {
    protected ProcessApplicationReference reference;
    protected Set<String> deploymentsToRegister;

    public RegisterProcessApplicationCmd(String deploymentId, ProcessApplicationReference reference) {
        this(Collections.singleton(deploymentId), reference);
    }

    public RegisterProcessApplicationCmd(Set<String> deploymentsToRegister, ProcessApplicationReference appReference) {
        this.deploymentsToRegister = deploymentsToRegister;
        this.reference = appReference;
    }

    @Override
    public ProcessApplicationRegistration execute(CommandContext commandContext) {
        commandContext.getAuthorizationManager().checkCamundaAdminOrPermission(CommandChecker::checkRegisterProcessApplication);
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        ProcessApplicationManager processApplicationManager = processEngineConfiguration.getProcessApplicationManager();
        return processApplicationManager.registerProcessApplicationForDeployments(this.deploymentsToRegister, this.reference);
    }
}

