/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.cmd;

import java.util.Collections;
import org.eximeebpms.bpm.engine.BadUserRequestException;
import org.eximeebpms.bpm.engine.exception.NotFoundException;
import org.eximeebpms.bpm.engine.impl.cfg.CommandChecker;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.PropertyChange;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;
import org.eximeebpms.bpm.engine.runtime.Incident;

public class ResolveIncidentCmd
implements Command<Void> {
    protected String incidentId;

    public ResolveIncidentCmd(String incidentId) {
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "", "incidentId", (Object)incidentId);
        this.incidentId = incidentId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        Incident incident = commandContext.getIncidentManager().findIncidentById(this.incidentId);
        EnsureUtil.ensureNotNull(NotFoundException.class, "Cannot find an incident with id '" + this.incidentId + "'", "incident", (Object)incident);
        if (incident.getIncidentType().equals("failedJob") || incident.getIncidentType().equals("failedExternalTask")) {
            throw new BadUserRequestException("Cannot resolve an incident of type " + incident.getIncidentType());
        }
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "", "executionId", (Object)incident.getExecutionId());
        ExecutionEntity execution = commandContext.getExecutionManager().findExecutionById(incident.getExecutionId());
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "Cannot find an execution for an incident with id '" + this.incidentId + "'", "execution", (Object)execution);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkUpdateProcessInstance(execution);
        }
        commandContext.getOperationLogManager().logProcessInstanceOperation("Resolve", execution.getProcessInstanceId(), execution.getProcessDefinitionId(), null, Collections.singletonList(new PropertyChange("incidentId", null, this.incidentId)));
        execution.resolveIncident(this.incidentId);
        return null;
    }
}

