/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.impl.cfg.CommandChecker;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.entity.JobEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.PropertyChange;
import org.eximeebpms.bpm.engine.impl.persistence.entity.TimerEntity;

public class SetJobDuedateCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String jobId;
    private Date newDuedate;
    private final boolean cascade;

    public SetJobDuedateCmd(String jobId, Date newDuedate, boolean cascade) {
        if (jobId == null || jobId.length() < 1) {
            throw new ProcessEngineException("The job id is mandatory, but '" + jobId + "' has been provided.");
        }
        this.jobId = jobId;
        this.newDuedate = newDuedate;
        this.cascade = cascade;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        JobEntity job = commandContext.getJobManager().findJobById(this.jobId);
        if (job != null) {
            for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
                checker.checkUpdateJob(job);
            }
            commandContext.getOperationLogManager().logJobOperation("SetDueDate", this.jobId, job.getJobDefinitionId(), job.getProcessInstanceId(), job.getProcessDefinitionId(), job.getProcessDefinitionKey(), Collections.singletonList(new PropertyChange("duedate", job.getDuedate(), this.newDuedate)));
            if (this.cascade && this.newDuedate != null && job instanceof TimerEntity) {
                long offset = this.newDuedate.getTime() - job.getDuedate().getTime();
                ((TimerEntity)job).setRepeatOffset(((TimerEntity)job).getRepeatOffset() + offset);
            }
        } else {
            throw new ProcessEngineException("No job found with id '" + this.jobId + "'.");
        }
        job.setDuedate(this.newDuedate);
        return null;
    }
}

