/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.Map;
import org.eximeebpms.bpm.engine.BadUserRequestException;
import org.eximeebpms.bpm.engine.impl.cfg.CommandChecker;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;

public class SignalCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String executionId;
    protected String signalName;
    protected Object signalData;
    protected final Map<String, Object> processVariables;

    public SignalCmd(String executionId, String signalName, Object signalData, Map<String, Object> processVariables) {
        this.executionId = executionId;
        this.signalName = signalName;
        this.signalData = signalData;
        this.processVariables = processVariables;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "executionId is null", "executionId", (Object)this.executionId);
        ExecutionEntity execution = commandContext.getExecutionManager().findExecutionById(this.executionId);
        EnsureUtil.ensureNotNull(BadUserRequestException.class, "execution " + this.executionId + " doesn't exist", "execution", (Object)execution);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkUpdateProcessInstance(execution);
        }
        if (this.processVariables != null) {
            execution.setVariables(this.processVariables);
        }
        execution.signal(this.signalName, this.signalData);
        return null;
    }
}

