/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.Collections;
import org.eximeebpms.bpm.engine.impl.ProcessInstantiationBuilderImpl;
import org.eximeebpms.bpm.engine.impl.cfg.CommandChecker;
import org.eximeebpms.bpm.engine.impl.cmd.GetDeployedProcessDefinitionCmd;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ExecutionVariableSnapshotObserver;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.eximeebpms.bpm.engine.impl.persistence.entity.ProcessInstanceWithVariablesImpl;
import org.eximeebpms.bpm.engine.impl.persistence.entity.PropertyChange;
import org.eximeebpms.bpm.engine.runtime.ProcessInstanceWithVariables;

public class StartProcessInstanceCmd
implements Command<ProcessInstanceWithVariables>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final ProcessInstantiationBuilderImpl instantiationBuilder;

    public StartProcessInstanceCmd(ProcessInstantiationBuilderImpl instantiationBuilder) {
        this.instantiationBuilder = instantiationBuilder;
    }

    @Override
    public ProcessInstanceWithVariables execute(CommandContext commandContext) {
        ProcessDefinitionEntity processDefinition = new GetDeployedProcessDefinitionCmd(this.instantiationBuilder, false).execute(commandContext);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkCreateProcessInstance(processDefinition);
        }
        ExecutionEntity processInstance = processDefinition.createProcessInstance(this.instantiationBuilder.getBusinessKey(), this.instantiationBuilder.getCaseInstanceId());
        if (this.instantiationBuilder.getTenantId() != null) {
            processInstance.setTenantId(this.instantiationBuilder.getTenantId());
        }
        ExecutionVariableSnapshotObserver variablesListener = new ExecutionVariableSnapshotObserver(processInstance);
        processInstance.start(this.instantiationBuilder.getVariables());
        commandContext.getOperationLogManager().logProcessInstanceOperation("Create", processInstance.getId(), processInstance.getProcessDefinitionId(), processInstance.getProcessDefinition().getKey(), Collections.singletonList(PropertyChange.EMPTY_CHANGE));
        return new ProcessInstanceWithVariablesImpl(processInstance, variablesListener.getVariables());
    }
}

