/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.cmd;

import java.util.Collections;
import java.util.Set;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.impl.cfg.CommandChecker;
import org.eximeebpms.bpm.engine.impl.context.Context;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;

public class UnregisterProcessApplicationCmd
implements Command<Void> {
    protected boolean removeProcessesFromCache;
    protected Set<String> deploymentIds;

    public UnregisterProcessApplicationCmd(String deploymentId, boolean removeProcessesFromCache) {
        this(Collections.singleton(deploymentId), removeProcessesFromCache);
    }

    public UnregisterProcessApplicationCmd(Set<String> deploymentIds, boolean removeProcessesFromCache) {
        this.deploymentIds = deploymentIds;
        this.removeProcessesFromCache = removeProcessesFromCache;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.deploymentIds == null) {
            throw new ProcessEngineException("Deployment Ids cannot be null.");
        }
        commandContext.getAuthorizationManager().checkCamundaAdminOrPermission(CommandChecker::checkUnregisterProcessApplication);
        Context.getProcessEngineConfiguration().getProcessApplicationManager().unregisterProcessApplicationForDeployments(this.deploymentIds, this.removeProcessesFromCache);
        return null;
    }
}

