/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.cmmn;

import java.util.Collection;
import java.util.Map;
import org.eximeebpms.bpm.engine.CaseService;
import org.eximeebpms.bpm.engine.exception.NotFoundException;
import org.eximeebpms.bpm.engine.exception.NotValidException;
import org.eximeebpms.bpm.engine.exception.NullValueException;
import org.eximeebpms.bpm.engine.exception.cmmn.CaseExecutionNotFoundException;
import org.eximeebpms.bpm.engine.impl.ServiceImpl;
import org.eximeebpms.bpm.engine.impl.cmmn.CaseExecutionCommandBuilderImpl;
import org.eximeebpms.bpm.engine.impl.cmmn.CaseInstanceBuilderImpl;
import org.eximeebpms.bpm.engine.impl.cmmn.cmd.GetCaseExecutionVariableCmd;
import org.eximeebpms.bpm.engine.impl.cmmn.cmd.GetCaseExecutionVariableTypedCmd;
import org.eximeebpms.bpm.engine.impl.cmmn.cmd.GetCaseExecutionVariablesCmd;
import org.eximeebpms.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionQueryImpl;
import org.eximeebpms.bpm.engine.impl.cmmn.entity.runtime.CaseInstanceQueryImpl;
import org.eximeebpms.bpm.engine.runtime.CaseExecutionCommandBuilder;
import org.eximeebpms.bpm.engine.runtime.CaseExecutionQuery;
import org.eximeebpms.bpm.engine.runtime.CaseInstance;
import org.eximeebpms.bpm.engine.runtime.CaseInstanceBuilder;
import org.eximeebpms.bpm.engine.runtime.CaseInstanceQuery;
import org.eximeebpms.bpm.engine.variable.VariableMap;
import org.eximeebpms.bpm.engine.variable.value.TypedValue;

public class CaseServiceImpl
extends ServiceImpl
implements CaseService {
    @Override
    public CaseInstanceBuilder withCaseDefinitionByKey(String caseDefinitionKey) {
        return new CaseInstanceBuilderImpl(this.commandExecutor, caseDefinitionKey, null);
    }

    @Override
    public CaseInstanceBuilder withCaseDefinition(String caseDefinitionId) {
        return new CaseInstanceBuilderImpl(this.commandExecutor, null, caseDefinitionId);
    }

    @Override
    public CaseInstanceQuery createCaseInstanceQuery() {
        return new CaseInstanceQueryImpl(this.commandExecutor);
    }

    @Override
    public CaseExecutionQuery createCaseExecutionQuery() {
        return new CaseExecutionQueryImpl(this.commandExecutor);
    }

    @Override
    public CaseExecutionCommandBuilder withCaseExecution(String caseExecutionId) {
        return new CaseExecutionCommandBuilderImpl(this.commandExecutor, caseExecutionId);
    }

    public VariableMap getVariables(String caseExecutionId) {
        return this.getVariablesTyped(caseExecutionId);
    }

    @Override
    public VariableMap getVariablesTyped(String caseExecutionId) {
        return this.getVariablesTyped(caseExecutionId, true);
    }

    @Override
    public VariableMap getVariablesTyped(String caseExecutionId, boolean deserializeValues) {
        return this.getCaseExecutionVariables(caseExecutionId, null, false, deserializeValues);
    }

    public VariableMap getVariablesLocal(String caseExecutionId) {
        return this.getVariablesLocalTyped(caseExecutionId);
    }

    @Override
    public VariableMap getVariablesLocalTyped(String caseExecutionId) {
        return this.getVariablesLocalTyped(caseExecutionId, true);
    }

    @Override
    public VariableMap getVariablesLocalTyped(String caseExecutionId, boolean deserializeValues) {
        return this.getCaseExecutionVariables(caseExecutionId, null, true, deserializeValues);
    }

    public VariableMap getVariables(String caseExecutionId, Collection<String> variableNames) {
        return this.getVariablesTyped(caseExecutionId, variableNames, true);
    }

    @Override
    public VariableMap getVariablesTyped(String caseExecutionId, Collection<String> variableNames, boolean deserializeValues) {
        return this.getCaseExecutionVariables(caseExecutionId, variableNames, false, deserializeValues);
    }

    public VariableMap getVariablesLocal(String caseExecutionId, Collection<String> variableNames) {
        return this.getVariablesLocalTyped(caseExecutionId, variableNames, true);
    }

    @Override
    public VariableMap getVariablesLocalTyped(String caseExecutionId, Collection<String> variableNames, boolean deserializeValues) {
        return this.getCaseExecutionVariables(caseExecutionId, variableNames, true, deserializeValues);
    }

    protected VariableMap getCaseExecutionVariables(String caseExecutionId, Collection<String> variableNames, boolean isLocal, boolean deserializeValues) {
        try {
            return this.commandExecutor.execute(new GetCaseExecutionVariablesCmd(caseExecutionId, variableNames, isLocal, deserializeValues));
        }
        catch (NullValueException e) {
            throw new NotValidException(e.getMessage(), e);
        }
        catch (CaseExecutionNotFoundException e) {
            throw new NotFoundException(e.getMessage(), e);
        }
    }

    @Override
    public Object getVariable(String caseExecutionId, String variableName) {
        return this.getCaseExecutionVariable(caseExecutionId, variableName, false);
    }

    @Override
    public Object getVariableLocal(String caseExecutionId, String variableName) {
        return this.getCaseExecutionVariable(caseExecutionId, variableName, true);
    }

    protected Object getCaseExecutionVariable(String caseExecutionId, String variableName, boolean isLocal) {
        try {
            return this.commandExecutor.execute(new GetCaseExecutionVariableCmd(caseExecutionId, variableName, isLocal));
        }
        catch (NullValueException e) {
            throw new NotValidException(e.getMessage(), e);
        }
        catch (CaseExecutionNotFoundException e) {
            throw new NotFoundException(e.getMessage(), e);
        }
    }

    @Override
    public <T extends TypedValue> T getVariableTyped(String caseExecutionId, String variableName) {
        return this.getVariableTyped(caseExecutionId, variableName, true);
    }

    @Override
    public <T extends TypedValue> T getVariableTyped(String caseExecutionId, String variableName, boolean deserializeValue) {
        return this.getCaseExecutionVariableTyped(caseExecutionId, variableName, false, deserializeValue);
    }

    @Override
    public <T extends TypedValue> T getVariableLocalTyped(String caseExecutionId, String variableName) {
        return this.getVariableLocalTyped(caseExecutionId, variableName, true);
    }

    @Override
    public <T extends TypedValue> T getVariableLocalTyped(String caseExecutionId, String variableName, boolean deserializeValue) {
        return this.getCaseExecutionVariableTyped(caseExecutionId, variableName, true, deserializeValue);
    }

    protected <T extends TypedValue> T getCaseExecutionVariableTyped(String caseExecutionId, String variableName, boolean isLocal, boolean deserializeValue) {
        try {
            return (T)this.commandExecutor.execute(new GetCaseExecutionVariableTypedCmd(caseExecutionId, variableName, isLocal, deserializeValue));
        }
        catch (NullValueException e) {
            throw new NotValidException(e.getMessage(), e);
        }
        catch (CaseExecutionNotFoundException e) {
            throw new NotFoundException(e.getMessage(), e);
        }
    }

    @Override
    public void setVariables(String caseExecutionId, Map<String, Object> variables) {
        this.withCaseExecution(caseExecutionId).setVariables(variables).execute();
    }

    @Override
    public void setVariablesLocal(String caseExecutionId, Map<String, Object> variables) {
        this.withCaseExecution(caseExecutionId).setVariablesLocal(variables).execute();
    }

    @Override
    public void setVariable(String caseExecutionId, String variableName, Object value) {
        this.withCaseExecution(caseExecutionId).setVariable(variableName, value).execute();
    }

    @Override
    public void setVariableLocal(String caseExecutionId, String variableName, Object value) {
        this.withCaseExecution(caseExecutionId).setVariableLocal(variableName, value).execute();
    }

    @Override
    public void removeVariables(String caseExecutionId, Collection<String> variableNames) {
        this.withCaseExecution(caseExecutionId).removeVariables(variableNames).execute();
    }

    @Override
    public void removeVariablesLocal(String caseExecutionId, Collection<String> variableNames) {
        this.withCaseExecution(caseExecutionId).removeVariablesLocal(variableNames).execute();
    }

    @Override
    public void removeVariable(String caseExecutionId, String variableName) {
        this.withCaseExecution(caseExecutionId).removeVariable(variableName).execute();
    }

    @Override
    public void removeVariableLocal(String caseExecutionId, String variableName) {
        this.withCaseExecution(caseExecutionId).removeVariableLocal(variableName).execute();
    }

    @Override
    public CaseInstance createCaseInstanceByKey(String caseDefinitionKey) {
        return this.withCaseDefinitionByKey(caseDefinitionKey).create();
    }

    @Override
    public CaseInstance createCaseInstanceByKey(String caseDefinitionKey, String businessKey) {
        return this.withCaseDefinitionByKey(caseDefinitionKey).businessKey(businessKey).create();
    }

    @Override
    public CaseInstance createCaseInstanceByKey(String caseDefinitionKey, Map<String, Object> variables) {
        return this.withCaseDefinitionByKey(caseDefinitionKey).setVariables(variables).create();
    }

    @Override
    public CaseInstance createCaseInstanceByKey(String caseDefinitionKey, String businessKey, Map<String, Object> variables) {
        return this.withCaseDefinitionByKey(caseDefinitionKey).businessKey(businessKey).setVariables(variables).create();
    }

    @Override
    public CaseInstance createCaseInstanceById(String caseDefinitionId) {
        return this.withCaseDefinition(caseDefinitionId).create();
    }

    @Override
    public CaseInstance createCaseInstanceById(String caseDefinitionId, String businessKey) {
        return this.withCaseDefinition(caseDefinitionId).businessKey(businessKey).create();
    }

    @Override
    public CaseInstance createCaseInstanceById(String caseDefinitionId, Map<String, Object> variables) {
        return this.withCaseDefinition(caseDefinitionId).setVariables(variables).create();
    }

    @Override
    public CaseInstance createCaseInstanceById(String caseDefinitionId, String businessKey, Map<String, Object> variables) {
        return this.withCaseDefinition(caseDefinitionId).businessKey(businessKey).setVariables(variables).create();
    }

    @Override
    public void manuallyStartCaseExecution(String caseExecutionId) {
        this.withCaseExecution(caseExecutionId).manualStart();
    }

    @Override
    public void manuallyStartCaseExecution(String caseExecutionId, Map<String, Object> variables) {
        this.withCaseExecution(caseExecutionId).setVariables(variables).manualStart();
    }

    @Override
    public void disableCaseExecution(String caseExecutionId) {
        this.withCaseExecution(caseExecutionId).disable();
    }

    @Override
    public void disableCaseExecution(String caseExecutionId, Map<String, Object> variables) {
        this.withCaseExecution(caseExecutionId).setVariables(variables).disable();
    }

    @Override
    public void reenableCaseExecution(String caseExecutionId) {
        this.withCaseExecution(caseExecutionId).reenable();
    }

    @Override
    public void reenableCaseExecution(String caseExecutionId, Map<String, Object> variables) {
        this.withCaseExecution(caseExecutionId).setVariables(variables).reenable();
    }

    @Override
    public void completeCaseExecution(String caseExecutionId) {
        this.withCaseExecution(caseExecutionId).complete();
    }

    @Override
    public void completeCaseExecution(String caseExecutionId, Map<String, Object> variables) {
        this.withCaseExecution(caseExecutionId).setVariables(variables).complete();
    }

    @Override
    public void closeCaseInstance(String caseInstanceId) {
        this.withCaseExecution(caseInstanceId).close();
    }

    @Override
    public void terminateCaseExecution(String caseExecutionId) {
        this.withCaseExecution(caseExecutionId).terminate();
    }

    @Override
    public void terminateCaseExecution(String caseExecutionId, Map<String, Object> variables) {
        this.withCaseExecution(caseExecutionId).setVariables(variables).terminate();
    }
}

