/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.cmmn.behavior;

import org.eximeebpms.bpm.engine.exception.cmmn.CaseIllegalStateTransitionException;
import org.eximeebpms.bpm.engine.impl.ProcessEngineLogger;
import org.eximeebpms.bpm.engine.impl.cmmn.behavior.CmmnBehaviorLogger;
import org.eximeebpms.bpm.engine.impl.cmmn.behavior.PlanItemDefinitionActivityBehavior;
import org.eximeebpms.bpm.engine.impl.cmmn.execution.CaseExecutionState;
import org.eximeebpms.bpm.engine.impl.cmmn.execution.CmmnActivityExecution;

public abstract class EventListenerOrMilestoneActivityBehavior
extends PlanItemDefinitionActivityBehavior {
    protected static final CmmnBehaviorLogger LOG = ProcessEngineLogger.CMNN_BEHAVIOR_LOGGER;

    @Override
    public void onEnable(CmmnActivityExecution execution) {
        throw this.createIllegalStateTransitionException("enable", execution);
    }

    @Override
    public void onReenable(CmmnActivityExecution execution) {
        throw this.createIllegalStateTransitionException("reenable", execution);
    }

    @Override
    public void onDisable(CmmnActivityExecution execution) {
        throw this.createIllegalStateTransitionException("disable", execution);
    }

    @Override
    public void onStart(CmmnActivityExecution execution) {
        throw this.createIllegalStateTransitionException("start", execution);
    }

    @Override
    public void onManualStart(CmmnActivityExecution execution) {
        throw this.createIllegalStateTransitionException("manualStart", execution);
    }

    @Override
    public void onCompletion(CmmnActivityExecution execution) {
        throw this.createIllegalStateTransitionException("complete", execution);
    }

    @Override
    public void onManualCompletion(CmmnActivityExecution execution) {
        throw this.createIllegalStateTransitionException("complete", execution);
    }

    @Override
    public void onTermination(CmmnActivityExecution execution) {
        this.ensureTransitionAllowed(execution, CaseExecutionState.AVAILABLE, CaseExecutionState.TERMINATED, "terminate");
        this.performTerminate(execution);
    }

    @Override
    public void onParentTermination(CmmnActivityExecution execution) {
        if (execution.isCompleted()) {
            String id = execution.getId();
            throw LOG.executionAlreadyCompletedException("parentTerminate", id);
        }
        this.performParentTerminate(execution);
    }

    @Override
    public void onExit(CmmnActivityExecution execution) {
        throw this.createIllegalStateTransitionException("exit", execution);
    }

    @Override
    public void onOccur(CmmnActivityExecution execution) {
        this.ensureTransitionAllowed(execution, CaseExecutionState.AVAILABLE, CaseExecutionState.COMPLETED, "occur");
    }

    @Override
    public void onSuspension(CmmnActivityExecution execution) {
        this.ensureTransitionAllowed(execution, CaseExecutionState.AVAILABLE, CaseExecutionState.SUSPENDED, "suspend");
        this.performSuspension(execution);
    }

    @Override
    public void onParentSuspension(CmmnActivityExecution execution) {
        throw this.createIllegalStateTransitionException("parentSuspend", execution);
    }

    @Override
    public void onResume(CmmnActivityExecution execution) {
        this.ensureTransitionAllowed(execution, CaseExecutionState.SUSPENDED, CaseExecutionState.AVAILABLE, "resume");
        CmmnActivityExecution parent = execution.getParent();
        if (parent != null && !parent.isActive()) {
            String id = execution.getId();
            throw LOG.resumeInactiveCaseException("resume", id);
        }
        this.resuming(execution);
    }

    @Override
    public void onParentResume(CmmnActivityExecution execution) {
        throw this.createIllegalStateTransitionException("parentResume", execution);
    }

    @Override
    public void onReactivation(CmmnActivityExecution execution) {
        throw this.createIllegalStateTransitionException("reactivate", execution);
    }

    protected boolean isAtLeastOneExitCriterionSatisfied(CmmnActivityExecution execution) {
        return false;
    }

    @Override
    public void fireExitCriteria(CmmnActivityExecution execution) {
        throw LOG.criteriaNotAllowedForEventListenerOrMilestonesException("exit", execution.getId());
    }

    protected CaseIllegalStateTransitionException createIllegalStateTransitionException(String transition, CmmnActivityExecution execution) {
        String id = execution.getId();
        return LOG.illegalStateTransitionException(transition, id, this.getTypeName());
    }

    protected abstract String getTypeName();
}

