/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.cmmn.behavior;

import java.util.List;
import org.eximeebpms.bpm.engine.impl.ProcessEngineLogger;
import org.eximeebpms.bpm.engine.impl.cmmn.behavior.CmmnActivityBehavior;
import org.eximeebpms.bpm.engine.impl.cmmn.behavior.CmmnBehaviorLogger;
import org.eximeebpms.bpm.engine.impl.cmmn.behavior.CmmnCompositeActivityBehavior;
import org.eximeebpms.bpm.engine.impl.cmmn.behavior.StageOrTaskActivityBehavior;
import org.eximeebpms.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.eximeebpms.bpm.engine.impl.cmmn.execution.CaseExecutionState;
import org.eximeebpms.bpm.engine.impl.cmmn.execution.CmmnActivityExecution;
import org.eximeebpms.bpm.engine.impl.cmmn.execution.CmmnExecution;
import org.eximeebpms.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.eximeebpms.bpm.engine.impl.util.ActivityBehaviorUtil;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;

public class StageActivityBehavior
extends StageOrTaskActivityBehavior
implements CmmnCompositeActivityBehavior {
    protected static final CmmnBehaviorLogger LOG = ProcessEngineLogger.CMNN_BEHAVIOR_LOGGER;

    @Override
    protected void performStart(CmmnActivityExecution execution) {
        CmmnActivity activity = execution.getActivity();
        List<CmmnActivity> childActivities = activity.getActivities();
        if (childActivities != null && !childActivities.isEmpty()) {
            List<CmmnExecution> children = execution.createChildExecutions(childActivities);
            execution.createSentryParts();
            execution.triggerChildExecutionsLifecycle(children);
            if (execution.isActive()) {
                execution.fireIfOnlySentryParts();
                if (execution.isActive()) {
                    this.checkAndCompleteCaseExecution(execution);
                }
            }
        } else {
            execution.complete();
        }
    }

    @Override
    public void onReactivation(CmmnActivityExecution execution) {
        String id = execution.getId();
        if (execution.isActive()) {
            throw LOG.alreadyActiveException("reactivate", id);
        }
        if (execution.isCaseInstanceExecution()) {
            if (execution.isClosed()) {
                throw LOG.alreadyClosedCaseException("reactivate", id);
            }
        } else {
            this.ensureTransitionAllowed(execution, CaseExecutionState.FAILED, CaseExecutionState.ACTIVE, "reactivate");
        }
    }

    @Override
    public void reactivated(CmmnActivityExecution execution) {
        CaseExecutionState previousState;
        if (execution.isCaseInstanceExecution() && CaseExecutionState.SUSPENDED.equals(previousState = execution.getPreviousState())) {
            this.resumed(execution);
        }
    }

    @Override
    public void onCompletion(CmmnActivityExecution execution) {
        this.ensureTransitionAllowed(execution, CaseExecutionState.ACTIVE, CaseExecutionState.COMPLETED, "complete");
        this.canComplete(execution, true);
        this.completing(execution);
    }

    @Override
    public void onManualCompletion(CmmnActivityExecution execution) {
        this.ensureTransitionAllowed(execution, CaseExecutionState.ACTIVE, CaseExecutionState.COMPLETED, "complete");
        this.canComplete(execution, true, true);
        this.completing(execution);
    }

    @Override
    protected void completing(CmmnActivityExecution execution) {
        List<? extends CmmnExecution> children = execution.getCaseExecutions();
        for (CmmnExecution cmmnExecution : children) {
            if (!cmmnExecution.isDisabled()) {
                cmmnExecution.parentComplete();
                continue;
            }
            cmmnExecution.remove();
        }
    }

    protected boolean canComplete(CmmnActivityExecution execution) {
        return this.canComplete(execution, false);
    }

    protected boolean canComplete(CmmnActivityExecution execution, boolean throwException) {
        boolean autoComplete = this.evaluateAutoComplete(execution);
        return this.canComplete(execution, throwException, autoComplete);
    }

    protected boolean canComplete(CmmnActivityExecution execution, boolean throwException, boolean autoComplete) {
        String id = execution.getId();
        List<? extends CmmnExecution> children = execution.getCaseExecutions();
        if (children == null || children.isEmpty()) {
            return true;
        }
        for (CmmnExecution cmmnExecution : children) {
            if (!cmmnExecution.isNew() && !cmmnExecution.isActive()) continue;
            if (throwException) {
                throw LOG.remainingChildException("complete", id, cmmnExecution.getId(), CaseExecutionState.ACTIVE);
            }
            return false;
        }
        if (autoComplete) {
            for (CmmnExecution cmmnExecution : children) {
                if (!cmmnExecution.isRequired() || cmmnExecution.isDisabled() || cmmnExecution.isCompleted() || cmmnExecution.isTerminated()) continue;
                if (throwException) {
                    throw LOG.remainingChildException("complete", id, cmmnExecution.getId(), cmmnExecution.getCurrentState());
                }
                return false;
            }
        } else {
            for (CmmnExecution cmmnExecution : children) {
                if (cmmnExecution.isDisabled() || cmmnExecution.isCompleted() || cmmnExecution.isTerminated()) continue;
                if (throwException) {
                    throw LOG.wrongChildStateException("complete", id, cmmnExecution.getId(), "[available|enabled|suspended]");
                }
                return false;
            }
        }
        return true;
    }

    protected boolean evaluateAutoComplete(CmmnActivityExecution execution) {
        CmmnActivity activity = this.getActivity(execution);
        Object autoCompleteProperty = activity.getProperty("autoComplete");
        if (autoCompleteProperty != null) {
            String message = "Property autoComplete expression returns non-Boolean: " + autoCompleteProperty + " (" + autoCompleteProperty.getClass().getName() + ")";
            EnsureUtil.ensureInstanceOf(message, "autoComplete", autoCompleteProperty, Boolean.class);
            return (Boolean)autoCompleteProperty;
        }
        return false;
    }

    protected boolean isAbleToTerminate(CmmnActivityExecution execution) {
        List<? extends CmmnExecution> children = execution.getCaseExecutions();
        if (children != null && !children.isEmpty()) {
            for (CmmnExecution cmmnExecution : children) {
                if (cmmnExecution.isTerminated() || cmmnExecution.isCompleted()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected void performTerminate(CmmnActivityExecution execution) {
        if (!this.isAbleToTerminate(execution)) {
            this.terminateChildren(execution);
        } else {
            super.performTerminate(execution);
        }
    }

    @Override
    protected void performExit(CmmnActivityExecution execution) {
        if (!this.isAbleToTerminate(execution)) {
            this.terminateChildren(execution);
        } else {
            super.performExit(execution);
        }
    }

    protected void terminateChildren(CmmnActivityExecution execution) {
        List<? extends CmmnExecution> children = execution.getCaseExecutions();
        for (CmmnExecution cmmnExecution : children) {
            this.terminateChild(cmmnExecution);
        }
    }

    protected void terminateChild(CmmnExecution child) {
        CmmnActivityBehavior behavior = ActivityBehaviorUtil.getActivityBehavior(child);
        if (!child.isTerminated() && !child.isCompleted()) {
            if (behavior instanceof StageOrTaskActivityBehavior) {
                child.exit();
            } else {
                child.parentTerminate();
            }
        }
    }

    @Override
    protected void performSuspension(CmmnActivityExecution execution) {
        if (!this.isAbleToSuspend(execution)) {
            this.suspendChildren(execution);
        } else {
            super.performSuspension(execution);
        }
    }

    @Override
    protected void performParentSuspension(CmmnActivityExecution execution) {
        if (!this.isAbleToSuspend(execution)) {
            this.suspendChildren(execution);
        } else {
            super.performParentSuspension(execution);
        }
    }

    protected void suspendChildren(CmmnActivityExecution execution) {
        List<? extends CmmnExecution> children = execution.getCaseExecutions();
        if (children != null && !children.isEmpty()) {
            for (CmmnExecution cmmnExecution : children) {
                CmmnActivityBehavior behavior = ActivityBehaviorUtil.getActivityBehavior(cmmnExecution);
                if (cmmnExecution.isTerminated() || cmmnExecution.isSuspended()) continue;
                if (behavior instanceof StageOrTaskActivityBehavior) {
                    cmmnExecution.parentSuspend();
                    continue;
                }
                cmmnExecution.suspend();
            }
        }
    }

    protected boolean isAbleToSuspend(CmmnActivityExecution execution) {
        List<? extends CmmnExecution> children = execution.getCaseExecutions();
        if (children != null && !children.isEmpty()) {
            for (CmmnExecution cmmnExecution : children) {
                if (cmmnExecution.isSuspended()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void resumed(CmmnActivityExecution execution) {
        if (execution.isAvailable()) {
            this.created(execution);
        } else if (execution.isActive()) {
            this.resumeChildren(execution);
        }
    }

    protected void resumeChildren(CmmnActivityExecution execution) {
        List<? extends CmmnExecution> children = execution.getCaseExecutions();
        if (children != null && !children.isEmpty()) {
            for (CmmnExecution cmmnExecution : children) {
                CmmnActivityBehavior behavior = ActivityBehaviorUtil.getActivityBehavior(cmmnExecution);
                if (cmmnExecution.isTerminated()) continue;
                if (behavior instanceof StageOrTaskActivityBehavior) {
                    cmmnExecution.parentResume();
                    continue;
                }
                cmmnExecution.resume();
            }
        }
    }

    @Override
    protected boolean isAtLeastOneEntryCriterionSatisfied(CmmnActivityExecution execution) {
        if (!execution.isCaseInstanceExecution()) {
            return super.isAtLeastOneEntryCriterionSatisfied(execution);
        }
        return false;
    }

    @Override
    public void fireExitCriteria(CmmnActivityExecution execution) {
        if (!execution.isCaseInstanceExecution()) {
            execution.exit();
        } else {
            execution.terminate();
        }
    }

    @Override
    public void fireEntryCriteria(CmmnActivityExecution execution) {
        if (!execution.isCaseInstanceExecution()) {
            super.fireEntryCriteria(execution);
            return;
        }
        throw LOG.criteriaNotAllowedForCaseInstanceException("entry", execution.getId());
    }

    @Override
    public void handleChildCompletion(CmmnActivityExecution execution, CmmnActivityExecution child) {
        this.fireForceUpdate(execution);
        if (execution.isActive()) {
            this.checkAndCompleteCaseExecution(execution);
        }
    }

    @Override
    public void handleChildDisabled(CmmnActivityExecution execution, CmmnActivityExecution child) {
        this.fireForceUpdate(execution);
        if (execution.isActive()) {
            this.checkAndCompleteCaseExecution(execution);
        }
    }

    @Override
    public void handleChildSuspension(CmmnActivityExecution execution, CmmnActivityExecution child) {
        if (execution.isSuspending() && this.isAbleToSuspend(execution)) {
            String id = execution.getId();
            CaseExecutionState currentState = execution.getCurrentState();
            if (CaseExecutionState.SUSPENDING_ON_SUSPENSION.equals(currentState)) {
                execution.performSuspension();
            } else if (CaseExecutionState.SUSPENDING_ON_PARENT_SUSPENSION.equals(currentState)) {
                execution.performParentSuspension();
            } else {
                throw LOG.suspendCaseException(id, currentState);
            }
        }
    }

    @Override
    public void handleChildTermination(CmmnActivityExecution execution, CmmnActivityExecution child) {
        this.fireForceUpdate(execution);
        if (execution.isActive()) {
            this.checkAndCompleteCaseExecution(execution);
        } else if (execution.isTerminating() && this.isAbleToTerminate(execution)) {
            String id = execution.getId();
            CaseExecutionState currentState = execution.getCurrentState();
            if (CaseExecutionState.TERMINATING_ON_TERMINATION.equals(currentState)) {
                execution.performTerminate();
            } else if (CaseExecutionState.TERMINATING_ON_EXIT.equals(currentState)) {
                execution.performExit();
            } else {
                if (CaseExecutionState.TERMINATING_ON_PARENT_TERMINATION.equals(currentState)) {
                    throw LOG.illegalStateTransitionException("parentTerminate", id, this.getTypeName());
                }
                throw LOG.terminateCaseException(id, currentState);
            }
        }
    }

    protected void checkAndCompleteCaseExecution(CmmnActivityExecution execution) {
        if (this.canComplete(execution)) {
            execution.complete();
        }
    }

    protected void fireForceUpdate(CmmnActivityExecution execution) {
        if (execution instanceof CaseExecutionEntity) {
            CaseExecutionEntity entity = (CaseExecutionEntity)execution;
            entity.forceUpdate();
        }
    }

    @Override
    protected String getTypeName() {
        return "stage";
    }
}

