/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.cmmn.behavior;

import org.eximeebpms.bpm.engine.impl.ProcessEngineLogger;
import org.eximeebpms.bpm.engine.impl.cmmn.CaseControlRule;
import org.eximeebpms.bpm.engine.impl.cmmn.behavior.CmmnBehaviorLogger;
import org.eximeebpms.bpm.engine.impl.cmmn.behavior.PlanItemDefinitionActivityBehavior;
import org.eximeebpms.bpm.engine.impl.cmmn.execution.CaseExecutionState;
import org.eximeebpms.bpm.engine.impl.cmmn.execution.CmmnActivityExecution;
import org.eximeebpms.bpm.engine.impl.cmmn.model.CmmnActivity;

public abstract class StageOrTaskActivityBehavior
extends PlanItemDefinitionActivityBehavior {
    protected static final CmmnBehaviorLogger LOG = ProcessEngineLogger.CMNN_BEHAVIOR_LOGGER;

    @Override
    protected void creating(CmmnActivityExecution execution) {
        this.evaluateRequiredRule(execution);
    }

    @Override
    public void created(CmmnActivityExecution execution) {
        if (execution.isAvailable() && this.isAtLeastOneEntryCriterionSatisfied(execution)) {
            this.fireEntryCriteria(execution);
        }
    }

    @Override
    public void onEnable(CmmnActivityExecution execution) {
        this.ensureNotCaseInstance(execution, "enable");
        this.ensureTransitionAllowed(execution, CaseExecutionState.AVAILABLE, CaseExecutionState.ENABLED, "enable");
    }

    @Override
    public void onReenable(CmmnActivityExecution execution) {
        this.ensureNotCaseInstance(execution, "re-enable");
        this.ensureTransitionAllowed(execution, CaseExecutionState.DISABLED, CaseExecutionState.ENABLED, "re-enable");
    }

    @Override
    public void onDisable(CmmnActivityExecution execution) {
        this.ensureNotCaseInstance(execution, "disable");
        this.ensureTransitionAllowed(execution, CaseExecutionState.ENABLED, CaseExecutionState.DISABLED, "disable");
    }

    @Override
    public void onStart(CmmnActivityExecution execution) {
        this.ensureNotCaseInstance(execution, "start");
        this.ensureTransitionAllowed(execution, CaseExecutionState.AVAILABLE, CaseExecutionState.ACTIVE, "start");
    }

    @Override
    public void onManualStart(CmmnActivityExecution execution) {
        this.ensureNotCaseInstance(execution, "manualStart");
        this.ensureTransitionAllowed(execution, CaseExecutionState.ENABLED, CaseExecutionState.ACTIVE, "start");
    }

    @Override
    public void started(CmmnActivityExecution execution) {
        if (execution.isActive()) {
            this.performStart(execution);
        }
    }

    protected abstract void performStart(CmmnActivityExecution var1);

    @Override
    public void onCompletion(CmmnActivityExecution execution) {
        this.ensureTransitionAllowed(execution, CaseExecutionState.ACTIVE, CaseExecutionState.COMPLETED, "complete");
        this.completing(execution);
    }

    @Override
    public void onManualCompletion(CmmnActivityExecution execution) {
        this.ensureTransitionAllowed(execution, CaseExecutionState.ACTIVE, CaseExecutionState.COMPLETED, "complete");
        this.manualCompleting(execution);
    }

    @Override
    public void onTermination(CmmnActivityExecution execution) {
        this.ensureTransitionAllowed(execution, CaseExecutionState.ACTIVE, CaseExecutionState.TERMINATED, "terminate");
        this.performTerminate(execution);
    }

    @Override
    public void onParentTermination(CmmnActivityExecution execution) {
        String id = execution.getId();
        throw LOG.illegalStateTransitionException("parentTerminate", id, this.getTypeName());
    }

    @Override
    public void onExit(CmmnActivityExecution execution) {
        String id = execution.getId();
        if (execution.isTerminated()) {
            throw LOG.alreadyTerminatedException("exit", id);
        }
        if (execution.isCompleted()) {
            throw LOG.wrongCaseStateException("exit", id, "[available|enabled|disabled|active|failed|suspended]", "completed");
        }
        this.performExit(execution);
    }

    @Override
    public void onSuspension(CmmnActivityExecution execution) {
        this.ensureTransitionAllowed(execution, CaseExecutionState.ACTIVE, CaseExecutionState.SUSPENDED, "suspend");
        this.performSuspension(execution);
    }

    @Override
    public void onParentSuspension(CmmnActivityExecution execution) {
        this.ensureNotCaseInstance(execution, "parentSuspension");
        String id = execution.getId();
        if (execution.isSuspended()) {
            throw LOG.alreadySuspendedException("parentSuspend", id);
        }
        if (execution.isCompleted() || execution.isTerminated()) {
            throw LOG.wrongCaseStateException("parentSuspend", id, "suspend", "[available|enabled|disabled|active]", execution.getCurrentState().toString());
        }
        this.performParentSuspension(execution);
    }

    @Override
    public void onResume(CmmnActivityExecution execution) {
        this.ensureNotCaseInstance(execution, "resume");
        this.ensureTransitionAllowed(execution, CaseExecutionState.SUSPENDED, CaseExecutionState.ACTIVE, "resume");
        CmmnActivityExecution parent = execution.getParent();
        if (parent != null && !parent.isActive()) {
            String id = execution.getId();
            throw LOG.resumeInactiveCaseException("resume", id);
        }
        this.resuming(execution);
    }

    @Override
    public void onParentResume(CmmnActivityExecution execution) {
        this.ensureNotCaseInstance(execution, "parentResume");
        String id = execution.getId();
        if (!execution.isSuspended()) {
            throw LOG.wrongCaseStateException("parentResume", id, "resume", "suspended", execution.getCurrentState().toString());
        }
        CmmnActivityExecution parent = execution.getParent();
        if (parent != null && !parent.isActive()) {
            throw LOG.resumeInactiveCaseException("parentResume", id);
        }
        this.resuming(execution);
    }

    @Override
    public void onOccur(CmmnActivityExecution execution) {
        String id = execution.getId();
        throw LOG.illegalStateTransitionException("occur", id, this.getTypeName());
    }

    @Override
    public void fireEntryCriteria(CmmnActivityExecution execution) {
        boolean manualActivation = this.evaluateManualActivationRule(execution);
        if (manualActivation) {
            execution.enable();
        } else {
            execution.start();
        }
    }

    protected boolean evaluateManualActivationRule(CmmnActivityExecution execution) {
        boolean manualActivation = false;
        CmmnActivity activity = execution.getActivity();
        Object manualActivationRule = activity.getProperty("manualActivationRule");
        if (manualActivationRule != null) {
            CaseControlRule rule = (CaseControlRule)manualActivationRule;
            manualActivation = rule.evaluate(execution);
        }
        return manualActivation;
    }

    protected abstract String getTypeName();
}

