/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.cmmn.cmd;

import java.io.Serializable;
import java.util.Collection;
import org.eximeebpms.bpm.engine.exception.cmmn.CaseExecutionNotFoundException;
import org.eximeebpms.bpm.engine.impl.cfg.CommandChecker;
import org.eximeebpms.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;
import org.eximeebpms.bpm.engine.variable.VariableMap;
import org.eximeebpms.bpm.engine.variable.impl.VariableMapImpl;

public class GetCaseExecutionVariablesCmd
implements Command<VariableMap>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String caseExecutionId;
    protected Collection<String> variableNames;
    protected boolean isLocal;
    protected boolean deserializeValues;

    public GetCaseExecutionVariablesCmd(String caseExecutionId, Collection<String> variableNames, boolean isLocal, boolean deserializeValues) {
        this.caseExecutionId = caseExecutionId;
        this.variableNames = variableNames;
        this.isLocal = isLocal;
        this.deserializeValues = deserializeValues;
    }

    @Override
    public VariableMap execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("caseExecutionId", (Object)this.caseExecutionId);
        CaseExecutionEntity caseExecution = commandContext.getCaseExecutionManager().findCaseExecutionById(this.caseExecutionId);
        EnsureUtil.ensureNotNull(CaseExecutionNotFoundException.class, "case execution " + this.caseExecutionId + " doesn't exist", "caseExecution", (Object)caseExecution);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadCaseInstance(caseExecution);
        }
        VariableMapImpl result = new VariableMapImpl();
        caseExecution.collectVariables(result, this.variableNames, this.isLocal, this.deserializeValues);
        return result;
    }
}

