/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.cmmn.cmd;

import org.eximeebpms.bpm.engine.exception.cmmn.CmmnModelInstanceNotFoundException;
import org.eximeebpms.bpm.engine.impl.cfg.CommandChecker;
import org.eximeebpms.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.eximeebpms.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.eximeebpms.bpm.engine.impl.context.Context;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.deploy.cache.DeploymentCache;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;
import org.eximeebpms.bpm.model.cmmn.CmmnModelInstance;

public class GetDeploymentCmmnModelInstanceCmd
implements Command<CmmnModelInstance> {
    protected String caseDefinitionId;

    public GetDeploymentCmmnModelInstanceCmd(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
    }

    @Override
    public CmmnModelInstance execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("caseDefinitionId", (Object)this.caseDefinitionId);
        ProcessEngineConfigurationImpl configuration = Context.getProcessEngineConfiguration();
        DeploymentCache deploymentCache = configuration.getDeploymentCache();
        CaseDefinitionEntity caseDefinition = deploymentCache.findDeployedCaseDefinitionById(this.caseDefinitionId);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadCaseDefinition(caseDefinition);
        }
        CmmnModelInstance modelInstance = Context.getProcessEngineConfiguration().getDeploymentCache().findCmmnModelInstanceForCaseDefinition(this.caseDefinitionId);
        EnsureUtil.ensureNotNull(CmmnModelInstanceNotFoundException.class, "No CMMN model instance found for case definition id " + this.caseDefinitionId, "modelInstance", (Object)modelInstance);
        return modelInstance;
    }
}

