/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.cmmn.entity.runtime;

import java.util.Arrays;
import java.util.List;
import org.eximeebpms.bpm.engine.BadUserRequestException;
import org.eximeebpms.bpm.engine.impl.AbstractQuery;
import org.eximeebpms.bpm.engine.impl.Page;
import org.eximeebpms.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.eximeebpms.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionQueryImpl;
import org.eximeebpms.bpm.engine.impl.cmmn.entity.runtime.CaseInstanceQueryImpl;
import org.eximeebpms.bpm.engine.impl.context.Context;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.AbstractManager;
import org.eximeebpms.bpm.engine.runtime.CaseExecution;
import org.eximeebpms.bpm.engine.runtime.CaseInstance;

public class CaseExecutionManager
extends AbstractManager {
    public void insertCaseExecution(CaseExecutionEntity caseExecution) {
        this.getDbEntityManager().insert(caseExecution);
    }

    public void deleteCaseExecution(CaseExecutionEntity caseExecution) {
        this.getDbEntityManager().delete(caseExecution);
    }

    public void deleteCaseInstancesByCaseDefinition(String caseDefinitionId, String deleteReason, boolean cascade) {
        List caseInstanceIds = this.getDbEntityManager().selectList("selectCaseInstanceIdsByCaseDefinitionId", caseDefinitionId);
        for (String caseInstanceId : caseInstanceIds) {
            this.deleteCaseInstance(caseInstanceId, deleteReason, cascade);
        }
        if (cascade) {
            Context.getCommandContext().getHistoricCaseInstanceManager().deleteHistoricCaseInstanceByCaseDefinitionId(caseDefinitionId);
        }
    }

    public void deleteCaseInstance(String caseInstanceId, String deleteReason) {
        this.deleteCaseInstance(caseInstanceId, deleteReason, false);
    }

    public void deleteCaseInstance(String caseInstanceId, String deleteReason, boolean cascade) {
        CaseExecutionEntity execution = this.findCaseExecutionById(caseInstanceId);
        if (execution == null) {
            throw new BadUserRequestException("No case instance found for id '" + caseInstanceId + "'");
        }
        CommandContext commandContext = Context.getCommandContext();
        commandContext.getTaskManager().deleteTasksByCaseInstanceId(caseInstanceId, deleteReason, cascade);
        execution.deleteCascade();
        if (cascade) {
            Context.getCommandContext().getHistoricCaseInstanceManager().deleteHistoricCaseInstancesByIds(Arrays.asList(caseInstanceId));
        }
    }

    public CaseExecutionEntity findCaseExecutionById(String caseExecutionId) {
        return this.getDbEntityManager().selectById(CaseExecutionEntity.class, caseExecutionId);
    }

    public CaseExecutionEntity findSubCaseInstanceBySuperCaseExecutionId(String superCaseExecutionId) {
        return (CaseExecutionEntity)this.getDbEntityManager().selectOne("selectSubCaseInstanceBySuperCaseExecutionId", superCaseExecutionId);
    }

    public CaseExecutionEntity findSubCaseInstanceBySuperExecutionId(String superExecutionId) {
        return (CaseExecutionEntity)this.getDbEntityManager().selectOne("selectSubCaseInstanceBySuperExecutionId", superExecutionId);
    }

    public long findCaseExecutionCountByQueryCriteria(CaseExecutionQueryImpl caseExecutionQuery) {
        this.configureTenantCheck(caseExecutionQuery);
        return (Long)this.getDbEntityManager().selectOne("selectCaseExecutionCountByQueryCriteria", caseExecutionQuery);
    }

    public List<CaseExecution> findCaseExecutionsByQueryCriteria(CaseExecutionQueryImpl caseExecutionQuery, Page page) {
        this.configureTenantCheck(caseExecutionQuery);
        return this.getDbEntityManager().selectList("selectCaseExecutionsByQueryCriteria", caseExecutionQuery, page);
    }

    public long findCaseInstanceCountByQueryCriteria(CaseInstanceQueryImpl caseInstanceQuery) {
        this.configureTenantCheck(caseInstanceQuery);
        return (Long)this.getDbEntityManager().selectOne("selectCaseInstanceCountByQueryCriteria", caseInstanceQuery);
    }

    public List<CaseInstance> findCaseInstanceByQueryCriteria(CaseInstanceQueryImpl caseInstanceQuery, Page page) {
        this.configureTenantCheck(caseInstanceQuery);
        return this.getDbEntityManager().selectList("selectCaseInstanceByQueryCriteria", caseInstanceQuery, page);
    }

    public List<CaseExecutionEntity> findChildCaseExecutionsByParentCaseExecutionId(String parentCaseExecutionId) {
        return this.getDbEntityManager().selectList("selectCaseExecutionsByParentCaseExecutionId", parentCaseExecutionId);
    }

    public List<CaseExecutionEntity> findChildCaseExecutionsByCaseInstanceId(String caseInstanceId) {
        return this.getDbEntityManager().selectList("selectCaseExecutionsByCaseInstanceId", caseInstanceId);
    }

    protected void configureTenantCheck(AbstractQuery<?, ?> query) {
        this.getTenantManager().configureQuery(query);
    }
}

