/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.cmmn.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.delegate.CaseExecutionListener;
import org.eximeebpms.bpm.engine.delegate.CaseVariableListener;
import org.eximeebpms.bpm.engine.impl.bpmn.helper.CmmnProperties;
import org.eximeebpms.bpm.engine.impl.bpmn.parser.FieldDeclaration;
import org.eximeebpms.bpm.engine.impl.cmmn.CaseControlRule;
import org.eximeebpms.bpm.engine.impl.cmmn.behavior.CaseControlRuleImpl;
import org.eximeebpms.bpm.engine.impl.cmmn.behavior.CmmnActivityBehavior;
import org.eximeebpms.bpm.engine.impl.cmmn.handler.CmmnElementHandler;
import org.eximeebpms.bpm.engine.impl.cmmn.handler.CmmnHandlerContext;
import org.eximeebpms.bpm.engine.impl.cmmn.listener.ClassDelegateCaseExecutionListener;
import org.eximeebpms.bpm.engine.impl.cmmn.listener.DelegateExpressionCaseExecutionListener;
import org.eximeebpms.bpm.engine.impl.cmmn.listener.ExpressionCaseExecutionListener;
import org.eximeebpms.bpm.engine.impl.cmmn.listener.ScriptCaseExecutionListener;
import org.eximeebpms.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.eximeebpms.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.eximeebpms.bpm.engine.impl.cmmn.model.CmmnSentryDeclaration;
import org.eximeebpms.bpm.engine.impl.el.Expression;
import org.eximeebpms.bpm.engine.impl.el.ExpressionManager;
import org.eximeebpms.bpm.engine.impl.el.FixedValue;
import org.eximeebpms.bpm.engine.impl.scripting.ExecutableScript;
import org.eximeebpms.bpm.engine.impl.util.ScriptUtil;
import org.eximeebpms.bpm.engine.impl.variable.listener.ClassDelegateCaseVariableListener;
import org.eximeebpms.bpm.engine.impl.variable.listener.DelegateExpressionCaseVariableListener;
import org.eximeebpms.bpm.engine.impl.variable.listener.ExpressionCaseVariableListener;
import org.eximeebpms.bpm.engine.impl.variable.listener.ScriptCaseVariableListener;
import org.eximeebpms.bpm.model.cmmn.Query;
import org.eximeebpms.bpm.model.cmmn.instance.CmmnElement;
import org.eximeebpms.bpm.model.cmmn.instance.ConditionExpression;
import org.eximeebpms.bpm.model.cmmn.instance.DiscretionaryItem;
import org.eximeebpms.bpm.model.cmmn.instance.Documentation;
import org.eximeebpms.bpm.model.cmmn.instance.ExtensionElements;
import org.eximeebpms.bpm.model.cmmn.instance.ManualActivationRule;
import org.eximeebpms.bpm.model.cmmn.instance.PlanItem;
import org.eximeebpms.bpm.model.cmmn.instance.PlanItemControl;
import org.eximeebpms.bpm.model.cmmn.instance.PlanItemDefinition;
import org.eximeebpms.bpm.model.cmmn.instance.RepetitionRule;
import org.eximeebpms.bpm.model.cmmn.instance.RequiredRule;
import org.eximeebpms.bpm.model.cmmn.instance.Sentry;
import org.eximeebpms.bpm.model.cmmn.instance.eximeebpms.CamundaCaseExecutionListener;
import org.eximeebpms.bpm.model.cmmn.instance.eximeebpms.CamundaExpression;
import org.eximeebpms.bpm.model.cmmn.instance.eximeebpms.CamundaField;
import org.eximeebpms.bpm.model.cmmn.instance.eximeebpms.CamundaScript;
import org.eximeebpms.bpm.model.cmmn.instance.eximeebpms.CamundaString;
import org.eximeebpms.bpm.model.cmmn.instance.eximeebpms.CamundaVariableListener;
import org.eximeebpms.bpm.model.xml.instance.ModelElementInstance;
import org.eximeebpms.bpm.model.xml.type.ModelElementType;

public abstract class ItemHandler
extends CmmnElementHandler<CmmnElement, CmmnActivity> {
    public static final String PROPERTY_AUTO_COMPLETE = "autoComplete";
    public static final String PROPERTY_REQUIRED_RULE = "requiredRule";
    public static final String PROPERTY_MANUAL_ACTIVATION_RULE = "manualActivationRule";
    public static final String PROPERTY_REPETITION_RULE = "repetitionRule";
    public static final String PROPERTY_IS_BLOCKING = "isBlocking";
    public static final String PROPERTY_DISCRETIONARY = "discretionary";
    public static final String PROPERTY_ACTIVITY_TYPE = "activityType";
    public static final String PROPERTY_ACTIVITY_DESCRIPTION = "description";
    protected static final String PARENT_COMPLETE = "parentComplete";
    public static List<String> TASK_OR_STAGE_CREATE_EVENTS = Arrays.asList("create");
    public static List<String> TASK_OR_STAGE_UPDATE_EVENTS = Arrays.asList("enable", "disable", "reenable", "start", "manualStart", "suspend", "parentSuspend", "resume", "parentResume");
    public static List<String> TASK_OR_STAGE_END_EVENTS = Arrays.asList("terminate", "exit", "complete", "parentComplete");
    public static List<String> TASK_OR_STAGE_EVENTS = new ArrayList<String>();
    public static List<String> EVENT_LISTENER_OR_MILESTONE_CREATE_EVENTS = Arrays.asList("create");
    public static List<String> EVENT_LISTENER_OR_MILESTONE_UPDATE_EVENTS = Arrays.asList("suspend", "resume");
    public static List<String> EVENT_LISTENER_OR_MILESTONE_END_EVENTS = Arrays.asList("terminate", "parentTerminate", "occur", "parentComplete");
    public static List<String> EVENT_LISTENER_OR_MILESTONE_EVENTS = new ArrayList<String>();
    public static List<String> CASE_PLAN_MODEL_CREATE_EVENTS = Arrays.asList("create");
    public static List<String> CASE_PLAN_MODEL_UPDATE_EVENTS = Arrays.asList("terminate", "suspend", "complete", "reactivate");
    public static List<String> CASE_PLAN_MODEL_CLOSE_EVENTS = Arrays.asList("close");
    public static List<String> CASE_PLAN_MODEL_EVENTS = new ArrayList<String>();
    public static List<String> DEFAULT_VARIABLE_EVENTS = Arrays.asList("create", "delete", "update");

    protected CmmnActivity createActivity(CmmnElement element, CmmnHandlerContext context) {
        String id = element.getId();
        CmmnActivity parent = context.getParent();
        CmmnActivity newActivity = null;
        if (parent != null) {
            newActivity = parent.createActivity(id);
        } else {
            CmmnCaseDefinition caseDefinition = context.getCaseDefinition();
            newActivity = new CmmnActivity(id, caseDefinition);
        }
        newActivity.setCmmnElement(element);
        CmmnActivityBehavior behavior = this.getActivityBehavior();
        newActivity.setActivityBehavior(behavior);
        return newActivity;
    }

    protected CmmnActivityBehavior getActivityBehavior() {
        return null;
    }

    @Override
    public CmmnActivity handleElement(CmmnElement element, CmmnHandlerContext context) {
        CmmnActivity newActivity = this.createActivity(element, context);
        this.initializeActivity(element, newActivity, context);
        return newActivity;
    }

    protected void initializeActivity(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context) {
        PlanItemDefinition definition;
        String name;
        if (this.isDiscretionaryItem(element)) {
            activity.setProperty(PROPERTY_DISCRETIONARY, true);
        }
        if ((name = this.getName(element)) == null && (definition = this.getDefinition(element)) != null) {
            name = definition.getName();
        }
        activity.setName(name);
        this.initializeActivityType(element, activity, context);
        this.initializeDescription(element, activity, context);
        this.initializeAutoComplete(element, activity, context);
        this.initializeRequiredRule(element, activity, context);
        this.initializeManualActivationRule(element, activity, context);
        this.initializeRepetitionRule(element, activity, context);
        this.initializeCaseExecutionListeners(element, activity, context);
        this.initializeVariableListeners(element, activity, context);
        this.initializeEntryCriterias(element, activity, context);
        this.initializeExitCriterias(element, activity, context);
    }

    protected void initializeActivityType(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context) {
        ModelElementType elementType;
        PlanItemDefinition definition = this.getDefinition(element);
        String activityType = null;
        if (definition != null && (elementType = definition.getElementType()) != null) {
            activityType = elementType.getTypeName();
        }
        activity.setProperty(PROPERTY_ACTIVITY_TYPE, activityType);
    }

    protected void initializeDescription(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context) {
        String description = this.getDesciption(element);
        if (description == null) {
            description = this.getDocumentation(element);
        }
        activity.setProperty(PROPERTY_ACTIVITY_DESCRIPTION, description);
    }

    protected void initializeAutoComplete(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context) {
    }

    protected void initializeRequiredRule(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context) {
        PlanItemControl itemControl = this.getItemControl(element);
        PlanItemControl defaultControl = this.getDefaultControl(element);
        RequiredRule requiredRule = null;
        if (itemControl != null) {
            requiredRule = itemControl.getRequiredRule();
        }
        if (requiredRule == null && defaultControl != null) {
            requiredRule = defaultControl.getRequiredRule();
        }
        if (requiredRule != null) {
            CaseControlRule caseRule = this.initializeCaseControlRule(requiredRule.getCondition(), context);
            activity.setProperty(PROPERTY_REQUIRED_RULE, caseRule);
        }
    }

    protected void initializeManualActivationRule(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context) {
        PlanItemControl itemControl = this.getItemControl(element);
        PlanItemControl defaultControl = this.getDefaultControl(element);
        ManualActivationRule manualActivationRule = null;
        if (itemControl != null) {
            manualActivationRule = itemControl.getManualActivationRule();
        }
        if (manualActivationRule == null && defaultControl != null) {
            manualActivationRule = defaultControl.getManualActivationRule();
        }
        if (manualActivationRule != null) {
            CaseControlRule caseRule = this.initializeCaseControlRule(manualActivationRule.getCondition(), context);
            activity.setProperty(PROPERTY_MANUAL_ACTIVATION_RULE, caseRule);
        }
    }

    protected void initializeRepetitionRule(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context) {
        PlanItemControl itemControl = this.getItemControl(element);
        PlanItemControl defaultControl = this.getDefaultControl(element);
        RepetitionRule repetitionRule = null;
        if (itemControl != null) {
            repetitionRule = itemControl.getRepetitionRule();
        }
        if (repetitionRule == null && defaultControl != null) {
            repetitionRule = defaultControl.getRepetitionRule();
        }
        if (repetitionRule != null) {
            ConditionExpression condition = repetitionRule.getCondition();
            CaseControlRule caseRule = this.initializeCaseControlRule(condition, context);
            activity.setProperty(PROPERTY_REPETITION_RULE, caseRule);
            List<String> events = Arrays.asList("terminate", "complete");
            String repeatOnStandardEvent = repetitionRule.getCamundaRepeatOnStandardEvent();
            if (repeatOnStandardEvent != null && !repeatOnStandardEvent.isEmpty()) {
                events = Arrays.asList(repeatOnStandardEvent);
            }
            activity.getProperties().set(CmmnProperties.REPEAT_ON_STANDARD_EVENTS, events);
        }
    }

    protected CaseControlRule initializeCaseControlRule(ConditionExpression condition, CmmnHandlerContext context) {
        String rule;
        Expression expression = null;
        if (condition != null && (rule = condition.getText()) != null && !rule.isEmpty()) {
            ExpressionManager expressionManager = context.getExpressionManager();
            expression = expressionManager.createExpression(rule);
        }
        return new CaseControlRuleImpl(expression);
    }

    protected void initializeCaseExecutionListeners(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context) {
        PlanItemDefinition definition = this.getDefinition(element);
        List<CamundaCaseExecutionListener> listeners = this.queryExtensionElementsByClass((CmmnElement)definition, CamundaCaseExecutionListener.class);
        for (CamundaCaseExecutionListener listener : listeners) {
            CaseExecutionListener caseExecutionListener = this.initializeCaseExecutionListener(element, activity, context, listener);
            String eventName = listener.getCamundaEvent();
            if (eventName != null) {
                activity.addListener(eventName, caseExecutionListener);
                continue;
            }
            for (String event : this.getStandardEvents(element)) {
                activity.addListener(event, caseExecutionListener);
            }
        }
    }

    protected CaseExecutionListener initializeCaseExecutionListener(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context, CamundaCaseExecutionListener listener) {
        ExecutableScript executableScript;
        Collection fields = listener.getCamundaFields();
        List<FieldDeclaration> fieldDeclarations = this.initializeFieldDeclarations(element, activity, context, fields);
        ExpressionManager expressionManager = context.getExpressionManager();
        CaseExecutionListener caseExecutionListener = null;
        String className = listener.getCamundaClass();
        String expression = listener.getCamundaExpression();
        String delegateExpression = listener.getCamundaDelegateExpression();
        CamundaScript scriptElement = listener.getCamundaScript();
        if (className != null) {
            caseExecutionListener = new ClassDelegateCaseExecutionListener(className, fieldDeclarations);
        } else if (expression != null) {
            Expression expressionExp = expressionManager.createExpression(expression);
            caseExecutionListener = new ExpressionCaseExecutionListener(expressionExp);
        } else if (delegateExpression != null) {
            Expression delegateExp = expressionManager.createExpression(delegateExpression);
            caseExecutionListener = new DelegateExpressionCaseExecutionListener(delegateExp, fieldDeclarations);
        } else if (scriptElement != null && (executableScript = this.initializeScript(element, activity, context, scriptElement)) != null) {
            caseExecutionListener = new ScriptCaseExecutionListener(executableScript);
        }
        return caseExecutionListener;
    }

    protected void initializeVariableListeners(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context) {
        PlanItemDefinition definition = this.getDefinition(element);
        List<CamundaVariableListener> listeners = this.queryExtensionElementsByClass((CmmnElement)definition, CamundaVariableListener.class);
        for (CamundaVariableListener listener : listeners) {
            CaseVariableListener variableListener = this.initializeVariableListener(element, activity, context, listener);
            String eventName = listener.getCamundaEvent();
            if (eventName != null) {
                activity.addVariableListener(eventName, variableListener);
                continue;
            }
            for (String event : DEFAULT_VARIABLE_EVENTS) {
                activity.addVariableListener(event, variableListener);
            }
        }
    }

    protected CaseVariableListener initializeVariableListener(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context, CamundaVariableListener listener) {
        ExecutableScript executableScript;
        Collection fields = listener.getCamundaFields();
        List<FieldDeclaration> fieldDeclarations = this.initializeFieldDeclarations(element, activity, context, fields);
        ExpressionManager expressionManager = context.getExpressionManager();
        String className = listener.getCamundaClass();
        String expression = listener.getCamundaExpression();
        String delegateExpression = listener.getCamundaDelegateExpression();
        CamundaScript scriptElement = listener.getCamundaScript();
        CaseVariableListener variableListener = null;
        if (className != null) {
            variableListener = new ClassDelegateCaseVariableListener(className, fieldDeclarations);
        } else if (expression != null) {
            Expression expressionExp = expressionManager.createExpression(expression);
            variableListener = new ExpressionCaseVariableListener(expressionExp);
        } else if (delegateExpression != null) {
            Expression delegateExp = expressionManager.createExpression(delegateExpression);
            variableListener = new DelegateExpressionCaseVariableListener(delegateExp, fieldDeclarations);
        } else if (scriptElement != null && (executableScript = this.initializeScript(element, activity, context, scriptElement)) != null) {
            variableListener = new ScriptCaseVariableListener(executableScript);
        }
        return variableListener;
    }

    protected ExecutableScript initializeScript(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context, CamundaScript script) {
        String language = script.getCamundaScriptFormat();
        String resource = script.getCamundaResource();
        String source = script.getTextContent();
        if (language == null) {
            language = "juel";
        }
        try {
            return ScriptUtil.getScript(language, source, resource, context.getExpressionManager());
        }
        catch (ProcessEngineException e) {
            return null;
        }
    }

    protected List<FieldDeclaration> initializeFieldDeclarations(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context, Collection<CamundaField> fields) {
        ArrayList<FieldDeclaration> fieldDeclarations = new ArrayList<FieldDeclaration>();
        for (CamundaField field : fields) {
            FieldDeclaration fieldDeclaration = this.initializeFieldDeclaration(element, activity, context, field);
            fieldDeclarations.add(fieldDeclaration);
        }
        return fieldDeclarations;
    }

    protected FieldDeclaration initializeFieldDeclaration(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context, CamundaField field) {
        String name = field.getCamundaName();
        String type = org.eximeebpms.bpm.engine.delegate.Expression.class.getName();
        org.eximeebpms.bpm.engine.delegate.Expression value = this.getFixedValue(field);
        if (value == null) {
            ExpressionManager expressionManager = context.getExpressionManager();
            value = this.getExpressionValue(field, expressionManager);
        }
        return new FieldDeclaration(name, type, value);
    }

    protected FixedValue getFixedValue(CamundaField field) {
        CamundaString strg = field.getCamundaString();
        String value = null;
        if (strg != null) {
            value = strg.getTextContent();
        }
        if (value == null) {
            value = field.getCamundaStringValue();
        }
        if (value != null) {
            return new FixedValue(value);
        }
        return null;
    }

    protected org.eximeebpms.bpm.engine.delegate.Expression getExpressionValue(CamundaField field, ExpressionManager expressionManager) {
        CamundaExpression expression = field.getCamundaExpressionChild();
        String value = null;
        if (expression != null) {
            value = expression.getTextContent();
        }
        if (value == null) {
            value = field.getCamundaExpression();
        }
        if (value != null) {
            return expressionManager.createExpression(value);
        }
        return null;
    }

    protected void initializeEntryCriterias(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context) {
        CmmnActivity parent;
        Collection<Sentry> entryCriterias = this.getEntryCriterias(element);
        if (!entryCriterias.isEmpty() && (parent = activity.getParent()) != null) {
            for (Sentry sentry : entryCriterias) {
                String sentryId = sentry.getId();
                CmmnSentryDeclaration sentryDeclaration = parent.getSentry(sentryId);
                if (sentryDeclaration == null) continue;
                activity.addEntryCriteria(sentryDeclaration);
            }
        }
    }

    protected void initializeExitCriterias(CmmnElement element, CmmnActivity activity, CmmnHandlerContext context) {
        CmmnActivity parent;
        Collection<Sentry> exitCriterias = this.getExitCriterias(element);
        if (!exitCriterias.isEmpty() && (parent = activity.getParent()) != null) {
            for (Sentry sentry : exitCriterias) {
                String sentryId = sentry.getId();
                CmmnSentryDeclaration sentryDeclaration = parent.getSentry(sentryId);
                if (sentryDeclaration == null) continue;
                activity.addExitCriteria(sentryDeclaration);
            }
        }
    }

    protected PlanItemControl getDefaultControl(CmmnElement element) {
        PlanItemDefinition definition = this.getDefinition(element);
        return definition.getDefaultControl();
    }

    protected <V extends ModelElementInstance> List<V> queryExtensionElementsByClass(CmmnElement element, Class<V> cls) {
        ExtensionElements extensionElements = this.getExtensionElements(element);
        if (extensionElements != null) {
            Query query = extensionElements.getElementsQuery();
            return query.filterByType(cls).list();
        }
        return new ArrayList();
    }

    protected ExtensionElements getExtensionElements(CmmnElement element) {
        return element.getExtensionElements();
    }

    protected PlanItemControl getItemControl(CmmnElement element) {
        if (this.isPlanItem(element)) {
            PlanItem planItem = (PlanItem)element;
            return planItem.getItemControl();
        }
        if (this.isDiscretionaryItem(element)) {
            DiscretionaryItem discretionaryItem = (DiscretionaryItem)element;
            return discretionaryItem.getItemControl();
        }
        return null;
    }

    protected String getName(CmmnElement element) {
        PlanItemDefinition definition;
        String name = null;
        if (this.isPlanItem(element)) {
            PlanItem planItem = (PlanItem)element;
            name = planItem.getName();
        }
        if ((name == null || name.isEmpty()) && (definition = this.getDefinition(element)) != null) {
            name = definition.getName();
        }
        return name;
    }

    protected PlanItemDefinition getDefinition(CmmnElement element) {
        if (this.isPlanItem(element)) {
            PlanItem planItem = (PlanItem)element;
            return planItem.getDefinition();
        }
        if (this.isDiscretionaryItem(element)) {
            DiscretionaryItem discretionaryItem = (DiscretionaryItem)element;
            return discretionaryItem.getDefinition();
        }
        return null;
    }

    protected Collection<Sentry> getEntryCriterias(CmmnElement element) {
        if (this.isPlanItem(element)) {
            PlanItem planItem = (PlanItem)element;
            return planItem.getEntryCriteria();
        }
        return new ArrayList<Sentry>();
    }

    protected Collection<Sentry> getExitCriterias(CmmnElement element) {
        if (this.isPlanItem(element)) {
            PlanItem planItem = (PlanItem)element;
            return planItem.getExitCriteria();
        }
        return new ArrayList<Sentry>();
    }

    protected String getDesciption(CmmnElement element) {
        String description = element.getDescription();
        if (description == null) {
            PlanItemDefinition definition = this.getDefinition(element);
            description = definition.getDescription();
        }
        return description;
    }

    protected String getDocumentation(CmmnElement element) {
        Collection documentations = element.getDocumentations();
        if (documentations.isEmpty()) {
            PlanItemDefinition definition = this.getDefinition(element);
            documentations = definition.getDocumentations();
        }
        if (documentations.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (Documentation doc : documentations) {
            String content = doc.getTextContent();
            if (content == null || content.isEmpty()) continue;
            if (builder.length() != 0) {
                builder.append("\n\n");
            }
            builder.append(content.trim());
        }
        return builder.toString();
    }

    protected boolean isPlanItem(CmmnElement element) {
        return element instanceof PlanItem;
    }

    protected boolean isDiscretionaryItem(CmmnElement element) {
        return element instanceof DiscretionaryItem;
    }

    protected abstract List<String> getStandardEvents(CmmnElement var1);

    static {
        TASK_OR_STAGE_EVENTS.addAll(TASK_OR_STAGE_CREATE_EVENTS);
        TASK_OR_STAGE_EVENTS.addAll(TASK_OR_STAGE_UPDATE_EVENTS);
        TASK_OR_STAGE_EVENTS.addAll(TASK_OR_STAGE_END_EVENTS);
        EVENT_LISTENER_OR_MILESTONE_EVENTS.addAll(EVENT_LISTENER_OR_MILESTONE_CREATE_EVENTS);
        EVENT_LISTENER_OR_MILESTONE_EVENTS.addAll(EVENT_LISTENER_OR_MILESTONE_UPDATE_EVENTS);
        EVENT_LISTENER_OR_MILESTONE_EVENTS.addAll(EVENT_LISTENER_OR_MILESTONE_END_EVENTS);
        CASE_PLAN_MODEL_EVENTS.addAll(CASE_PLAN_MODEL_CREATE_EVENTS);
        CASE_PLAN_MODEL_EVENTS.addAll(CASE_PLAN_MODEL_UPDATE_EVENTS);
        CASE_PLAN_MODEL_EVENTS.addAll(CASE_PLAN_MODEL_CLOSE_EVENTS);
    }
}

