/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.db.sql;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.executor.BatchExecutorException;
import org.apache.ibatis.executor.BatchResult;
import org.eximeebpms.bpm.engine.impl.db.DbEntity;
import org.eximeebpms.bpm.engine.impl.db.FlushResult;
import org.eximeebpms.bpm.engine.impl.db.entitymanager.operation.DbBulkOperation;
import org.eximeebpms.bpm.engine.impl.db.entitymanager.operation.DbEntityOperation;
import org.eximeebpms.bpm.engine.impl.db.entitymanager.operation.DbOperation;
import org.eximeebpms.bpm.engine.impl.db.entitymanager.operation.DbOperationType;
import org.eximeebpms.bpm.engine.impl.db.sql.DbSqlSession;
import org.eximeebpms.bpm.engine.impl.db.sql.DbSqlSessionFactory;
import org.eximeebpms.bpm.engine.impl.util.CollectionUtil;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;
import org.eximeebpms.bpm.engine.impl.util.ExceptionUtil;

public class BatchDbSqlSession
extends DbSqlSession {
    public BatchDbSqlSession(DbSqlSessionFactory dbSqlSessionFactory) {
        super(dbSqlSessionFactory);
    }

    public BatchDbSqlSession(DbSqlSessionFactory dbSqlSessionFactory, Connection connection, String catalog, String schema) {
        super(dbSqlSessionFactory, connection, catalog, schema);
    }

    @Override
    public FlushResult executeDbOperations(List<DbOperation> operations) {
        List<BatchResult> batchResults;
        for (DbOperation operation : operations) {
            this.executeDbOperation(operation);
        }
        try {
            batchResults = this.flushBatchOperations();
        }
        catch (PersistenceException e) {
            return this.postProcessBatchFailure(operations, e);
        }
        return this.postProcessBatchSuccess(operations, batchResults);
    }

    protected FlushResult postProcessBatchSuccess(List<DbOperation> operations, List<BatchResult> batchResults) {
        Iterator<DbOperation> operationsIt = operations.iterator();
        ArrayList<DbOperation> failedOperations = new ArrayList<DbOperation>();
        for (BatchResult successfulBatch : batchResults) {
            this.postProcessJdbcBatchResult(operationsIt, successfulBatch.getUpdateCounts(), null, failedOperations);
        }
        if (operationsIt.hasNext()) {
            throw LOG.wrongBatchResultsSizeException(operations);
        }
        return FlushResult.withFailures(failedOperations);
    }

    protected FlushResult postProcessBatchFailure(List<DbOperation> operations, PersistenceException exception) {
        BatchExecutorException batchExecutorException = ExceptionUtil.findBatchExecutorException(exception);
        if (batchExecutorException == null) {
            throw exception;
        }
        List successfulBatches = batchExecutorException.getSuccessfulBatchResults();
        BatchUpdateException cause = batchExecutorException.getBatchUpdateException();
        Iterator<DbOperation> operationsIt = operations.iterator();
        ArrayList<DbOperation> failedOperations = new ArrayList<DbOperation>();
        for (BatchResult successfulBatch : successfulBatches) {
            this.postProcessJdbcBatchResult(operationsIt, successfulBatch.getUpdateCounts(), null, failedOperations);
        }
        int[] failedBatchUpdateCounts = cause.getUpdateCounts();
        this.postProcessJdbcBatchResult(operationsIt, failedBatchUpdateCounts, exception, failedOperations);
        List<DbOperation> remainingOperations = CollectionUtil.collectInList(operationsIt);
        return FlushResult.withFailuresAndRemaining(failedOperations, remainingOperations);
    }

    protected void postProcessJdbcBatchResult(Iterator<DbOperation> operationsIt, int[] statementResults, PersistenceException failure, List<DbOperation> failedOperations) {
        boolean failureHandled = false;
        for (int statementResult : statementResults) {
            EnsureUtil.ensureTrue("More batch results than scheduled operations detected. This indicates a bug", operationsIt.hasNext());
            DbOperation operation = operationsIt.next();
            if (statementResult == -2) {
                if (this.requiresAffectedRows(operation.getOperationType())) {
                    throw LOG.batchingNotSupported(operation);
                }
                this.postProcessOperationPerformed(operation, 1, null);
            } else if (statementResult == -3) {
                this.postProcessOperationPerformed(operation, 0, failure);
                failureHandled = true;
            } else {
                this.postProcessOperationPerformed(operation, statementResult, null);
            }
            if (!operation.isFailed()) continue;
            failedOperations.add(operation);
        }
        if (failure != null && !failureHandled) {
            EnsureUtil.ensureTrue("More batch results than scheduled operations detected. This indicates a bug", operationsIt.hasNext());
            DbOperation failedOperation = operationsIt.next();
            this.postProcessOperationPerformed(failedOperation, 0, failure);
            if (failedOperation.isFailed()) {
                failedOperations.add(failedOperation);
            }
        }
    }

    protected boolean requiresAffectedRows(DbOperationType operationType) {
        return operationType != DbOperationType.INSERT;
    }

    protected void postProcessOperationPerformed(DbOperation operation, int rowsAffected, PersistenceException failure) {
        switch (operation.getOperationType()) {
            case INSERT: {
                this.entityInsertPerformed((DbEntityOperation)operation, rowsAffected, failure);
                break;
            }
            case DELETE: {
                this.entityDeletePerformed((DbEntityOperation)operation, rowsAffected, failure);
                break;
            }
            case DELETE_BULK: {
                this.bulkDeletePerformed((DbBulkOperation)operation, rowsAffected, failure);
                break;
            }
            case UPDATE: {
                this.entityUpdatePerformed((DbEntityOperation)operation, rowsAffected, failure);
                break;
            }
            case UPDATE_BULK: {
                this.bulkUpdatePerformed((DbBulkOperation)operation, rowsAffected, failure);
            }
        }
    }

    @Override
    protected void updateEntity(DbEntityOperation operation) {
        DbEntity dbEntity = operation.getEntity();
        String updateStatement = this.dbSqlSessionFactory.getUpdateStatement(dbEntity);
        EnsureUtil.ensureNotNull("no update statement for " + dbEntity.getClass() + " in the ibatis mapping files", "updateStatement", (Object)updateStatement);
        LOG.executeDatabaseOperation("UPDATE", dbEntity);
        this.executeUpdate(updateStatement, dbEntity);
    }

    @Override
    protected void updateBulk(DbBulkOperation operation) {
        String statement = operation.getStatement();
        Object parameter = operation.getParameter();
        LOG.executeDatabaseBulkOperation("UPDATE", statement, parameter);
        this.executeUpdate(statement, parameter);
    }

    @Override
    protected void deleteBulk(DbBulkOperation operation) {
        String statement = operation.getStatement();
        Object parameter = operation.getParameter();
        LOG.executeDatabaseBulkOperation("DELETE", statement, parameter);
        this.executeDelete(statement, parameter);
    }

    @Override
    protected void deleteEntity(DbEntityOperation operation) {
        DbEntity dbEntity = operation.getEntity();
        String deleteStatement = this.dbSqlSessionFactory.getDeleteStatement(dbEntity.getClass());
        EnsureUtil.ensureNotNull("no delete statement for " + dbEntity.getClass() + " in the ibatis mapping files", "deleteStatement", (Object)deleteStatement);
        LOG.executeDatabaseOperation("DELETE", dbEntity);
        this.executeDelete(deleteStatement, dbEntity);
    }

    @Override
    protected void executeSelectForUpdate(String statement, Object parameter) {
        this.executeSelectList(statement, parameter);
    }
}

