/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.diagnostics;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eximeebpms.bpm.engine.impl.diagnostics.CommandCounter;
import org.eximeebpms.bpm.engine.impl.diagnostics.DiagnosticsRegistry;
import org.eximeebpms.bpm.engine.impl.metrics.Meter;
import org.eximeebpms.bpm.engine.impl.metrics.MetricsRegistry;
import org.eximeebpms.bpm.engine.impl.metrics.util.MetricsUtil;
import org.eximeebpms.bpm.engine.impl.telemetry.dto.ApplicationServerImpl;
import org.eximeebpms.bpm.engine.impl.telemetry.dto.CommandImpl;
import org.eximeebpms.bpm.engine.impl.telemetry.dto.InternalsImpl;
import org.eximeebpms.bpm.engine.impl.telemetry.dto.MetricImpl;
import org.eximeebpms.bpm.engine.impl.telemetry.dto.TelemetryDataImpl;
import org.eximeebpms.bpm.engine.telemetry.Command;
import org.eximeebpms.bpm.engine.telemetry.Metric;

public class DiagnosticsCollector {
    protected static final Set<String> METRICS_TO_REPORT = Set.of("root-process-instance-start", "executed-decision-instances", "executed-decision-elements", "activity-instance-start");
    protected TelemetryDataImpl staticData;
    protected DiagnosticsRegistry diagnosticsRegistry;
    protected MetricsRegistry metricsRegistry;

    public DiagnosticsCollector(TelemetryDataImpl data, DiagnosticsRegistry diagnosticsRegistry, MetricsRegistry metricsRegistry) {
        this.staticData = data;
        this.diagnosticsRegistry = diagnosticsRegistry;
        this.metricsRegistry = metricsRegistry;
    }

    public TelemetryDataImpl updateAndFetchData() {
        this.updateStaticData();
        InternalsImpl dynamicData = this.resolveDynamicData();
        TelemetryDataImpl mergedData = new TelemetryDataImpl(this.staticData);
        mergedData.mergeInternals(dynamicData);
        return mergedData;
    }

    protected void updateStaticData() {
        InternalsImpl internals = this.staticData.getProduct().getInternals();
        if (internals.getApplicationServer() == null) {
            ApplicationServerImpl applicationServer = this.diagnosticsRegistry.getApplicationServer();
            internals.setApplicationServer(applicationServer);
        }
        internals.setLicenseKey(this.diagnosticsRegistry.getLicenseKey());
        internals.setWebapps(this.diagnosticsRegistry.getWebapps());
    }

    protected InternalsImpl resolveDynamicData() {
        InternalsImpl result = new InternalsImpl();
        Map<String, Metric> metrics = this.calculateMetrics();
        result.setMetrics(metrics);
        Map<String, Command> commands = this.fetchAndResetCommandCounts();
        result.setCommands(commands);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Command> fetchAndResetCommandCounts() {
        Map<String, CommandCounter> originalCounts;
        HashMap<String, Command> commandsToReport = new HashMap<String, Command>();
        Map<String, CommandCounter> map = originalCounts = this.diagnosticsRegistry.getCommands();
        synchronized (map) {
            for (Map.Entry<String, CommandCounter> counter : originalCounts.entrySet()) {
                long occurrences = counter.getValue().get();
                commandsToReport.put(counter.getKey(), new CommandImpl(occurrences));
            }
        }
        return commandsToReport;
    }

    protected Map<String, Metric> calculateMetrics() {
        HashMap<String, Metric> metrics = new HashMap<String, Metric>();
        if (this.metricsRegistry != null) {
            Map<String, Meter> telemetryMeters = this.metricsRegistry.getDiagnosticsMeters();
            for (String metricToReport : METRICS_TO_REPORT) {
                long value = telemetryMeters.get(metricToReport).get();
                metrics.put(MetricsUtil.resolvePublicName(metricToReport), new MetricImpl(value));
            }
        }
        return metrics;
    }
}

