/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.digest;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.eximeebpms.bpm.engine.ProcessEngineException;
import org.eximeebpms.bpm.engine.impl.digest._apacheCommonsCodec.Base64;

public abstract class Base64EncodedHashDigest {
    public String encrypt(String password) {
        byte[] hash = this.createByteHash(password);
        return this.encodeHash(hash);
    }

    public boolean check(String password, String encrypted) {
        return this.encrypt(password).equals(encrypted);
    }

    protected byte[] createByteHash(String password) {
        MessageDigest digest = this.createDigestInstance();
        try {
            digest.update(password.getBytes("UTF-8"));
            return digest.digest();
        }
        catch (UnsupportedEncodingException e) {
            throw new ProcessEngineException("UnsupportedEncodingException while calculating password digest");
        }
    }

    protected MessageDigest createDigestInstance() {
        try {
            return MessageDigest.getInstance(this.hashAlgorithmName());
        }
        catch (NoSuchAlgorithmException e) {
            throw new ProcessEngineException("Cannot lookup " + this.hashAlgorithmName() + " algorithm");
        }
    }

    protected String encodeHash(byte[] hash) {
        return new String(Base64.encodeBase64(hash));
    }

    protected abstract String hashAlgorithmName();
}

