/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.digest;

import java.security.SecureRandom;
import java.util.Random;
import org.eximeebpms.bpm.engine.impl.digest.SaltGenerator;
import org.eximeebpms.bpm.engine.impl.digest._apacheCommonsCodec.Base64;

public abstract class Base64EncodedSaltGenerator
implements SaltGenerator {
    protected Random secureRandom = new SecureRandom();

    @Override
    public String generateSalt() {
        byte[] byteSalt = this.generateByteSalt();
        return this.encodeSalt(byteSalt);
    }

    protected byte[] generateByteSalt() {
        byte[] salt = new byte[this.getSaltLengthInByte().intValue()];
        this.secureRandom.nextBytes(salt);
        return salt;
    }

    protected String encodeSalt(byte[] salt) {
        return new String(Base64.encodeBase64(salt));
    }

    protected abstract Integer getSaltLengthInByte();
}

