/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.digest;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DatabasePrefixHandler {
    protected Pattern pattern = Pattern.compile("^\\{(.*?)\\}");

    public String generatePrefix(String algorithmName) {
        return "{" + algorithmName + "}";
    }

    public String retrieveAlgorithmName(String encryptedPasswordWithPrefix) {
        Matcher matcher = this.pattern.matcher(encryptedPasswordWithPrefix);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public String removePrefix(String encryptedPasswordWithPrefix) {
        int index = encryptedPasswordWithPrefix.indexOf("}");
        if (!encryptedPasswordWithPrefix.startsWith("{") || index < 0) {
            return null;
        }
        return encryptedPasswordWithPrefix.substring(index + 1);
    }
}

