/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.dmn.cmd;

import java.util.ArrayList;
import org.eximeebpms.bpm.engine.impl.HistoricDecisionInstanceQueryImpl;
import org.eximeebpms.bpm.engine.impl.cfg.CommandChecker;
import org.eximeebpms.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionEntity;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.entity.PropertyChange;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;

public class DeleteHistoricDecisionInstanceByDefinitionIdCmd
implements Command<Object> {
    protected final String decisionDefinitionId;

    public DeleteHistoricDecisionInstanceByDefinitionIdCmd(String decisionDefinitionId) {
        this.decisionDefinitionId = decisionDefinitionId;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("decisionDefinitionId", (Object)this.decisionDefinitionId);
        DecisionDefinitionEntity decisionDefinition = commandContext.getDecisionDefinitionManager().findDecisionDefinitionById(this.decisionDefinitionId);
        EnsureUtil.ensureNotNull("No decision definition found with id: " + this.decisionDefinitionId, "decisionDefinition", (Object)decisionDefinition);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkDeleteHistoricDecisionInstance(decisionDefinition.getKey());
        }
        long numInstances = this.getDecisionInstanceCount(commandContext);
        this.writeUserOperationLog(commandContext, numInstances);
        commandContext.getHistoricDecisionInstanceManager().deleteHistoricDecisionInstancesByDecisionDefinitionId(this.decisionDefinitionId);
        return null;
    }

    protected void writeUserOperationLog(CommandContext commandContext, long numInstances) {
        ArrayList<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
        propertyChanges.add(new PropertyChange("nrOfInstances", null, numInstances));
        propertyChanges.add(new PropertyChange("async", null, false));
        commandContext.getOperationLogManager().logDecisionInstanceOperation("DeleteHistory", null, propertyChanges);
    }

    protected long getDecisionInstanceCount(CommandContext commandContext) {
        HistoricDecisionInstanceQueryImpl historicDecisionInstanceQuery = new HistoricDecisionInstanceQueryImpl();
        historicDecisionInstanceQuery.decisionDefinitionId(this.decisionDefinitionId);
        return commandContext.getHistoricDecisionInstanceManager().findHistoricDecisionInstanceCountByQueryCriteria(historicDecisionInstanceQuery);
    }
}

