/*
 * Decompiled with CFR 0.152.
 */
package org.eximeebpms.bpm.engine.impl.dmn.cmd;

import org.eximeebpms.bpm.engine.exception.dmn.DmnModelInstanceNotFoundException;
import org.eximeebpms.bpm.engine.impl.cfg.CommandChecker;
import org.eximeebpms.bpm.engine.impl.context.Context;
import org.eximeebpms.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionEntity;
import org.eximeebpms.bpm.engine.impl.interceptor.Command;
import org.eximeebpms.bpm.engine.impl.interceptor.CommandContext;
import org.eximeebpms.bpm.engine.impl.persistence.deploy.cache.DeploymentCache;
import org.eximeebpms.bpm.engine.impl.util.EnsureUtil;
import org.eximeebpms.bpm.model.dmn.DmnModelInstance;

public class GetDeploymentDmnModelInstanceCmd
implements Command<DmnModelInstance> {
    protected String decisionDefinitionId;

    public GetDeploymentDmnModelInstanceCmd(String decisionDefinitionId) {
        this.decisionDefinitionId = decisionDefinitionId;
    }

    @Override
    public DmnModelInstance execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("decisionDefinitionId", (Object)this.decisionDefinitionId);
        DeploymentCache deploymentCache = Context.getProcessEngineConfiguration().getDeploymentCache();
        DecisionDefinitionEntity decisionDefinition = deploymentCache.findDeployedDecisionDefinitionById(this.decisionDefinitionId);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadDecisionDefinition(decisionDefinition);
        }
        DmnModelInstance modelInstance = deploymentCache.findDmnModelInstanceForDecisionDefinition(this.decisionDefinitionId);
        EnsureUtil.ensureNotNull(DmnModelInstanceNotFoundException.class, "No DMN model instance found for decision definition id " + this.decisionDefinitionId, "modelInstance", (Object)modelInstance);
        return modelInstance;
    }
}

